/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.threadsafety.AutoValue_GuardedByUtils_GuardedByValidationResult;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByBinder;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByExpression;
import com.google.errorprone.bugpatterns.threadsafety.GuardedBySymbolResolver;
import com.google.errorprone.bugpatterns.threadsafety.IllegalGuardedBy;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;

public class GuardedByUtils {
    public static ImmutableSet<String> getGuardValues(Symbol sym) {
        return GuardedByUtils.getAnnotationValueAsStrings(sym, "GuardedBy");
    }

    static ImmutableSet<String> getGuardValues(Tree tree, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        if (sym == null) {
            return null;
        }
        return GuardedByUtils.getAnnotationValueAsStrings(sym, "GuardedBy");
    }

    private static ImmutableSet<String> getAnnotationValueAsStrings(Symbol sym, String guardedBy) {
        return (ImmutableSet)sym.getRawAttributes().stream().filter(a -> a.getAnnotationType().asElement().getSimpleName().contentEquals(guardedBy)).flatMap(a -> a.getElementValues().entrySet().stream().filter(e -> ((Name)((Symbol.MethodSymbol)e.getKey()).getSimpleName()).contentEquals("value")).map(Map.Entry::getValue).findFirst().map(v -> GuardedByUtils.asStrings(v)).orElse(Stream.empty())).collect(ImmutableSet.toImmutableSet());
    }

    private static Stream<String> asStrings(Attribute v) {
        return (Stream)MoreObjects.firstNonNull(v.accept(new SimpleAnnotationValueVisitor8<Stream<String>, Void>(){

            @Override
            public Stream<String> visitString(String s, Void aVoid) {
                return Stream.of(s);
            }

            @Override
            public Stream<String> visitArray(List<? extends AnnotationValue> list, Void aVoid) {
                return list.stream().flatMap(a -> a.accept(this, null)).filter(x -> x != null);
            }
        }, null), Stream.empty());
    }

    public static JCTree.JCExpression parseString(String guardedByString, Context context) {
        JCTree.JCExpression exp;
        JavacParser parser = ParserFactory.instance(context).newParser(guardedByString, false, true, false);
        try {
            exp = parser.parseExpression();
        }
        catch (Throwable e) {
            throw new IllegalGuardedBy(e.getMessage());
        }
        int len = parser.getEndPos(exp) - exp.getStartPosition();
        if (len != guardedByString.length()) {
            throw new IllegalGuardedBy("Didn't parse entire string.");
        }
        return exp;
    }

    public static GuardedByValidationResult isGuardedByValid(Tree tree, VisitorState state) {
        ImmutableSet<String> guards = GuardedByUtils.getGuardValues(tree, state);
        if (guards.isEmpty()) {
            return GuardedByValidationResult.ok();
        }
        ArrayList<GuardedByExpression> boundGuards = new ArrayList<GuardedByExpression>();
        for (String guard : guards) {
            Object boundGuard = GuardedByBinder.bindString(guard, GuardedBySymbolResolver.from(tree, state));
            if (!((Optional)boundGuard).isPresent()) {
                return GuardedByValidationResult.invalid("could not resolve guard");
            }
            boundGuards.add((GuardedByExpression)((Optional)boundGuard).get());
        }
        Symbol treeSym = ASTHelpers.getSymbol((Tree)tree);
        if (treeSym == null) {
            return GuardedByValidationResult.ok();
        }
        for (Object boundGuard : boundGuards) {
            boolean staticGuard;
            boolean bl = staticGuard = ((GuardedByExpression)boundGuard).kind() == GuardedByExpression.Kind.CLASS_LITERAL || ((GuardedByExpression)boundGuard).sym() != null && ((GuardedByExpression)boundGuard).sym().isStatic();
            if (!treeSym.isStatic() || staticGuard) continue;
            return GuardedByValidationResult.invalid("static member guarded by instance");
        }
        return GuardedByValidationResult.ok();
    }

    public static Symbol bindGuardedByString(Tree tree, String guard, VisitorState visitorState) {
        Optional<GuardedByExpression> bound = GuardedByBinder.bindString(guard, GuardedBySymbolResolver.from(tree, visitorState));
        if (!bound.isPresent()) {
            return null;
        }
        return bound.get().sym();
    }

    @AutoValue
    static abstract class GuardedByValidationResult {
        GuardedByValidationResult() {
        }

        abstract String message();

        abstract Boolean isValid();

        static GuardedByValidationResult invalid(String message) {
            return new AutoValue_GuardedByUtils_GuardedByValidationResult(message, false);
        }

        static GuardedByValidationResult ok() {
            return new AutoValue_GuardedByUtils_GuardedByValidationResult("", true);
        }
    }
}

