/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.AutoValue_DoubleCheckedLocking_DCLInfo;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

@BugPattern(name="DoubleCheckedLocking", summary="Double-checked locking on non-volatile fields is unsafe", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"}, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class DoubleCheckedLocking
extends BugChecker
implements BugChecker.IfTreeMatcher {
    private static final ImmutableSet<String> IMMUTABLE_WHITELIST = ImmutableSet.of((Object)Boolean.class.getName(), (Object)Byte.class.getName(), (Object)Short.class.getName(), (Object)Integer.class.getName(), (Object)Character.class.getName(), (Object)Float.class.getName(), (Object[])new String[]{String.class.getName()});

    public Description matchIf(IfTree outerIf, VisitorState state) {
        DCLInfo info = DoubleCheckedLocking.findDCL(outerIf);
        if (info == null) {
            return Description.NO_MATCH;
        }
        switch (info.sym().getKind()) {
            case FIELD: {
                return this.handleField(info.outerIf(), info.sym(), state);
            }
            case LOCAL_VARIABLE: {
                return this.handleLocal(info, state);
            }
        }
        return Description.NO_MATCH;
    }

    private Description handleField(IfTree outerIf, Symbol.VarSymbol sym, VisitorState state) {
        if (sym.getModifiers().contains((Object)Modifier.VOLATILE)) {
            return Description.NO_MATCH;
        }
        if (DoubleCheckedLocking.isImmutable(sym.type, state)) {
            return Description.NO_MATCH;
        }
        Description.Builder builder = this.buildDescription(outerIf);
        JCTree fieldDecl = DoubleCheckedLocking.findFieldDeclaration(state.getPath(), sym);
        if (fieldDecl != null) {
            builder.addFix(SuggestedFixes.addModifiers((Tree)fieldDecl, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.VOLATILE}));
        }
        return builder.build();
    }

    private static boolean isImmutable(Type type, VisitorState state) {
        switch (type.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case CHAR: 
            case FLOAT: {
                return true;
            }
            case LONG: 
            case DOUBLE: {
                return true;
            }
        }
        return IMMUTABLE_WHITELIST.contains((Object)state.getTypes().erasure((Type)type).tsym.getQualifiedName().toString());
    }

    private Description handleLocal(DCLInfo info, VisitorState state) {
        JCTree.JCExpressionStatement expr = DoubleCheckedLocking.getChild(info.synchTree().getBlock(), JCTree.JCExpressionStatement.class);
        if (expr == null) {
            return Description.NO_MATCH;
        }
        if (expr.getStartPosition() > ((JCTree)((Object)info.innerIf())).getStartPosition()) {
            return Description.NO_MATCH;
        }
        if (!(expr.getExpression() instanceof JCTree.JCAssign)) {
            return Description.NO_MATCH;
        }
        JCTree.JCAssign assign = (JCTree.JCAssign)expr.getExpression();
        if (!Objects.equals(ASTHelpers.getSymbol((Tree)assign.getVariable()), info.sym())) {
            return Description.NO_MATCH;
        }
        Symbol sym = ASTHelpers.getSymbol((Tree)assign.getExpression());
        if (!(sym instanceof Symbol.VarSymbol)) {
            return Description.NO_MATCH;
        }
        Symbol.VarSymbol fvar = (Symbol.VarSymbol)sym;
        if (fvar.getKind() != ElementKind.FIELD) {
            return Description.NO_MATCH;
        }
        return this.handleField(info.outerIf(), fvar, state);
    }

    @Nullable
    static DCLInfo findDCL(IfTree outerIf) {
        ExpressionTree outerIfTest = DoubleCheckedLocking.getNullCheckedExpression(outerIf.getCondition());
        if (outerIfTest == null) {
            return null;
        }
        SynchronizedTree synchTree = DoubleCheckedLocking.getChild(outerIf.getThenStatement(), SynchronizedTree.class);
        if (synchTree == null) {
            return null;
        }
        IfTree innerIf = DoubleCheckedLocking.getChild(synchTree.getBlock(), IfTree.class);
        if (innerIf == null) {
            return null;
        }
        ExpressionTree innerIfTest = DoubleCheckedLocking.getNullCheckedExpression(innerIf.getCondition());
        if (innerIfTest == null) {
            return null;
        }
        Symbol outerSym = ASTHelpers.getSymbol((Tree)outerIfTest);
        if (!Objects.equals(outerSym, ASTHelpers.getSymbol((Tree)innerIfTest))) {
            return null;
        }
        if (!(outerSym instanceof Symbol.VarSymbol)) {
            return null;
        }
        Symbol.VarSymbol var = (Symbol.VarSymbol)outerSym;
        return DCLInfo.create(outerIf, synchTree, innerIf, var);
    }

    private static ExpressionTree getNullCheckedExpression(ExpressionTree condition) {
        ExpressionTree other;
        if (!((condition = ASTHelpers.stripParentheses((ExpressionTree)condition)) instanceof BinaryTree)) {
            return null;
        }
        BinaryTree bin = (BinaryTree)condition;
        if (bin.getLeftOperand().getKind() == Tree.Kind.NULL_LITERAL) {
            other = bin.getRightOperand();
        } else if (bin.getRightOperand().getKind() == Tree.Kind.NULL_LITERAL) {
            other = bin.getLeftOperand();
        } else {
            return null;
        }
        return other;
    }

    private static <T> T getChild(StatementTree tree, final Class<T> clazz) {
        return (T)tree.accept(new SimpleTreeVisitor<T, Void>(){

            @Override
            protected T defaultAction(Tree node, Void p) {
                if (clazz.isInstance(node)) {
                    return clazz.cast(node);
                }
                return null;
            }

            @Override
            public T visitBlock(BlockTree node, Void p) {
                return this.visit(node.getStatements());
            }

            private T visit(List<? extends Tree> tx) {
                for (Tree tree : tx) {
                    Object r = tree.accept(this, null);
                    if (r == null) continue;
                    return r;
                }
                return null;
            }
        }, null);
    }

    @Nullable
    private static JCTree findFieldDeclaration(TreePath path, Symbol.VarSymbol var) {
        for (TreePath curr = path; curr != null; curr = curr.getParentPath()) {
            Tree leaf = curr.getLeaf();
            if (!(leaf instanceof JCTree.JCClassDecl)) continue;
            for (JCTree tree : ((JCTree.JCClassDecl)leaf).getMembers()) {
                if (!Objects.equals(var, ASTHelpers.getSymbol((Tree)tree))) continue;
                return tree;
            }
        }
        return null;
    }

    @AutoValue
    static abstract class DCLInfo {
        DCLInfo() {
        }

        abstract IfTree outerIf();

        abstract SynchronizedTree synchTree();

        abstract IfTree innerIf();

        abstract Symbol.VarSymbol sym();

        static DCLInfo create(IfTree outerIf, SynchronizedTree synchTree, IfTree innerIf, Symbol.VarSymbol sym) {
            return new AutoValue_DoubleCheckedLocking_DCLInfo(outerIf, synchTree, innerIf, sym);
        }
    }
}

