/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.lookup;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.turbine.binder.lookup.CompoundScope;
import com.google.turbine.binder.lookup.LookupKey;
import com.google.turbine.binder.lookup.LookupResult;
import com.google.turbine.binder.lookup.Scope;
import com.google.turbine.binder.lookup.TopLevelIndex;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CompoundTopLevelIndex
implements TopLevelIndex {
    private final ImmutableList<TopLevelIndex> indexes;
    private final Scope scope = new Scope(){

        @Override
        public @Nullable LookupResult lookup(LookupKey lookupKey) {
            for (TopLevelIndex index : CompoundTopLevelIndex.this.indexes) {
                LookupResult result = index.scope().lookup(lookupKey);
                if (result == null) continue;
                return result;
            }
            return null;
        }
    };

    private CompoundTopLevelIndex(ImmutableList<TopLevelIndex> indexes) {
        this.indexes = (ImmutableList)Preconditions.checkNotNull(indexes);
    }

    public static CompoundTopLevelIndex of(TopLevelIndex ... indexes) {
        return new CompoundTopLevelIndex((ImmutableList<TopLevelIndex>)ImmutableList.copyOf((Object[])indexes));
    }

    @Override
    public Scope scope() {
        return this.scope;
    }

    @Override
    public Scope lookupPackage(ImmutableList<String> packagename) {
        CompoundScope result = null;
        for (TopLevelIndex index : this.indexes) {
            Scope packageScope = index.lookupPackage(packagename);
            if (packageScope == null) continue;
            result = result == null ? CompoundScope.base(packageScope) : result.append(packageScope);
        }
        return result;
    }
}

