package com.google.devtools.remoteexecution.v1test;

import static io.grpc.MethodDescriptor.generateFullMethodName;
import static io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ClientCalls.asyncClientStreamingCall;
import static io.grpc.stub.ClientCalls.asyncServerStreamingCall;
import static io.grpc.stub.ClientCalls.asyncUnaryCall;
import static io.grpc.stub.ClientCalls.blockingServerStreamingCall;
import static io.grpc.stub.ClientCalls.blockingUnaryCall;
import static io.grpc.stub.ClientCalls.futureUnaryCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;
import static io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall;

/**
 * <pre>
 * The CAS (content-addressable storage) is used to store the inputs to and
 * outputs from the execution service. Each piece of content is addressed by the
 * digest of its binary data.
 * Most of the binary data stored in the CAS is opaque to the execution engine,
 * and is only used as a communication medium. In order to build an
 * [Action][google.devtools.remoteexecution.v1test.Action],
 * however, the client will need to also upload the
 * [Command][google.devtools.remoteexecution.v1test.Command] and input root
 * [Directory][google.devtools.remoteexecution.v1test.Directory] for the Action.
 * The Command and Directory messages must be marshalled to wire format and then
 * uploaded under the hash as with any other piece of content. In practice, the
 * input root directory is likely to refer to other Directories in its
 * hierarchy, which must also each be uploaded on their own.
 * For small file uploads the client should group them together and call
 * [BatchUpdateBlobs][google.devtools.remoteexecution.v1test.ContentAddressableStorage.BatchUpdateBlobs]
 * on chunks of no more than 10 MiB. For large uploads, the client must use the
 * [Write method][google.bytestream.ByteStream.Write] of the ByteStream API. The
 * `resource_name` is `{instance_name}/uploads/{uuid}/blobs/{hash}/{size}`,
 * where `instance_name` is as described in the next paragraph, `uuid` is a
 * version 4 UUID generated by the client, and `hash` and `size` are the
 * [Digest][google.devtools.remoteexecution.v1test.Digest] of the blob. The
 * `uuid` is used only to avoid collisions when multiple clients try to upload
 * the same file (or the same client tries to upload the file multiple times at
 * once on different threads), so the client MAY reuse the `uuid` for uploading
 * different blobs. The `resource_name` may optionally have a trailing filename
 * (or other metadata) for a client to use if it is storing URLs, as in
 * `{instance}/uploads/{uuid}/blobs/{hash}/{size}/foo/bar/baz.cc`. Anything
 * after the `size` is ignored.
 * A single server MAY support multiple instances of the execution system, each
 * with their own workers, storage, cache, etc. The exact relationship between
 * instances is up to the server. If the server does, then the `instance_name`
 * is an identifier, possibly containing multiple path segments, used to
 * distinguish between the various instances on the server, in a manner defined
 * by the server. For servers which do not support multiple instances, then the
 * `instance_name` is the empty path and the leading slash is omitted, so that
 * the `resource_name` becomes `uploads/{uuid}/blobs/{hash}/{size}`.
 * When attempting an upload, if another client has already completed the upload
 * (which may occur in the middle of a single upload if another client uploads
 * the same blob concurrently), the request will terminate immediately with
 * a response whose `committed_size` is the full size of the uploaded file
 * (regardless of how much data was transmitted by the client). If the client
 * completes the upload but the
 * [Digest][google.devtools.remoteexecution.v1test.Digest] does not match, an
 * `INVALID_ARGUMENT` error will be returned. In either case, the client should
 * not attempt to retry the upload.
 * For downloading blobs, the client must use the
 * [Read method][google.bytestream.ByteStream.Read] of the ByteStream API, with
 * a `resource_name` of `"{instance_name}/blobs/{hash}/{size}"`, where
 * `instance_name` is the instance name (see above), and `hash` and `size` are
 * the [Digest][google.devtools.remoteexecution.v1test.Digest] of the blob.
 * The lifetime of entries in the CAS is implementation specific, but it SHOULD
 * be long enough to allow for newly-added and recently looked-up entries to be
 * used in subsequent calls (e.g. to
 * [Execute][google.devtools.remoteexecution.v1test.Execution.Execute]).
 * As with other services in the Remote Execution API, any call may return an
 * error with a [RetryInfo][google.rpc.RetryInfo] error detail providing
 * information about when the client should retry the request; clients SHOULD
 * respect the information provided.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler",
    comments = "Source: google/devtools/remoteexecution/v1test/remote_execution.proto")
public final class ContentAddressableStorageGrpc {

  private ContentAddressableStorageGrpc() {}

  public static final String SERVICE_NAME = "google.devtools.remoteexecution.v1test.ContentAddressableStorage";

  // Static method descriptors that strictly reflect the proto.
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getFindMissingBlobsMethod()} instead. 
  public static final io.grpc.MethodDescriptor<com.google.devtools.remoteexecution.v1test.FindMissingBlobsRequest,
      com.google.devtools.remoteexecution.v1test.FindMissingBlobsResponse> METHOD_FIND_MISSING_BLOBS = getFindMissingBlobsMethodHelper();

  private static volatile io.grpc.MethodDescriptor<com.google.devtools.remoteexecution.v1test.FindMissingBlobsRequest,
      com.google.devtools.remoteexecution.v1test.FindMissingBlobsResponse> getFindMissingBlobsMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<com.google.devtools.remoteexecution.v1test.FindMissingBlobsRequest,
      com.google.devtools.remoteexecution.v1test.FindMissingBlobsResponse> getFindMissingBlobsMethod() {
    return getFindMissingBlobsMethodHelper();
  }

  private static io.grpc.MethodDescriptor<com.google.devtools.remoteexecution.v1test.FindMissingBlobsRequest,
      com.google.devtools.remoteexecution.v1test.FindMissingBlobsResponse> getFindMissingBlobsMethodHelper() {
    io.grpc.MethodDescriptor<com.google.devtools.remoteexecution.v1test.FindMissingBlobsRequest, com.google.devtools.remoteexecution.v1test.FindMissingBlobsResponse> getFindMissingBlobsMethod;
    if ((getFindMissingBlobsMethod = ContentAddressableStorageGrpc.getFindMissingBlobsMethod) == null) {
      synchronized (ContentAddressableStorageGrpc.class) {
        if ((getFindMissingBlobsMethod = ContentAddressableStorageGrpc.getFindMissingBlobsMethod) == null) {
          ContentAddressableStorageGrpc.getFindMissingBlobsMethod = getFindMissingBlobsMethod = 
              io.grpc.MethodDescriptor.<com.google.devtools.remoteexecution.v1test.FindMissingBlobsRequest, com.google.devtools.remoteexecution.v1test.FindMissingBlobsResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "google.devtools.remoteexecution.v1test.ContentAddressableStorage", "FindMissingBlobs"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.devtools.remoteexecution.v1test.FindMissingBlobsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.devtools.remoteexecution.v1test.FindMissingBlobsResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new ContentAddressableStorageMethodDescriptorSupplier("FindMissingBlobs"))
                  .build();
          }
        }
     }
     return getFindMissingBlobsMethod;
  }
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getBatchUpdateBlobsMethod()} instead. 
  public static final io.grpc.MethodDescriptor<com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsRequest,
      com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsResponse> METHOD_BATCH_UPDATE_BLOBS = getBatchUpdateBlobsMethodHelper();

  private static volatile io.grpc.MethodDescriptor<com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsRequest,
      com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsResponse> getBatchUpdateBlobsMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsRequest,
      com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsResponse> getBatchUpdateBlobsMethod() {
    return getBatchUpdateBlobsMethodHelper();
  }

  private static io.grpc.MethodDescriptor<com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsRequest,
      com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsResponse> getBatchUpdateBlobsMethodHelper() {
    io.grpc.MethodDescriptor<com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsRequest, com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsResponse> getBatchUpdateBlobsMethod;
    if ((getBatchUpdateBlobsMethod = ContentAddressableStorageGrpc.getBatchUpdateBlobsMethod) == null) {
      synchronized (ContentAddressableStorageGrpc.class) {
        if ((getBatchUpdateBlobsMethod = ContentAddressableStorageGrpc.getBatchUpdateBlobsMethod) == null) {
          ContentAddressableStorageGrpc.getBatchUpdateBlobsMethod = getBatchUpdateBlobsMethod = 
              io.grpc.MethodDescriptor.<com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsRequest, com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "google.devtools.remoteexecution.v1test.ContentAddressableStorage", "BatchUpdateBlobs"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new ContentAddressableStorageMethodDescriptorSupplier("BatchUpdateBlobs"))
                  .build();
          }
        }
     }
     return getBatchUpdateBlobsMethod;
  }
  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  @java.lang.Deprecated // Use {@link #getGetTreeMethod()} instead. 
  public static final io.grpc.MethodDescriptor<com.google.devtools.remoteexecution.v1test.GetTreeRequest,
      com.google.devtools.remoteexecution.v1test.GetTreeResponse> METHOD_GET_TREE = getGetTreeMethodHelper();

  private static volatile io.grpc.MethodDescriptor<com.google.devtools.remoteexecution.v1test.GetTreeRequest,
      com.google.devtools.remoteexecution.v1test.GetTreeResponse> getGetTreeMethod;

  @io.grpc.ExperimentalApi("https://github.com/grpc/grpc-java/issues/1901")
  public static io.grpc.MethodDescriptor<com.google.devtools.remoteexecution.v1test.GetTreeRequest,
      com.google.devtools.remoteexecution.v1test.GetTreeResponse> getGetTreeMethod() {
    return getGetTreeMethodHelper();
  }

  private static io.grpc.MethodDescriptor<com.google.devtools.remoteexecution.v1test.GetTreeRequest,
      com.google.devtools.remoteexecution.v1test.GetTreeResponse> getGetTreeMethodHelper() {
    io.grpc.MethodDescriptor<com.google.devtools.remoteexecution.v1test.GetTreeRequest, com.google.devtools.remoteexecution.v1test.GetTreeResponse> getGetTreeMethod;
    if ((getGetTreeMethod = ContentAddressableStorageGrpc.getGetTreeMethod) == null) {
      synchronized (ContentAddressableStorageGrpc.class) {
        if ((getGetTreeMethod = ContentAddressableStorageGrpc.getGetTreeMethod) == null) {
          ContentAddressableStorageGrpc.getGetTreeMethod = getGetTreeMethod = 
              io.grpc.MethodDescriptor.<com.google.devtools.remoteexecution.v1test.GetTreeRequest, com.google.devtools.remoteexecution.v1test.GetTreeResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(
                  "google.devtools.remoteexecution.v1test.ContentAddressableStorage", "GetTree"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.devtools.remoteexecution.v1test.GetTreeRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  com.google.devtools.remoteexecution.v1test.GetTreeResponse.getDefaultInstance()))
                  .setSchemaDescriptor(new ContentAddressableStorageMethodDescriptorSupplier("GetTree"))
                  .build();
          }
        }
     }
     return getGetTreeMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static ContentAddressableStorageStub newStub(io.grpc.Channel channel) {
    return new ContentAddressableStorageStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static ContentAddressableStorageBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    return new ContentAddressableStorageBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static ContentAddressableStorageFutureStub newFutureStub(
      io.grpc.Channel channel) {
    return new ContentAddressableStorageFutureStub(channel);
  }

  /**
   * <pre>
   * The CAS (content-addressable storage) is used to store the inputs to and
   * outputs from the execution service. Each piece of content is addressed by the
   * digest of its binary data.
   * Most of the binary data stored in the CAS is opaque to the execution engine,
   * and is only used as a communication medium. In order to build an
   * [Action][google.devtools.remoteexecution.v1test.Action],
   * however, the client will need to also upload the
   * [Command][google.devtools.remoteexecution.v1test.Command] and input root
   * [Directory][google.devtools.remoteexecution.v1test.Directory] for the Action.
   * The Command and Directory messages must be marshalled to wire format and then
   * uploaded under the hash as with any other piece of content. In practice, the
   * input root directory is likely to refer to other Directories in its
   * hierarchy, which must also each be uploaded on their own.
   * For small file uploads the client should group them together and call
   * [BatchUpdateBlobs][google.devtools.remoteexecution.v1test.ContentAddressableStorage.BatchUpdateBlobs]
   * on chunks of no more than 10 MiB. For large uploads, the client must use the
   * [Write method][google.bytestream.ByteStream.Write] of the ByteStream API. The
   * `resource_name` is `{instance_name}/uploads/{uuid}/blobs/{hash}/{size}`,
   * where `instance_name` is as described in the next paragraph, `uuid` is a
   * version 4 UUID generated by the client, and `hash` and `size` are the
   * [Digest][google.devtools.remoteexecution.v1test.Digest] of the blob. The
   * `uuid` is used only to avoid collisions when multiple clients try to upload
   * the same file (or the same client tries to upload the file multiple times at
   * once on different threads), so the client MAY reuse the `uuid` for uploading
   * different blobs. The `resource_name` may optionally have a trailing filename
   * (or other metadata) for a client to use if it is storing URLs, as in
   * `{instance}/uploads/{uuid}/blobs/{hash}/{size}/foo/bar/baz.cc`. Anything
   * after the `size` is ignored.
   * A single server MAY support multiple instances of the execution system, each
   * with their own workers, storage, cache, etc. The exact relationship between
   * instances is up to the server. If the server does, then the `instance_name`
   * is an identifier, possibly containing multiple path segments, used to
   * distinguish between the various instances on the server, in a manner defined
   * by the server. For servers which do not support multiple instances, then the
   * `instance_name` is the empty path and the leading slash is omitted, so that
   * the `resource_name` becomes `uploads/{uuid}/blobs/{hash}/{size}`.
   * When attempting an upload, if another client has already completed the upload
   * (which may occur in the middle of a single upload if another client uploads
   * the same blob concurrently), the request will terminate immediately with
   * a response whose `committed_size` is the full size of the uploaded file
   * (regardless of how much data was transmitted by the client). If the client
   * completes the upload but the
   * [Digest][google.devtools.remoteexecution.v1test.Digest] does not match, an
   * `INVALID_ARGUMENT` error will be returned. In either case, the client should
   * not attempt to retry the upload.
   * For downloading blobs, the client must use the
   * [Read method][google.bytestream.ByteStream.Read] of the ByteStream API, with
   * a `resource_name` of `"{instance_name}/blobs/{hash}/{size}"`, where
   * `instance_name` is the instance name (see above), and `hash` and `size` are
   * the [Digest][google.devtools.remoteexecution.v1test.Digest] of the blob.
   * The lifetime of entries in the CAS is implementation specific, but it SHOULD
   * be long enough to allow for newly-added and recently looked-up entries to be
   * used in subsequent calls (e.g. to
   * [Execute][google.devtools.remoteexecution.v1test.Execution.Execute]).
   * As with other services in the Remote Execution API, any call may return an
   * error with a [RetryInfo][google.rpc.RetryInfo] error detail providing
   * information about when the client should retry the request; clients SHOULD
   * respect the information provided.
   * </pre>
   */
  public static abstract class ContentAddressableStorageImplBase implements io.grpc.BindableService {

    /**
     * <pre>
     * Determine if blobs are present in the CAS.
     * Clients can use this API before uploading blobs to determine which ones are
     * already present in the CAS and do not need to be uploaded again.
     * There are no method-specific errors.
     * </pre>
     */
    public void findMissingBlobs(com.google.devtools.remoteexecution.v1test.FindMissingBlobsRequest request,
        io.grpc.stub.StreamObserver<com.google.devtools.remoteexecution.v1test.FindMissingBlobsResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getFindMissingBlobsMethodHelper(), responseObserver);
    }

    /**
     * <pre>
     * Upload many blobs at once.
     * The client MUST NOT upload blobs with a combined total size of more than 10
     * MiB using this API. Such requests should either be split into smaller
     * chunks or uploaded using the
     * [ByteStream API][google.bytestream.ByteStream], as appropriate.
     * This request is equivalent to calling [UpdateBlob][] on each individual
     * blob, in parallel. The requests may succeed or fail independently.
     * Errors:
     * * `INVALID_ARGUMENT`: The client attempted to upload more than 10 MiB of
     *   data.
     * Individual requests may return the following errors, additionally:
     * * `RESOURCE_EXHAUSTED`: There is insufficient disk quota to store the blob.
     * * `INVALID_ARGUMENT`: The
     * [Digest][google.devtools.remoteexecution.v1test.Digest] does not match the
     * provided data.
     * </pre>
     */
    public void batchUpdateBlobs(com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsRequest request,
        io.grpc.stub.StreamObserver<com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getBatchUpdateBlobsMethodHelper(), responseObserver);
    }

    /**
     * <pre>
     * DEPRECATED: This method is deprecated and should no longer be used.
     * </pre>
     */
    public void getTree(com.google.devtools.remoteexecution.v1test.GetTreeRequest request,
        io.grpc.stub.StreamObserver<com.google.devtools.remoteexecution.v1test.GetTreeResponse> responseObserver) {
      asyncUnimplementedUnaryCall(getGetTreeMethodHelper(), responseObserver);
    }

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getFindMissingBlobsMethodHelper(),
            asyncUnaryCall(
              new MethodHandlers<
                com.google.devtools.remoteexecution.v1test.FindMissingBlobsRequest,
                com.google.devtools.remoteexecution.v1test.FindMissingBlobsResponse>(
                  this, METHODID_FIND_MISSING_BLOBS)))
          .addMethod(
            getBatchUpdateBlobsMethodHelper(),
            asyncUnaryCall(
              new MethodHandlers<
                com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsRequest,
                com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsResponse>(
                  this, METHODID_BATCH_UPDATE_BLOBS)))
          .addMethod(
            getGetTreeMethodHelper(),
            asyncUnaryCall(
              new MethodHandlers<
                com.google.devtools.remoteexecution.v1test.GetTreeRequest,
                com.google.devtools.remoteexecution.v1test.GetTreeResponse>(
                  this, METHODID_GET_TREE)))
          .build();
    }
  }

  /**
   * <pre>
   * The CAS (content-addressable storage) is used to store the inputs to and
   * outputs from the execution service. Each piece of content is addressed by the
   * digest of its binary data.
   * Most of the binary data stored in the CAS is opaque to the execution engine,
   * and is only used as a communication medium. In order to build an
   * [Action][google.devtools.remoteexecution.v1test.Action],
   * however, the client will need to also upload the
   * [Command][google.devtools.remoteexecution.v1test.Command] and input root
   * [Directory][google.devtools.remoteexecution.v1test.Directory] for the Action.
   * The Command and Directory messages must be marshalled to wire format and then
   * uploaded under the hash as with any other piece of content. In practice, the
   * input root directory is likely to refer to other Directories in its
   * hierarchy, which must also each be uploaded on their own.
   * For small file uploads the client should group them together and call
   * [BatchUpdateBlobs][google.devtools.remoteexecution.v1test.ContentAddressableStorage.BatchUpdateBlobs]
   * on chunks of no more than 10 MiB. For large uploads, the client must use the
   * [Write method][google.bytestream.ByteStream.Write] of the ByteStream API. The
   * `resource_name` is `{instance_name}/uploads/{uuid}/blobs/{hash}/{size}`,
   * where `instance_name` is as described in the next paragraph, `uuid` is a
   * version 4 UUID generated by the client, and `hash` and `size` are the
   * [Digest][google.devtools.remoteexecution.v1test.Digest] of the blob. The
   * `uuid` is used only to avoid collisions when multiple clients try to upload
   * the same file (or the same client tries to upload the file multiple times at
   * once on different threads), so the client MAY reuse the `uuid` for uploading
   * different blobs. The `resource_name` may optionally have a trailing filename
   * (or other metadata) for a client to use if it is storing URLs, as in
   * `{instance}/uploads/{uuid}/blobs/{hash}/{size}/foo/bar/baz.cc`. Anything
   * after the `size` is ignored.
   * A single server MAY support multiple instances of the execution system, each
   * with their own workers, storage, cache, etc. The exact relationship between
   * instances is up to the server. If the server does, then the `instance_name`
   * is an identifier, possibly containing multiple path segments, used to
   * distinguish between the various instances on the server, in a manner defined
   * by the server. For servers which do not support multiple instances, then the
   * `instance_name` is the empty path and the leading slash is omitted, so that
   * the `resource_name` becomes `uploads/{uuid}/blobs/{hash}/{size}`.
   * When attempting an upload, if another client has already completed the upload
   * (which may occur in the middle of a single upload if another client uploads
   * the same blob concurrently), the request will terminate immediately with
   * a response whose `committed_size` is the full size of the uploaded file
   * (regardless of how much data was transmitted by the client). If the client
   * completes the upload but the
   * [Digest][google.devtools.remoteexecution.v1test.Digest] does not match, an
   * `INVALID_ARGUMENT` error will be returned. In either case, the client should
   * not attempt to retry the upload.
   * For downloading blobs, the client must use the
   * [Read method][google.bytestream.ByteStream.Read] of the ByteStream API, with
   * a `resource_name` of `"{instance_name}/blobs/{hash}/{size}"`, where
   * `instance_name` is the instance name (see above), and `hash` and `size` are
   * the [Digest][google.devtools.remoteexecution.v1test.Digest] of the blob.
   * The lifetime of entries in the CAS is implementation specific, but it SHOULD
   * be long enough to allow for newly-added and recently looked-up entries to be
   * used in subsequent calls (e.g. to
   * [Execute][google.devtools.remoteexecution.v1test.Execution.Execute]).
   * As with other services in the Remote Execution API, any call may return an
   * error with a [RetryInfo][google.rpc.RetryInfo] error detail providing
   * information about when the client should retry the request; clients SHOULD
   * respect the information provided.
   * </pre>
   */
  public static final class ContentAddressableStorageStub extends io.grpc.stub.AbstractStub<ContentAddressableStorageStub> {
    private ContentAddressableStorageStub(io.grpc.Channel channel) {
      super(channel);
    }

    private ContentAddressableStorageStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ContentAddressableStorageStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new ContentAddressableStorageStub(channel, callOptions);
    }

    /**
     * <pre>
     * Determine if blobs are present in the CAS.
     * Clients can use this API before uploading blobs to determine which ones are
     * already present in the CAS and do not need to be uploaded again.
     * There are no method-specific errors.
     * </pre>
     */
    public void findMissingBlobs(com.google.devtools.remoteexecution.v1test.FindMissingBlobsRequest request,
        io.grpc.stub.StreamObserver<com.google.devtools.remoteexecution.v1test.FindMissingBlobsResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getFindMissingBlobsMethodHelper(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Upload many blobs at once.
     * The client MUST NOT upload blobs with a combined total size of more than 10
     * MiB using this API. Such requests should either be split into smaller
     * chunks or uploaded using the
     * [ByteStream API][google.bytestream.ByteStream], as appropriate.
     * This request is equivalent to calling [UpdateBlob][] on each individual
     * blob, in parallel. The requests may succeed or fail independently.
     * Errors:
     * * `INVALID_ARGUMENT`: The client attempted to upload more than 10 MiB of
     *   data.
     * Individual requests may return the following errors, additionally:
     * * `RESOURCE_EXHAUSTED`: There is insufficient disk quota to store the blob.
     * * `INVALID_ARGUMENT`: The
     * [Digest][google.devtools.remoteexecution.v1test.Digest] does not match the
     * provided data.
     * </pre>
     */
    public void batchUpdateBlobs(com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsRequest request,
        io.grpc.stub.StreamObserver<com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getBatchUpdateBlobsMethodHelper(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * DEPRECATED: This method is deprecated and should no longer be used.
     * </pre>
     */
    public void getTree(com.google.devtools.remoteexecution.v1test.GetTreeRequest request,
        io.grpc.stub.StreamObserver<com.google.devtools.remoteexecution.v1test.GetTreeResponse> responseObserver) {
      asyncUnaryCall(
          getChannel().newCall(getGetTreeMethodHelper(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * <pre>
   * The CAS (content-addressable storage) is used to store the inputs to and
   * outputs from the execution service. Each piece of content is addressed by the
   * digest of its binary data.
   * Most of the binary data stored in the CAS is opaque to the execution engine,
   * and is only used as a communication medium. In order to build an
   * [Action][google.devtools.remoteexecution.v1test.Action],
   * however, the client will need to also upload the
   * [Command][google.devtools.remoteexecution.v1test.Command] and input root
   * [Directory][google.devtools.remoteexecution.v1test.Directory] for the Action.
   * The Command and Directory messages must be marshalled to wire format and then
   * uploaded under the hash as with any other piece of content. In practice, the
   * input root directory is likely to refer to other Directories in its
   * hierarchy, which must also each be uploaded on their own.
   * For small file uploads the client should group them together and call
   * [BatchUpdateBlobs][google.devtools.remoteexecution.v1test.ContentAddressableStorage.BatchUpdateBlobs]
   * on chunks of no more than 10 MiB. For large uploads, the client must use the
   * [Write method][google.bytestream.ByteStream.Write] of the ByteStream API. The
   * `resource_name` is `{instance_name}/uploads/{uuid}/blobs/{hash}/{size}`,
   * where `instance_name` is as described in the next paragraph, `uuid` is a
   * version 4 UUID generated by the client, and `hash` and `size` are the
   * [Digest][google.devtools.remoteexecution.v1test.Digest] of the blob. The
   * `uuid` is used only to avoid collisions when multiple clients try to upload
   * the same file (or the same client tries to upload the file multiple times at
   * once on different threads), so the client MAY reuse the `uuid` for uploading
   * different blobs. The `resource_name` may optionally have a trailing filename
   * (or other metadata) for a client to use if it is storing URLs, as in
   * `{instance}/uploads/{uuid}/blobs/{hash}/{size}/foo/bar/baz.cc`. Anything
   * after the `size` is ignored.
   * A single server MAY support multiple instances of the execution system, each
   * with their own workers, storage, cache, etc. The exact relationship between
   * instances is up to the server. If the server does, then the `instance_name`
   * is an identifier, possibly containing multiple path segments, used to
   * distinguish between the various instances on the server, in a manner defined
   * by the server. For servers which do not support multiple instances, then the
   * `instance_name` is the empty path and the leading slash is omitted, so that
   * the `resource_name` becomes `uploads/{uuid}/blobs/{hash}/{size}`.
   * When attempting an upload, if another client has already completed the upload
   * (which may occur in the middle of a single upload if another client uploads
   * the same blob concurrently), the request will terminate immediately with
   * a response whose `committed_size` is the full size of the uploaded file
   * (regardless of how much data was transmitted by the client). If the client
   * completes the upload but the
   * [Digest][google.devtools.remoteexecution.v1test.Digest] does not match, an
   * `INVALID_ARGUMENT` error will be returned. In either case, the client should
   * not attempt to retry the upload.
   * For downloading blobs, the client must use the
   * [Read method][google.bytestream.ByteStream.Read] of the ByteStream API, with
   * a `resource_name` of `"{instance_name}/blobs/{hash}/{size}"`, where
   * `instance_name` is the instance name (see above), and `hash` and `size` are
   * the [Digest][google.devtools.remoteexecution.v1test.Digest] of the blob.
   * The lifetime of entries in the CAS is implementation specific, but it SHOULD
   * be long enough to allow for newly-added and recently looked-up entries to be
   * used in subsequent calls (e.g. to
   * [Execute][google.devtools.remoteexecution.v1test.Execution.Execute]).
   * As with other services in the Remote Execution API, any call may return an
   * error with a [RetryInfo][google.rpc.RetryInfo] error detail providing
   * information about when the client should retry the request; clients SHOULD
   * respect the information provided.
   * </pre>
   */
  public static final class ContentAddressableStorageBlockingStub extends io.grpc.stub.AbstractStub<ContentAddressableStorageBlockingStub> {
    private ContentAddressableStorageBlockingStub(io.grpc.Channel channel) {
      super(channel);
    }

    private ContentAddressableStorageBlockingStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ContentAddressableStorageBlockingStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new ContentAddressableStorageBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     * Determine if blobs are present in the CAS.
     * Clients can use this API before uploading blobs to determine which ones are
     * already present in the CAS and do not need to be uploaded again.
     * There are no method-specific errors.
     * </pre>
     */
    public com.google.devtools.remoteexecution.v1test.FindMissingBlobsResponse findMissingBlobs(com.google.devtools.remoteexecution.v1test.FindMissingBlobsRequest request) {
      return blockingUnaryCall(
          getChannel(), getFindMissingBlobsMethodHelper(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Upload many blobs at once.
     * The client MUST NOT upload blobs with a combined total size of more than 10
     * MiB using this API. Such requests should either be split into smaller
     * chunks or uploaded using the
     * [ByteStream API][google.bytestream.ByteStream], as appropriate.
     * This request is equivalent to calling [UpdateBlob][] on each individual
     * blob, in parallel. The requests may succeed or fail independently.
     * Errors:
     * * `INVALID_ARGUMENT`: The client attempted to upload more than 10 MiB of
     *   data.
     * Individual requests may return the following errors, additionally:
     * * `RESOURCE_EXHAUSTED`: There is insufficient disk quota to store the blob.
     * * `INVALID_ARGUMENT`: The
     * [Digest][google.devtools.remoteexecution.v1test.Digest] does not match the
     * provided data.
     * </pre>
     */
    public com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsResponse batchUpdateBlobs(com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsRequest request) {
      return blockingUnaryCall(
          getChannel(), getBatchUpdateBlobsMethodHelper(), getCallOptions(), request);
    }

    /**
     * <pre>
     * DEPRECATED: This method is deprecated and should no longer be used.
     * </pre>
     */
    public com.google.devtools.remoteexecution.v1test.GetTreeResponse getTree(com.google.devtools.remoteexecution.v1test.GetTreeRequest request) {
      return blockingUnaryCall(
          getChannel(), getGetTreeMethodHelper(), getCallOptions(), request);
    }
  }

  /**
   * <pre>
   * The CAS (content-addressable storage) is used to store the inputs to and
   * outputs from the execution service. Each piece of content is addressed by the
   * digest of its binary data.
   * Most of the binary data stored in the CAS is opaque to the execution engine,
   * and is only used as a communication medium. In order to build an
   * [Action][google.devtools.remoteexecution.v1test.Action],
   * however, the client will need to also upload the
   * [Command][google.devtools.remoteexecution.v1test.Command] and input root
   * [Directory][google.devtools.remoteexecution.v1test.Directory] for the Action.
   * The Command and Directory messages must be marshalled to wire format and then
   * uploaded under the hash as with any other piece of content. In practice, the
   * input root directory is likely to refer to other Directories in its
   * hierarchy, which must also each be uploaded on their own.
   * For small file uploads the client should group them together and call
   * [BatchUpdateBlobs][google.devtools.remoteexecution.v1test.ContentAddressableStorage.BatchUpdateBlobs]
   * on chunks of no more than 10 MiB. For large uploads, the client must use the
   * [Write method][google.bytestream.ByteStream.Write] of the ByteStream API. The
   * `resource_name` is `{instance_name}/uploads/{uuid}/blobs/{hash}/{size}`,
   * where `instance_name` is as described in the next paragraph, `uuid` is a
   * version 4 UUID generated by the client, and `hash` and `size` are the
   * [Digest][google.devtools.remoteexecution.v1test.Digest] of the blob. The
   * `uuid` is used only to avoid collisions when multiple clients try to upload
   * the same file (or the same client tries to upload the file multiple times at
   * once on different threads), so the client MAY reuse the `uuid` for uploading
   * different blobs. The `resource_name` may optionally have a trailing filename
   * (or other metadata) for a client to use if it is storing URLs, as in
   * `{instance}/uploads/{uuid}/blobs/{hash}/{size}/foo/bar/baz.cc`. Anything
   * after the `size` is ignored.
   * A single server MAY support multiple instances of the execution system, each
   * with their own workers, storage, cache, etc. The exact relationship between
   * instances is up to the server. If the server does, then the `instance_name`
   * is an identifier, possibly containing multiple path segments, used to
   * distinguish between the various instances on the server, in a manner defined
   * by the server. For servers which do not support multiple instances, then the
   * `instance_name` is the empty path and the leading slash is omitted, so that
   * the `resource_name` becomes `uploads/{uuid}/blobs/{hash}/{size}`.
   * When attempting an upload, if another client has already completed the upload
   * (which may occur in the middle of a single upload if another client uploads
   * the same blob concurrently), the request will terminate immediately with
   * a response whose `committed_size` is the full size of the uploaded file
   * (regardless of how much data was transmitted by the client). If the client
   * completes the upload but the
   * [Digest][google.devtools.remoteexecution.v1test.Digest] does not match, an
   * `INVALID_ARGUMENT` error will be returned. In either case, the client should
   * not attempt to retry the upload.
   * For downloading blobs, the client must use the
   * [Read method][google.bytestream.ByteStream.Read] of the ByteStream API, with
   * a `resource_name` of `"{instance_name}/blobs/{hash}/{size}"`, where
   * `instance_name` is the instance name (see above), and `hash` and `size` are
   * the [Digest][google.devtools.remoteexecution.v1test.Digest] of the blob.
   * The lifetime of entries in the CAS is implementation specific, but it SHOULD
   * be long enough to allow for newly-added and recently looked-up entries to be
   * used in subsequent calls (e.g. to
   * [Execute][google.devtools.remoteexecution.v1test.Execution.Execute]).
   * As with other services in the Remote Execution API, any call may return an
   * error with a [RetryInfo][google.rpc.RetryInfo] error detail providing
   * information about when the client should retry the request; clients SHOULD
   * respect the information provided.
   * </pre>
   */
  public static final class ContentAddressableStorageFutureStub extends io.grpc.stub.AbstractStub<ContentAddressableStorageFutureStub> {
    private ContentAddressableStorageFutureStub(io.grpc.Channel channel) {
      super(channel);
    }

    private ContentAddressableStorageFutureStub(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected ContentAddressableStorageFutureStub build(io.grpc.Channel channel,
        io.grpc.CallOptions callOptions) {
      return new ContentAddressableStorageFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     * Determine if blobs are present in the CAS.
     * Clients can use this API before uploading blobs to determine which ones are
     * already present in the CAS and do not need to be uploaded again.
     * There are no method-specific errors.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.google.devtools.remoteexecution.v1test.FindMissingBlobsResponse> findMissingBlobs(
        com.google.devtools.remoteexecution.v1test.FindMissingBlobsRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getFindMissingBlobsMethodHelper(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Upload many blobs at once.
     * The client MUST NOT upload blobs with a combined total size of more than 10
     * MiB using this API. Such requests should either be split into smaller
     * chunks or uploaded using the
     * [ByteStream API][google.bytestream.ByteStream], as appropriate.
     * This request is equivalent to calling [UpdateBlob][] on each individual
     * blob, in parallel. The requests may succeed or fail independently.
     * Errors:
     * * `INVALID_ARGUMENT`: The client attempted to upload more than 10 MiB of
     *   data.
     * Individual requests may return the following errors, additionally:
     * * `RESOURCE_EXHAUSTED`: There is insufficient disk quota to store the blob.
     * * `INVALID_ARGUMENT`: The
     * [Digest][google.devtools.remoteexecution.v1test.Digest] does not match the
     * provided data.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsResponse> batchUpdateBlobs(
        com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getBatchUpdateBlobsMethodHelper(), getCallOptions()), request);
    }

    /**
     * <pre>
     * DEPRECATED: This method is deprecated and should no longer be used.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<com.google.devtools.remoteexecution.v1test.GetTreeResponse> getTree(
        com.google.devtools.remoteexecution.v1test.GetTreeRequest request) {
      return futureUnaryCall(
          getChannel().newCall(getGetTreeMethodHelper(), getCallOptions()), request);
    }
  }

  private static final int METHODID_FIND_MISSING_BLOBS = 0;
  private static final int METHODID_BATCH_UPDATE_BLOBS = 1;
  private static final int METHODID_GET_TREE = 2;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final ContentAddressableStorageImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(ContentAddressableStorageImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_FIND_MISSING_BLOBS:
          serviceImpl.findMissingBlobs((com.google.devtools.remoteexecution.v1test.FindMissingBlobsRequest) request,
              (io.grpc.stub.StreamObserver<com.google.devtools.remoteexecution.v1test.FindMissingBlobsResponse>) responseObserver);
          break;
        case METHODID_BATCH_UPDATE_BLOBS:
          serviceImpl.batchUpdateBlobs((com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsRequest) request,
              (io.grpc.stub.StreamObserver<com.google.devtools.remoteexecution.v1test.BatchUpdateBlobsResponse>) responseObserver);
          break;
        case METHODID_GET_TREE:
          serviceImpl.getTree((com.google.devtools.remoteexecution.v1test.GetTreeRequest) request,
              (io.grpc.stub.StreamObserver<com.google.devtools.remoteexecution.v1test.GetTreeResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class ContentAddressableStorageBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    ContentAddressableStorageBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.google.devtools.remoteexecution.v1test.RemoteExecutionProto.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("ContentAddressableStorage");
    }
  }

  private static final class ContentAddressableStorageFileDescriptorSupplier
      extends ContentAddressableStorageBaseDescriptorSupplier {
    ContentAddressableStorageFileDescriptorSupplier() {}
  }

  private static final class ContentAddressableStorageMethodDescriptorSupplier
      extends ContentAddressableStorageBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    ContentAddressableStorageMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (ContentAddressableStorageGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new ContentAddressableStorageFileDescriptorSupplier())
              .addMethod(getFindMissingBlobsMethodHelper())
              .addMethod(getBatchUpdateBlobsMethodHelper())
              .addMethod(getGetTreeMethodHelper())
              .build();
        }
      }
    }
    return result;
  }
}
