/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.SideEffectAnalysis;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

@BugPattern(name="Unused", altNames={"unused", "UnusedParameters"}, summary="Unused.", providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION, severity=BugPattern.SeverityLevel.WARNING)
public final class Unused
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final String GWT_JAVASCRIPT_OBJECT = "com.google.gwt.core.client.JavaScriptObject";
    private static final String EXEMPT_PREFIX = "unused";
    private static final String JUNIT_PARAMS_VALUE = "value";
    private static final String JUNIT_PARAMS_ANNOTATION_TYPE = "junitparams.Parameters";
    private static final Supplier<Type> OBJECT = Suppliers.typeFromString((String)"java.lang.Object");
    private static final Supplier<Type> OBJECT_OUTPUT_STREAM = Suppliers.typeFromString((String)"java.io.ObjectOutputStream");
    private static final Matcher<MethodTree> SPECIAL_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsNamed((String)"readObject"), Matchers.methodReturns(OBJECT_OUTPUT_STREAM)}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsNamed((String)"writeObject"), Matchers.methodReturns(OBJECT_OUTPUT_STREAM)}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsNamed((String)"readObjectNoData"), Matchers.methodReturns((Matcher)Matchers.isVoidType())}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsNamed((String)"readResolve"), Matchers.methodReturns(OBJECT)}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsNamed((String)"writeReplace"), Matchers.methodReturns(OBJECT)})});
    private static final ImmutableSet<String> EXEMPTING_ANNOTATION_FULL_NAMES = ImmutableSet.of((Object)"javax.inject.Inject", (Object)"javax.persistence.Basic", (Object)"javax.persistence.Column", (Object)"javax.persistence.Id", (Object)"javax.persistence.Version", (Object)"javax.xml.bind.annotation.XmlElement", (Object[])new String[]{"org.mockito.Mock", "org.openqa.selenium.support.FindBy", "org.openqa.selenium.support.FindBys"});
    private static final ImmutableSet<String> EXEMPTING_SUPER_TYPES = ImmutableSet.of();
    private static final ImmutableList<String> SPECIAL_FIELDS = ImmutableList.of((Object)"serialVersionUID", (Object)"TAG");
    private static final ImmutableSet<Modifier> LOGGER_REQUIRED_MODIFIERS = Sets.immutableEnumSet((Enum)Modifier.PRIVATE, (Enum[])new Modifier[]{Modifier.STATIC, Modifier.FINAL});
    private static final ImmutableSet<String> LOGGER_TYPE_NAME = ImmutableSet.of((Object)"GoogleLogger");
    private static final ImmutableSet<String> LOGGER_VAR_NAME = ImmutableSet.of((Object)"logger");

    public Description matchCompilationUnit(CompilationUnitTree tree, final VisitorState state) {
        final HashMap unusedElements = new HashMap();
        ArrayListMultimap usageSites = ArrayListMultimap.create();
        if (Unused.hasNativeMethods(state.getPath())) {
            return Description.NO_MATCH;
        }
        AtomicBoolean ignoreUnusedMethods = new AtomicBoolean(false);
        class PrivateFieldLocalVarFinder
        extends TreePathScanner<Void, Void> {
            final /* synthetic */ ListMultimap val$usageSites;
            final /* synthetic */ AtomicBoolean val$ignoreUnusedMethods;

            PrivateFieldLocalVarFinder() {
                this.val$usageSites = listMultimap;
                this.val$ignoreUnusedMethods = atomicBoolean;
            }

            private boolean hasJUnitParamsParametersForMethodAnnotation(Collection<? extends AnnotationTree> annotations) {
                for (AnnotationTree annotationTree : annotations) {
                    JCTree.JCAnnotation annotation = (JCTree.JCAnnotation)annotationTree;
                    if (annotation.getAnnotationType().type == null || !annotation.getAnnotationType().type.toString().equals(Unused.JUNIT_PARAMS_ANNOTATION_TYPE)) continue;
                    if (((List)annotation.getArguments()).isEmpty()) {
                        return true;
                    }
                    for (JCTree.JCExpression arg : annotation.getArguments()) {
                        if (arg.getKind() != Tree.Kind.ASSIGNMENT) {
                            return false;
                        }
                        JCTree.JCExpression var = ((JCTree.JCAssign)arg).getVariable();
                        if (var.getKind() != Tree.Kind.IDENTIFIER || !((IdentifierTree)((Object)var)).getName().contentEquals(Unused.JUNIT_PARAMS_VALUE)) continue;
                        return true;
                    }
                }
                return false;
            }

            private boolean exemptedBySuperType(Type type, VisitorState state2) {
                return EXEMPTING_SUPER_TYPES.stream().anyMatch(t -> ASTHelpers.isSubtype((Type)type, (Type)((Type)Suppliers.typeFromString((String)t).get(state2)), (VisitorState)state2));
            }

            @Override
            public Void visitVariable(VariableTree variableTree, Void unused) {
                if (Unused.exemptedByName(variableTree.getName())) {
                    return null;
                }
                if (Unused.this.isSuppressed(variableTree)) {
                    return null;
                }
                super.visitVariable(variableTree, unused);
                Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)variableTree);
                if (symbol == null) {
                    return null;
                }
                if (Unused.exemptedByAnnotation(variableTree.getModifiers().getAnnotations(), state)) {
                    return null;
                }
                switch (symbol.getKind()) {
                    case FIELD: {
                        if (!variableTree.getModifiers().getFlags().contains((Object)Modifier.PRIVATE) || SPECIAL_FIELDS.contains((Object)((Name)symbol.getSimpleName()).toString()) || this.isLoggerField(variableTree)) break;
                        unusedElements.put(symbol, this.getCurrentPath());
                        this.val$usageSites.put((Object)symbol, (Object)this.getCurrentPath());
                        break;
                    }
                    case LOCAL_VARIABLE: {
                        unusedElements.put(symbol, this.getCurrentPath());
                        this.val$usageSites.put((Object)symbol, (Object)this.getCurrentPath());
                        break;
                    }
                    case PARAMETER: {
                        if (variableTree.getName().contentEquals("this")) {
                            return null;
                        }
                        if (!this.isParameterSubjectToAnalysis(symbol)) break;
                        unusedElements.put(symbol, this.getCurrentPath());
                        break;
                    }
                }
                return null;
            }

            private boolean isLoggerField(VariableTree variableTree) {
                return variableTree.getModifiers().getFlags().containsAll((Collection<?>)LOGGER_REQUIRED_MODIFIERS) && LOGGER_TYPE_NAME.contains((Object)variableTree.getType().toString()) && LOGGER_VAR_NAME.contains((Object)variableTree.getName().toString());
            }

            private boolean isParameterSubjectToAnalysis(Symbol sym) {
                Preconditions.checkArgument((sym.getKind() == ElementKind.PARAMETER ? 1 : 0) != 0);
                Symbol enclosingMethod = sym.owner;
                return enclosingMethod.getModifiers().contains((Object)Modifier.PRIVATE);
            }

            @Override
            public Void visitTry(TryTree node, Void unused) {
                this.scan(node.getBlock(), null);
                this.scan(node.getCatches(), null);
                this.scan(node.getFinallyBlock(), null);
                return null;
            }

            @Override
            public Void visitClass(ClassTree tree, Void unused) {
                if (Unused.this.isSuppressed(tree) || this.exemptedBySuperType(ASTHelpers.getType((ClassTree)tree), state)) {
                    return null;
                }
                return (Void)super.visitClass(tree, null);
            }

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree node, Void unused) {
                return (Void)this.scan(node.getBody(), null);
            }

            @Override
            public Void visitMethod(MethodTree tree, Void unused) {
                if (this.hasJUnitParamsParametersForMethodAnnotation(tree.getModifiers().getAnnotations())) {
                    this.val$ignoreUnusedMethods.set(true);
                }
                if (Unused.this.isSuppressed(tree)) {
                    return null;
                }
                if (this.isMethodSymbolEligibleForChecking(tree)) {
                    unusedElements.put(ASTHelpers.getSymbol((MethodTree)tree), this.getCurrentPath());
                }
                return (Void)super.visitMethod(tree, unused);
            }

            private boolean isMethodSymbolEligibleForChecking(MethodTree tree) {
                Type lastParamType;
                if (Unused.exemptedByName(tree.getName())) {
                    return false;
                }
                if (Unused.exemptedByAnnotation(tree.getModifiers().getAnnotations(), state)) {
                    return false;
                }
                Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)tree);
                if (methodSymbol == null || methodSymbol.getKind() == ElementKind.CONSTRUCTOR || SPECIAL_METHODS.matches((Tree)tree, state)) {
                    return false;
                }
                if (!tree.getParameters().isEmpty() && (lastParamType = ASTHelpers.getType((Tree)((Tree)Iterables.getLast(tree.getParameters())))) != null && lastParamType.toString().equals(Unused.GWT_JAVASCRIPT_OBJECT)) {
                    return false;
                }
                return tree.getModifiers().getFlags().contains((Object)Modifier.PRIVATE);
            }
        }
        new PrivateFieldLocalVarFinder().scan(state.getPath(), null);
        class FilterUsedElements
        extends TreePathScanner<Void, Void> {
            private boolean leftHandSideAssignment = false;
            private int inArrayAccess = 0;
            private boolean inReturnStatement = false;
            private int inMethodCall = 0;
            private TreePath currentExpressionStatement = null;
            final /* synthetic */ ListMultimap val$usageSites;

            FilterUsedElements() {
                this.val$usageSites = listMultimap;
            }

            private boolean isInExpressionStatementTree() {
                Tree parent = this.getCurrentPath().getParentPath().getLeaf();
                return parent != null && parent.getKind() == Tree.Kind.EXPRESSION_STATEMENT;
            }

            private boolean isUsed(Symbol symbol) {
                return symbol != null && (!this.leftHandSideAssignment || this.inReturnStatement || this.inArrayAccess > 0 || this.inMethodCall > 0) && unusedElements.containsKey(symbol);
            }

            @Override
            public Void visitExpressionStatement(ExpressionStatementTree tree, Void unused) {
                this.currentExpressionStatement = this.getCurrentPath();
                super.visitExpressionStatement(tree, null);
                this.currentExpressionStatement = null;
                return null;
            }

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
                if (symbol != null && this.isUsed(symbol)) {
                    unusedElements.remove(symbol);
                }
                if (this.currentExpressionStatement != null && unusedElements.containsKey(symbol)) {
                    this.val$usageSites.put((Object)symbol, (Object)this.currentExpressionStatement);
                }
                return null;
            }

            @Override
            public Void visitAssignment(AssignmentTree tree, Void unused) {
                if (this.isInExpressionStatementTree()) {
                    this.leftHandSideAssignment = true;
                    this.scan(tree.getVariable(), null);
                    this.leftHandSideAssignment = false;
                    this.scan(tree.getExpression(), null);
                } else {
                    super.visitAssignment(tree, null);
                }
                return null;
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree memberSelectTree, Void unused) {
                super.visitMemberSelect(memberSelectTree, null);
                Symbol symbol = ASTHelpers.getSymbol((Tree)memberSelectTree);
                if (symbol != null && this.isUsed(symbol)) {
                    unusedElements.remove(symbol);
                } else if (this.currentExpressionStatement != null && unusedElements.containsKey(symbol)) {
                    this.val$usageSites.put((Object)symbol, (Object)this.currentExpressionStatement);
                }
                Symbol baseSymbol = this.extractBaseSymbol(memberSelectTree);
                if (baseSymbol != null) {
                    unusedElements.remove(baseSymbol);
                }
                return null;
            }

            @Override
            public Void visitMemberReference(MemberReferenceTree tree, Void unused) {
                super.visitMemberReference(tree, null);
                Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MemberReferenceTree)tree);
                if (symbol != null && this.isUsed(symbol)) {
                    unusedElements.remove(symbol);
                }
                if (this.currentExpressionStatement != null && unusedElements.containsKey(symbol)) {
                    this.val$usageSites.put((Object)symbol, (Object)this.currentExpressionStatement);
                }
                return null;
            }

            @Nullable
            private Symbol extractBaseSymbol(ExpressionTree access) {
                switch (access.getKind()) {
                    case MEMBER_SELECT: {
                        return this.extractBaseSymbol(((MemberSelectTree)access).getExpression());
                    }
                    case IDENTIFIER: {
                        return ASTHelpers.getSymbol((Tree)access);
                    }
                }
                return null;
            }

            @Override
            public Void visitCompoundAssignment(CompoundAssignmentTree tree, Void unused) {
                if (this.isInExpressionStatementTree()) {
                    this.leftHandSideAssignment = true;
                    this.scan(tree.getVariable(), null);
                    this.leftHandSideAssignment = false;
                    this.scan(tree.getExpression(), null);
                } else {
                    super.visitCompoundAssignment(tree, null);
                }
                return null;
            }

            @Override
            public Void visitArrayAccess(ArrayAccessTree node, Void unused) {
                ++this.inArrayAccess;
                super.visitArrayAccess(node, null);
                --this.inArrayAccess;
                return null;
            }

            @Override
            public Void visitReturn(ReturnTree node, Void unused) {
                this.inReturnStatement = true;
                this.scan(node.getExpression(), null);
                this.inReturnStatement = false;
                return null;
            }

            @Override
            public Void visitUnary(UnaryTree tree, Void unused) {
                if (this.isInExpressionStatementTree() && (tree.getKind() == Tree.Kind.POSTFIX_DECREMENT || tree.getKind() == Tree.Kind.POSTFIX_INCREMENT || tree.getKind() == Tree.Kind.PREFIX_DECREMENT || tree.getKind() == Tree.Kind.PREFIX_INCREMENT)) {
                    this.leftHandSideAssignment = true;
                    this.scan(tree.getExpression(), null);
                    this.leftHandSideAssignment = false;
                } else {
                    super.visitUnary(tree, null);
                }
                return null;
            }

            @Override
            public Void visitErroneous(ErroneousTree tree, Void unused) {
                return (Void)this.scan(tree.getErrorTrees(), null);
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                ++this.inMethodCall;
                Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodInvocationTree)tree);
                if (methodSymbol != null) {
                    unusedElements.remove(methodSymbol);
                }
                super.visitMethodInvocation(tree, null);
                --this.inMethodCall;
                return null;
            }
        }
        new FilterUsedElements().scan(state.getPath(), null);
        for (TreePath unusedPath : unusedElements.values()) {
            Tree unused = unusedPath.getLeaf();
            switch (unused.getKind()) {
                case VARIABLE: {
                    String element;
                    VariableTree unusedVar = (VariableTree)unused;
                    Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)unusedVar);
                    switch (symbol.getKind()) {
                        case FIELD: {
                            element = "Field";
                            break;
                        }
                        case LOCAL_VARIABLE: {
                            element = "Local variable";
                            break;
                        }
                        case PARAMETER: {
                            element = "Parameter";
                            break;
                        }
                        default: {
                            element = "Variable";
                        }
                    }
                    state.reportMatch(this.buildDescription(unused).setMessage(String.format("%s '%s' is never read.", element, unusedVar.getName())).addAllFixes(Unused.buildUnusedVarFixes(symbol, usageSites.get((Object)symbol), state)).build());
                    break;
                }
                case METHOD: {
                    if (ignoreUnusedMethods.get()) break;
                    state.reportMatch(this.buildDescription(unused).addFix((Fix)Unused.replaceWithComments(unusedPath, "", state)).setMessage("Remove unused private method.").build());
                    break;
                }
            }
        }
        return Description.NO_MATCH;
    }

    private static boolean hasNativeMethods(TreePath path) {
        final AtomicBoolean hasAnyNativeMethods = new AtomicBoolean(false);
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethod(MethodTree tree, Void unused) {
                if (tree.getModifiers().getFlags().contains((Object)Modifier.NATIVE)) {
                    hasAnyNativeMethods.set(true);
                }
                return null;
            }
        }.scan(path, null);
        return hasAnyNativeMethods.get();
    }

    private static ImmutableList<SuggestedFix> buildUnusedVarFixes(Symbol varSymbol, java.util.List<TreePath> usagePaths, VisitorState state) {
        ElementKind varKind = varSymbol.getKind();
        if (varKind != ElementKind.LOCAL_VARIABLE && varKind != ElementKind.FIELD) {
            return ImmutableList.of();
        }
        boolean encounteredSideEffects = false;
        SuggestedFix.Builder fix = SuggestedFix.builder();
        SuggestedFix.Builder removeSideEffectsFix = SuggestedFix.builder();
        for (TreePath usagePath : usagePaths) {
            StatementTree statement = (StatementTree)usagePath.getLeaf();
            if (statement.getKind() == Tree.Kind.VARIABLE) {
                String newContent;
                VariableTree variableTree = (VariableTree)statement;
                if (SideEffectAnalysis.hasSideEffect((ExpressionTree)((VariableTree)statement).getInitializer())) {
                    encounteredSideEffects = true;
                    newContent = "";
                    if (varKind == ElementKind.FIELD) {
                        newContent = String.format("%s{ %s; }", varSymbol.isStatic() ? "static " : "", variableTree.getInitializer());
                    }
                    SuggestedFix replacement = Unused.replaceWithComments(usagePath, newContent, state);
                    fix.merge(replacement);
                    removeSideEffectsFix.merge(replacement);
                    continue;
                }
                if (Unused.isEnhancedForLoopVar(usagePath)) {
                    newContent = String.format("%s%s unused", variableTree.getModifiers() == null ? "" : variableTree.getModifiers().toString(), variableTree.getType());
                    fix.replace((Tree)variableTree, newContent);
                    removeSideEffectsFix.replace((Tree)variableTree, newContent);
                    continue;
                }
                fix.merge(Unused.replaceWithComments(usagePath, "", state));
                removeSideEffectsFix.merge(Unused.replaceWithComments(usagePath, "", state));
                continue;
            }
            if (statement.getKind() == Tree.Kind.EXPRESSION_STATEMENT) {
                SuggestedFix replacement;
                JCTree tree = (JCTree)((Object)((ExpressionStatementTree)statement).getExpression());
                if (tree instanceof CompoundAssignmentTree) {
                    if (SideEffectAnalysis.hasSideEffect((ExpressionTree)((CompoundAssignmentTree)((Object)tree)).getExpression())) {
                        replacement = SuggestedFix.replace((int)tree.getStartPosition(), (int)((JCTree.JCAssignOp)tree).getExpression().getStartPosition(), (String)"");
                        fix.merge(replacement);
                        removeSideEffectsFix.merge(replacement);
                        continue;
                    }
                } else if (tree instanceof AssignmentTree && SideEffectAnalysis.hasSideEffect((ExpressionTree)((AssignmentTree)((Object)tree)).getExpression())) {
                    replacement = SuggestedFix.replace((int)tree.getStartPosition(), (int)((JCTree.JCAssign)tree).getExpression().getStartPosition(), (String)"");
                    fix.merge(replacement);
                    removeSideEffectsFix.merge(replacement);
                    continue;
                }
            }
            fix.replace((Tree)statement, "");
            removeSideEffectsFix.replace((Tree)statement, "");
        }
        return encounteredSideEffects ? ImmutableList.of((Object)fix.build(), (Object)removeSideEffectsFix.build()) : ImmutableList.of((Object)fix.build());
    }

    private static SuggestedFix replaceWithComments(TreePath path, String replacement, VisitorState state) {
        Tree tree = path.getLeaf();
        Tree parent = path.getParentPath().getLeaf();
        if (parent instanceof ClassTree) {
            Tree previousMember = null;
            ClassTree classTree = (ClassTree)parent;
            for (Tree tree2 : classTree.getMembers()) {
                if (tree2 instanceof MethodTree && ASTHelpers.isGeneratedConstructor((MethodTree)((MethodTree)tree2))) continue;
                if (tree2.equals(tree)) break;
                previousMember = tree2;
            }
            if (previousMember != null) {
                return SuggestedFix.replace((int)state.getEndPosition(previousMember), (int)state.getEndPosition(tree), (String)replacement);
            }
            int startOfClass = ((JCTree)((Object)classTree)).getStartPosition();
            String string = state.getSourceCode().subSequence(startOfClass, ((JCTree)tree).getStartPosition()).toString();
            return SuggestedFix.replace((int)(startOfClass + string.indexOf("{") + 1), (int)state.getEndPosition(tree), (String)replacement);
        }
        return SuggestedFix.replace((Tree)tree, (String)replacement);
    }

    private static boolean isEnhancedForLoopVar(TreePath variablePath) {
        Tree tree = variablePath.getLeaf();
        Tree parent = variablePath.getParentPath().getLeaf();
        return parent instanceof EnhancedForLoopTree && ((EnhancedForLoopTree)parent).getVariable() == tree;
    }

    private static boolean exemptedByAnnotation(java.util.List<? extends AnnotationTree> annotations, VisitorState state) {
        for (AnnotationTree annotationTree : annotations) {
            Symbol.TypeSymbol tsym;
            if (((JCTree.JCAnnotation)annotationTree).type == null || !EXEMPTING_ANNOTATION_FULL_NAMES.contains((Object)(tsym = ((JCTree.JCAnnotation)annotationTree).type.tsym).getQualifiedName().toString())) continue;
            return true;
        }
        return false;
    }

    private static boolean exemptedByName(javax.lang.model.element.Name name) {
        return name.toString().toLowerCase().startsWith(EXEMPT_PREFIX);
    }
}

