/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.operation;

import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.Member;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.replicatedmap.impl.operation.ReplicatedMapDataSerializerHook;
import com.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class ClearOperation
extends AbstractOperation
implements IdentifiedDataSerializable {
    private String mapName;
    private boolean replicateClear;
    private transient int response;

    public ClearOperation() {
    }

    public ClearOperation(String mapName, boolean replicateClear) {
        this.mapName = mapName;
        this.replicateClear = replicateClear;
    }

    @Override
    public void run() throws Exception {
        if (this.getNodeEngine().getConfig().isLiteMember()) {
            return;
        }
        ReplicatedMapService service = (ReplicatedMapService)this.getService();
        ReplicatedRecordStore store = service.getReplicatedRecordStore(this.mapName, false, this.getPartitionId());
        if (store == null) {
            return;
        }
        this.response = store.size();
        store.clear();
        if (this.replicateClear) {
            this.replicateClearOperation();
        }
    }

    protected void replicateClearOperation() {
        OperationService operationService = this.getNodeEngine().getOperationService();
        Collection<Address> members = this.getMemberAddresses();
        for (Address address : members) {
            ClearOperation clearOperation = new ClearOperation(this.mapName, false);
            clearOperation.setPartitionId(this.getPartitionId());
            clearOperation.setValidateTarget(false);
            operationService.createInvocationBuilder(this.getServiceName(), (Operation)clearOperation, address).setTryCount(3).invoke();
        }
    }

    protected Collection<Address> getMemberAddresses() {
        Address thisAddress = this.getNodeEngine().getThisAddress();
        Collection<Member> members = this.getNodeEngine().getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
        ArrayList<Address> addresses = new ArrayList<Address>();
        for (Member member : members) {
            Address address = member.getAddress();
            if (address.equals(thisAddress)) continue;
            addresses.add(address);
        }
        return addresses;
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:replicatedMapService";
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.mapName);
        out.writeBoolean(this.replicateClear);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mapName = in.readUTF();
        this.replicateClear = in.readBoolean();
    }
}

