/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="ProtocolBufferOrdinal", summary="ordinal() value of Protocol Buffer Enum can change if enumeration order is changed", explanation="Shuffling of values in a Protocol Buffer enum can change the ordinal value of the enum member. Since changing tag number isn't advisable in protos, use #getNumber() instead which gives the tag number.", category=BugPattern.Category.PROTOBUF, severity=BugPattern.SeverityLevel.WARNING)
public class ProtocolBufferOrdinal
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String PROTO_SUPER_CLASS = "com.google.protobuf.ProtocolMessageEnum";
    private static final Matcher<ExpressionTree> PROTO_MSG_ORDINAL_MATCHER = Matchers.instanceMethod().onDescendantOf("com.google.protobuf.ProtocolMessageEnum").named("ordinal");

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        if (!PROTO_MSG_ORDINAL_MATCHER.matches((Tree)methodInvocationTree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree rec = ASTHelpers.getReceiver((ExpressionTree)methodInvocationTree);
        if (rec != null) {
            SuggestedFix fix = SuggestedFix.replace((int)state.getEndPosition((Tree)rec), (int)state.getEndPosition((Tree)methodInvocationTree), (String)".getNumber()");
            return this.describeMatch(methodInvocationTree, (Fix)fix);
        }
        return Description.NO_MATCH;
    }
}

