/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Floats;
import com.google.common.truth.AbstractArraySubject;
import com.google.common.truth.Correspondence;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.FloatSubject;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.MathUtil;
import com.google.common.truth.Ordered;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public final class PrimitiveFloatArraySubject
extends AbstractArraySubject<PrimitiveFloatArraySubject, float[]> {
    private static final Correspondence<Float, Number> EXACT_EQUALITY_CORRESPONDENCE = new Correspondence<Float, Number>(){

        @Override
        public boolean compare(Float actual, Number expected) {
            return actual.equals(Float.valueOf(PrimitiveFloatArraySubject.checkedToFloat(expected)));
        }

        @Override
        public String toString() {
            return "is exactly equal to";
        }
    };

    PrimitiveFloatArraySubject(FailureMetadata metadata, @Nullable float[] o) {
        super(metadata, o);
    }

    @Override
    protected String underlyingType() {
        return "float";
    }

    @Override
    protected List<Float> listRepresentation() {
        return Floats.asList((float[])((float[])this.actual()));
    }

    @Override
    public void isEqualTo(Object expected) {
        float[] actual = (float[])this.actual();
        if (actual == expected) {
            return;
        }
        try {
            float[] expectedArray = (float[])expected;
            if (!Arrays.equals(actual, expectedArray)) {
                this.fail("is equal to", (Object)Floats.asList((float[])expectedArray));
            }
        }
        catch (ClassCastException e) {
            this.failWithBadType(expected);
        }
    }

    @Deprecated
    public void isEqualTo(Object expected, float tolerance) {
        float[] actual = (float[])this.actual();
        if (actual == expected) {
            return;
        }
        try {
            float[] expectedArray = (float[])expected;
            if (expectedArray.length != actual.length) {
                this.failWithRawMessage("Arrays are of different lengths. expected: %s, actual %s", Floats.asList((float[])expectedArray), Floats.asList((float[])actual));
                return;
            }
            ArrayList<Integer> unequalIndices = new ArrayList<Integer>();
            for (int i = 0; i < expectedArray.length; ++i) {
                if (MathUtil.equalWithinTolerance(actual[i], expectedArray[i], tolerance)) continue;
                unequalIndices.add(i);
            }
            if (!unequalIndices.isEmpty()) {
                this.fail("is equal to", (Object)Floats.asList((float[])expectedArray));
                return;
            }
        }
        catch (ClassCastException e) {
            this.failWithBadType(expected);
        }
    }

    @Override
    public void isNotEqualTo(Object expected) {
        float[] actual = (float[])this.actual();
        try {
            float[] expectedArray = (float[])expected;
            if (actual == expected || Arrays.equals(actual, expectedArray)) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.actualAsString(), Floats.asList((float[])expectedArray));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Deprecated
    public void isNotEqualTo(Object expectedArray, float tolerance) {
        float[] actual = (float[])this.actual();
        try {
            float[] expected = (float[])expectedArray;
            if (actual == expected) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.actualAsString(), Floats.asList((float[])expected));
                return;
            }
            if (expected.length != actual.length) {
                return;
            }
            ArrayList<Integer> unequalIndices = new ArrayList<Integer>();
            for (int i = 0; i < expected.length; ++i) {
                if (MathUtil.equalWithinTolerance(actual[i], expected[i], tolerance)) continue;
                unequalIndices.add(i);
            }
            if (unequalIndices.isEmpty()) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.actualAsString(), Floats.asList((float[])expected));
                return;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Deprecated
    public TolerantPrimitiveFloatArrayComparison hasValuesWithin(final float tolerance) {
        return new TolerantPrimitiveFloatArrayComparison(){

            @Override
            public void ofElementsIn(Iterable<? extends Number> expected) {
                FloatSubject.checkTolerance(tolerance);
                float[] actual = (float[])Preconditions.checkNotNull(PrimitiveFloatArraySubject.this.actual());
                ArrayList<Integer> mismatches = new ArrayList<Integer>();
                int expectedCount = 0;
                for (Number number : expected) {
                    if (expectedCount < actual.length && !MathUtil.equalWithinTolerance(actual[expectedCount], number.floatValue(), tolerance)) {
                        mismatches.add(expectedCount);
                    }
                    ++expectedCount;
                }
                if (actual.length != expectedCount) {
                    PrimitiveFloatArraySubject.this.failWithRawMessage("Not true that %s has values within %s of <%s>. Expected length <%s> but got <%s>", PrimitiveFloatArraySubject.this.actualAsString(), Float.valueOf(tolerance), Iterables.toString(expected), expectedCount, actual.length);
                    return;
                }
                if (!mismatches.isEmpty()) {
                    PrimitiveFloatArraySubject.this.failWithBadResults("has values within " + tolerance + " of", Iterables.toString(expected), "differs at indexes", mismatches);
                    return;
                }
            }
        };
    }

    @Deprecated
    public TolerantPrimitiveFloatArrayComparison hasValuesNotWithin(final float tolerance) {
        return new TolerantPrimitiveFloatArrayComparison(){

            @Override
            public void ofElementsIn(Iterable<? extends Number> expected) {
                FloatSubject.checkTolerance(tolerance);
                float[] actual = (float[])Preconditions.checkNotNull(PrimitiveFloatArraySubject.this.actual());
                int expectedCount = 0;
                for (Number number : expected) {
                    if (expectedCount < actual.length && MathUtil.notEqualWithinTolerance(actual[expectedCount], number.floatValue(), tolerance)) {
                        return;
                    }
                    ++expectedCount;
                }
                if (actual.length == expectedCount) {
                    PrimitiveFloatArraySubject.this.fail("has values not within " + tolerance + " of", (Object)Iterables.toString(expected));
                }
            }
        };
    }

    public FloatArrayAsIterable usingTolerance(double tolerance) {
        return new FloatArrayAsIterable(Correspondence.tolerance(tolerance), this.iterableSubject());
    }

    private static float checkedToFloat(Number expected) {
        Preconditions.checkNotNull((Object)expected);
        Preconditions.checkArgument((!(expected instanceof Double) ? 1 : 0) != 0, (Object)"Expected value in assertion using exact float equality was a double, which is not supported as a double may not have an exact float representation");
        Preconditions.checkArgument((expected instanceof Float || expected instanceof Integer || expected instanceof Long ? 1 : 0) != 0, (String)"Expected value in assertion using exact float equality was of unsupported type %s (it may not have an exact float representation)", expected.getClass());
        if (expected instanceof Integer) {
            Preconditions.checkArgument((Math.abs((Integer)expected) <= 0x1000000 ? 1 : 0) != 0, (String)"Expected value %s in assertion using exact float equality was an int with an absolute value greater than 2^24 which has no exact float representation", (Object)expected);
        }
        if (expected instanceof Long) {
            Preconditions.checkArgument((Math.abs((Long)expected) <= 0x1000000L ? 1 : 0) != 0, (String)"Expected value %s in assertion using exact float equality was a long with an absolute value greater than 2^24 which has no exact float representation", (Object)expected);
        }
        return expected.floatValue();
    }

    public FloatArrayAsIterable usingExactEquality() {
        return new FloatArrayAsIterable(EXACT_EQUALITY_CORRESPONDENCE, this.iterableSubject());
    }

    private IterableSubject iterableSubject() {
        return this.internalCustomName() != null ? (IterableSubject)this.check().that(this.listRepresentation()).named(this.internalCustomName(), new Object[0]) : this.check().that(this.listRepresentation());
    }

    public static final class FloatArrayAsIterable
    extends IterableSubject.UsingCorrespondence<Float, Number> {
        FloatArrayAsIterable(Correspondence<? super Float, Number> correspondence, IterableSubject subject) {
            IterableSubject iterableSubject = subject;
            iterableSubject.getClass();
            super(iterableSubject, correspondence);
        }

        @CanIgnoreReturnValue
        public Ordered containsAllOf(float[] expected) {
            return this.containsAllIn(Floats.asList((float[])expected));
        }

        public void containsAnyOf(float[] expected) {
            this.containsAnyIn(Floats.asList((float[])expected));
        }

        @CanIgnoreReturnValue
        public Ordered containsExactly(float[] expected) {
            return this.containsExactlyElementsIn(Floats.asList((float[])expected));
        }

        public void containsNoneOf(float[] excluded) {
            this.containsNoneIn(Floats.asList((float[])excluded));
        }
    }

    public static abstract class TolerantPrimitiveFloatArrayComparison {
        private TolerantPrimitiveFloatArrayComparison() {
        }

        public void of(float ... expected) {
            this.ofElementsIn(Floats.asList((float[])expected));
        }

        public abstract void ofElementsIn(Iterable<? extends Number> var1);

        @Deprecated
        public boolean equals(@Nullable Object o) {
            throw new UnsupportedOperationException("If you meant to compare float arrays, use .of() or .ofElementsIn() instead.");
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException("Subject.hashCode() is not supported.");
        }
    }
}

