/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.util.AbstractLog;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.BasicDiagnosticFormatter;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.RawDiagnosticFormatter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;

public class Log
extends AbstractLog {
    public static final Context.Key<Log> logKey = new Context.Key();
    public static final Context.Key<PrintWriter> outKey = new Context.Key();
    public static final Context.Key<PrintWriter> errKey = new Context.Key();
    private final Map<WriterKind, PrintWriter> writers;
    protected int MaxErrors;
    protected int MaxWarnings;
    public boolean promptOnError;
    public boolean emitWarnings;
    public boolean suppressNotes;
    public boolean dumpOnError;
    protected DiagnosticListener<? super JavaFileObject> diagListener;
    private DiagnosticFormatter<JCDiagnostic> diagFormatter;
    public Set<String> expectDiagKeys;
    public boolean compressedOutput;
    private JavacMessages messages;
    private DiagnosticHandler diagnosticHandler;
    public int nerrors = 0;
    public int nwarnings = 0;
    protected Set<Pair<JavaFileObject, Integer>> recorded = new HashSet<Pair<JavaFileObject, Integer>>();
    protected Set<Pair<JavaFileObject, String>> recordedSourceLevelErrors = new HashSet<Pair<JavaFileObject, String>>();
    private static boolean useRawMessages = false;

    public static Log instance(Context context) {
        Log log = context.get(logKey);
        if (log == null) {
            log = new Log(context);
        }
        return log;
    }

    public static void preRegister(Context context2, PrintWriter printWriter) {
        context2.put(Log.class, context -> new Log(context, printWriter));
    }

    protected Log(Context context) {
        this(context, Log.initWriters(context));
    }

    private static Map<WriterKind, PrintWriter> initWriters(Context context) {
        PrintWriter printWriter = context.get(outKey);
        PrintWriter printWriter2 = context.get(errKey);
        if (printWriter == null && printWriter2 == null) {
            printWriter = new PrintWriter(System.out, true);
            printWriter2 = new PrintWriter(System.err, true);
            return Log.initWriters(printWriter, printWriter2);
        }
        if (printWriter == null || printWriter2 == null) {
            PrintWriter printWriter3 = printWriter != null ? printWriter : printWriter2;
            return Log.initWriters(printWriter3, printWriter3);
        }
        return Log.initWriters(printWriter, printWriter2);
    }

    protected Log(Context context, PrintWriter printWriter) {
        this(context, Log.initWriters(printWriter, printWriter));
    }

    protected Log(Context context, PrintWriter printWriter, PrintWriter printWriter2) {
        this(context, Log.initWriters(printWriter, printWriter2));
    }

    private static Map<WriterKind, PrintWriter> initWriters(PrintWriter printWriter, PrintWriter printWriter2) {
        EnumMap<WriterKind, PrintWriter> enumMap = new EnumMap<WriterKind, PrintWriter>(WriterKind.class);
        enumMap.put(WriterKind.ERROR, printWriter2);
        enumMap.put(WriterKind.WARNING, printWriter2);
        enumMap.put(WriterKind.NOTICE, printWriter2);
        enumMap.put(WriterKind.STDOUT, printWriter);
        enumMap.put(WriterKind.STDERR, printWriter2);
        return enumMap;
    }

    @Deprecated
    protected Log(Context context, PrintWriter printWriter, PrintWriter printWriter2, PrintWriter printWriter3) {
        this(context, Log.initWriters(printWriter, printWriter2, printWriter3));
    }

    @Deprecated
    private static Map<WriterKind, PrintWriter> initWriters(PrintWriter printWriter, PrintWriter printWriter2, PrintWriter printWriter3) {
        EnumMap<WriterKind, PrintWriter> enumMap = new EnumMap<WriterKind, PrintWriter>(WriterKind.class);
        enumMap.put(WriterKind.ERROR, printWriter);
        enumMap.put(WriterKind.WARNING, printWriter2);
        enumMap.put(WriterKind.NOTICE, printWriter3);
        enumMap.put(WriterKind.STDOUT, printWriter3);
        enumMap.put(WriterKind.STDERR, printWriter);
        return enumMap;
    }

    private Log(Context context, Map<WriterKind, PrintWriter> map) {
        super(JCDiagnostic.Factory.instance(context));
        DiagnosticListener diagnosticListener;
        context.put(logKey, this);
        this.writers = map;
        this.diagListener = diagnosticListener = context.get(DiagnosticListener.class);
        this.diagnosticHandler = new DefaultDiagnosticHandler();
        this.messages = JavacMessages.instance(context);
        this.messages.add("com.sun.tools.javac.resources.javac");
        Options options = Options.instance(context);
        this.initOptions(options);
        options.addListener(() -> this.initOptions(options));
    }

    private void initOptions(Options options) {
        this.dumpOnError = options.isSet(Option.DOE);
        this.promptOnError = options.isSet(Option.PROMPT);
        this.emitWarnings = options.isUnset(Option.XLINT_CUSTOM, "none");
        this.suppressNotes = options.isSet("suppressNotes");
        this.MaxErrors = this.getIntOption(options, Option.XMAXERRS, this.getDefaultMaxErrors());
        this.MaxWarnings = this.getIntOption(options, Option.XMAXWARNS, this.getDefaultMaxWarnings());
        boolean bl = options.isSet("rawDiagnostics");
        this.diagFormatter = bl ? new RawDiagnosticFormatter(options) : new BasicDiagnosticFormatter(options, this.messages);
        String string = options.get("expectKeys");
        if (string != null) {
            this.expectDiagKeys = new HashSet<String>(Arrays.asList(string.split(", *")));
        }
    }

    private int getIntOption(Options options, Option option, int n) {
        String string = options.get(option);
        try {
            if (string != null) {
                int n2 = Integer.parseInt(string);
                return n2 <= 0 ? Integer.MAX_VALUE : n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    protected int getDefaultMaxErrors() {
        return 100;
    }

    protected int getDefaultMaxWarnings() {
        return 100;
    }

    public boolean hasDiagnosticListener() {
        return this.diagListener != null;
    }

    public void setEndPosTable(JavaFileObject javaFileObject, EndPosTable endPosTable) {
        Assert.checkNonNull(javaFileObject);
        this.getSource(javaFileObject).setEndPosTable(endPosTable);
    }

    public JavaFileObject currentSourceFile() {
        return this.source == null ? null : this.source.getFile();
    }

    public DiagnosticFormatter<JCDiagnostic> getDiagnosticFormatter() {
        return this.diagFormatter;
    }

    public void setDiagnosticFormatter(DiagnosticFormatter<JCDiagnostic> diagnosticFormatter) {
        this.diagFormatter = diagnosticFormatter;
    }

    public PrintWriter getWriter(WriterKind writerKind) {
        return this.writers.get((Object)writerKind);
    }

    public void setWriter(WriterKind writerKind, PrintWriter printWriter) {
        Assert.checkNonNull(printWriter);
        this.writers.put(writerKind, printWriter);
    }

    public void setWriters(PrintWriter printWriter) {
        Assert.checkNonNull(printWriter);
        for (WriterKind writerKind : WriterKind.values()) {
            this.writers.put(writerKind, printWriter);
        }
    }

    public void popDiagnosticHandler(DiagnosticHandler diagnosticHandler) {
        Assert.check(this.diagnosticHandler == diagnosticHandler);
        this.diagnosticHandler = diagnosticHandler.prev;
    }

    public void flush() {
        for (PrintWriter printWriter : this.writers.values()) {
            printWriter.flush();
        }
    }

    public void flush(WriterKind writerKind) {
        this.getWriter(writerKind).flush();
    }

    protected boolean shouldReport(JavaFileObject javaFileObject, int n) {
        boolean bl;
        if (javaFileObject == null) {
            return true;
        }
        Pair<JavaFileObject, Integer> pair = new Pair<JavaFileObject, Integer>(javaFileObject, n);
        boolean bl2 = bl = !this.recorded.contains(pair);
        if (bl) {
            this.recorded.add(pair);
        }
        return bl;
    }

    private boolean shouldReport(JCDiagnostic jCDiagnostic) {
        boolean bl;
        JavaFileObject javaFileObject = jCDiagnostic.getSource();
        if (javaFileObject == null) {
            return true;
        }
        if (!this.shouldReport(javaFileObject, jCDiagnostic.getIntPosition())) {
            return false;
        }
        if (!jCDiagnostic.isFlagSet(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL)) {
            return true;
        }
        Pair<JavaFileObject, String> pair = new Pair<JavaFileObject, String>(javaFileObject, jCDiagnostic.getCode());
        boolean bl2 = bl = !this.recordedSourceLevelErrors.contains(pair);
        if (bl) {
            this.recordedSourceLevelErrors.add(pair);
        }
        return bl;
    }

    public void prompt() {
        if (this.promptOnError) {
            System.err.println(this.localize("resume.abort", new Object[0]));
            try {
                while (true) {
                    switch (System.in.read()) {
                        case 65: 
                        case 97: {
                            System.exit(-1);
                            return;
                        }
                        case 82: 
                        case 114: {
                            return;
                        }
                        case 88: 
                        case 120: {
                            throw new AssertionError((Object)"user abort");
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void printErrLine(int n, PrintWriter printWriter) {
        String string;
        String string2 = string = this.source == null ? null : this.source.getLine(n);
        if (string == null) {
            return;
        }
        int n2 = this.source.getColumnNumber(n, false);
        Log.printRawLines(printWriter, string);
        for (int i = 0; i < n2 - 1; ++i) {
            printWriter.print(string.charAt(i) == '\t' ? "\t" : " ");
        }
        printWriter.println("^");
        printWriter.flush();
    }

    public void printNewline() {
        PrintWriter printWriter = this.writers.get((Object)WriterKind.NOTICE);
        printWriter.println();
    }

    public void printNewline(WriterKind writerKind) {
        this.getWriter(writerKind).println();
    }

    public void printLines(String string, Object ... objectArray) {
        PrintWriter printWriter = this.writers.get((Object)WriterKind.NOTICE);
        Log.printRawLines(printWriter, this.localize(string, objectArray));
    }

    public void printLines(PrefixKind prefixKind, String string, Object ... objectArray) {
        PrintWriter printWriter = this.writers.get((Object)WriterKind.NOTICE);
        Log.printRawLines(printWriter, this.localize(prefixKind, string, objectArray));
    }

    public void printLines(WriterKind writerKind, String string, Object ... objectArray) {
        Log.printRawLines(this.getWriter(writerKind), this.localize(string, objectArray));
    }

    public void printLines(WriterKind writerKind, PrefixKind prefixKind, String string, Object ... objectArray) {
        Log.printRawLines(this.getWriter(writerKind), this.localize(prefixKind, string, objectArray));
    }

    public void printRawLines(String string) {
        PrintWriter printWriter = this.writers.get((Object)WriterKind.NOTICE);
        Log.printRawLines(printWriter, string);
    }

    public void printRawLines(WriterKind writerKind, String string) {
        Log.printRawLines(this.getWriter(writerKind), string);
    }

    public static void printRawLines(PrintWriter printWriter, String string) {
        int n;
        while ((n = string.indexOf(10)) != -1) {
            printWriter.println(string.substring(0, n));
            string = string.substring(n + 1);
        }
        if (string.length() != 0) {
            printWriter.println(string);
        }
    }

    public void printVerbose(String string, Object ... objectArray) {
        PrintWriter printWriter = this.writers.get((Object)WriterKind.NOTICE);
        Log.printRawLines(printWriter, this.localize("verbose." + string, objectArray));
    }

    @Override
    protected void directError(String string, Object ... objectArray) {
        PrintWriter printWriter = this.writers.get((Object)WriterKind.ERROR);
        Log.printRawLines(printWriter, this.localize(string, objectArray));
        printWriter.flush();
    }

    public void strictWarning(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        this.writeDiagnostic(this.diags.warning(null, this.source, diagnosticPosition, string, objectArray));
        ++this.nwarnings;
    }

    @Override
    public void report(JCDiagnostic jCDiagnostic) {
        this.diagnosticHandler.report(jCDiagnostic);
    }

    protected void writeDiagnostic(JCDiagnostic jCDiagnostic) {
        if (this.diagListener != null) {
            this.diagListener.report(jCDiagnostic);
            return;
        }
        PrintWriter printWriter = this.getWriterForDiagnosticType(jCDiagnostic.getType());
        Log.printRawLines(printWriter, this.diagFormatter.format(jCDiagnostic, this.messages.getCurrentLocale()));
        if (this.promptOnError) {
            switch (jCDiagnostic.getType()) {
                case WARNING: 
                case ERROR: {
                    this.prompt();
                }
            }
        }
        if (this.dumpOnError) {
            new RuntimeException().printStackTrace(printWriter);
        }
        printWriter.flush();
    }

    @Deprecated
    protected PrintWriter getWriterForDiagnosticType(JCDiagnostic.DiagnosticType diagnosticType) {
        switch (diagnosticType) {
            case FRAGMENT: {
                throw new IllegalArgumentException();
            }
            case NOTE: {
                return this.writers.get((Object)WriterKind.NOTICE);
            }
            case WARNING: {
                return this.writers.get((Object)WriterKind.WARNING);
            }
            case ERROR: {
                return this.writers.get((Object)WriterKind.ERROR);
            }
        }
        throw new Error();
    }

    public static String getLocalizedString(String string, Object ... objectArray) {
        return JavacMessages.getDefaultLocalizedString(PrefixKind.COMPILER_MISC.key(string), objectArray);
    }

    public String localize(String string, Object ... objectArray) {
        return this.localize(PrefixKind.COMPILER_MISC, string, objectArray);
    }

    public String localize(JCDiagnostic.DiagnosticInfo diagnosticInfo) {
        if (useRawMessages) {
            return diagnosticInfo.key();
        }
        return this.messages.getLocalizedString(diagnosticInfo.key(), diagnosticInfo.args);
    }

    public String localize(PrefixKind prefixKind, String string, Object ... objectArray) {
        if (useRawMessages) {
            return prefixKind.key(string);
        }
        return this.messages.getLocalizedString(prefixKind.key(string), objectArray);
    }

    private void printRawDiag(PrintWriter printWriter, String string, int n, String string2) {
        if (this.source == null || n == -1) {
            Log.printRawLines(printWriter, string + string2);
        } else {
            int n2 = this.source.getLineNumber(n);
            JavaFileObject javaFileObject = this.source.getFile();
            if (javaFileObject != null) {
                Log.printRawLines(printWriter, javaFileObject.getName() + ":" + n2 + ": " + string2);
            }
            this.printErrLine(n, printWriter);
        }
        printWriter.flush();
    }

    public void rawError(int n, String string) {
        PrintWriter printWriter = this.writers.get((Object)WriterKind.ERROR);
        if (this.nerrors < this.MaxErrors && this.shouldReport(this.currentSourceFile(), n)) {
            this.printRawDiag(printWriter, "error: ", n, string);
            this.prompt();
            ++this.nerrors;
        }
        printWriter.flush();
    }

    public void rawWarning(int n, String string) {
        PrintWriter printWriter = this.writers.get((Object)WriterKind.ERROR);
        if (this.nwarnings < this.MaxWarnings && this.emitWarnings) {
            this.printRawDiag(printWriter, "warning: ", n, string);
        }
        this.prompt();
        ++this.nwarnings;
        printWriter.flush();
    }

    public static String format(String string, Object ... objectArray) {
        return String.format((Locale)null, string, objectArray);
    }

    private class DefaultDiagnosticHandler
    extends DiagnosticHandler {
        private DefaultDiagnosticHandler() {
        }

        @Override
        public void report(JCDiagnostic jCDiagnostic) {
            if (Log.this.expectDiagKeys != null) {
                Log.this.expectDiagKeys.remove(jCDiagnostic.getCode());
            }
            switch (jCDiagnostic.getType()) {
                case FRAGMENT: {
                    throw new IllegalArgumentException();
                }
                case NOTE: {
                    if (!Log.this.emitWarnings && !jCDiagnostic.isMandatory() || Log.this.suppressNotes) break;
                    Log.this.writeDiagnostic(jCDiagnostic);
                    break;
                }
                case WARNING: {
                    if (!Log.this.emitWarnings && !jCDiagnostic.isMandatory() || Log.this.nwarnings >= Log.this.MaxWarnings) break;
                    Log.this.writeDiagnostic(jCDiagnostic);
                    ++Log.this.nwarnings;
                    break;
                }
                case ERROR: {
                    if (Log.this.nerrors >= Log.this.MaxErrors || !jCDiagnostic.isFlagSet(JCDiagnostic.DiagnosticFlag.MULTIPLE) && !Log.this.shouldReport(jCDiagnostic)) break;
                    Log.this.writeDiagnostic(jCDiagnostic);
                    ++Log.this.nerrors;
                }
            }
            if (jCDiagnostic.isFlagSet(JCDiagnostic.DiagnosticFlag.COMPRESSED)) {
                Log.this.compressedOutput = true;
            }
        }
    }

    public static enum WriterKind {
        NOTICE,
        WARNING,
        ERROR,
        STDOUT,
        STDERR;

    }

    public static class DeferredDiagnosticHandler
    extends DiagnosticHandler {
        private Queue<JCDiagnostic> deferred = new ListBuffer<JCDiagnostic>();
        private final Filter<JCDiagnostic> filter;

        public DeferredDiagnosticHandler(Log log) {
            this(log, null);
        }

        public DeferredDiagnosticHandler(Log log, Filter<JCDiagnostic> filter) {
            this.filter = filter;
            this.install(log);
        }

        @Override
        public void report(JCDiagnostic jCDiagnostic) {
            if (!jCDiagnostic.isFlagSet(JCDiagnostic.DiagnosticFlag.NON_DEFERRABLE) && (this.filter == null || this.filter.accepts(jCDiagnostic))) {
                this.deferred.add(jCDiagnostic);
            } else {
                this.prev.report(jCDiagnostic);
            }
        }

        public Queue<JCDiagnostic> getDiagnostics() {
            return this.deferred;
        }

        public void reportDeferredDiagnostics() {
            this.reportDeferredDiagnostics(EnumSet.allOf(Diagnostic.Kind.class));
        }

        public void reportDeferredDiagnostics(Set<Diagnostic.Kind> set) {
            JCDiagnostic jCDiagnostic;
            while ((jCDiagnostic = this.deferred.poll()) != null) {
                if (!set.contains((Object)jCDiagnostic.getKind())) continue;
                this.prev.report(jCDiagnostic);
            }
            this.deferred = null;
        }
    }

    public static class DiscardDiagnosticHandler
    extends DiagnosticHandler {
        public DiscardDiagnosticHandler(Log log) {
            this.install(log);
        }

        @Override
        public void report(JCDiagnostic jCDiagnostic) {
        }
    }

    public static abstract class DiagnosticHandler {
        protected DiagnosticHandler prev;

        protected void install(Log log) {
            this.prev = log.diagnosticHandler;
            log.diagnosticHandler = this;
        }

        public abstract void report(JCDiagnostic var1);
    }

    public static enum PrefixKind {
        JAVAC("javac."),
        COMPILER_MISC("compiler.misc.");

        final String value;

        private PrefixKind(String string2) {
            this.value = string2;
        }

        public String key(String string) {
            return this.value + string;
        }
    }
}

