/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.base.MoreObjects;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.DynamicCodec;
import com.google.devtools.build.lib.skyframe.serialization.EnumCodec;
import com.google.devtools.build.lib.skyframe.serialization.LambdaCodec;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class ObjectCodecRegistry {
    private static final Logger logger = Logger.getLogger(ObjectCodecRegistry.class.getName());
    private final boolean allowDefaultCodec;
    private final ConcurrentMap<Class<?>, CodecDescriptor> classMappedCodecs;
    private final ImmutableList<CodecDescriptor> tagMappedCodecs;
    private final int referenceConstantsStartTag;
    private final IdentityHashMap<Object, Integer> referenceConstantsMap;
    private final ImmutableList<Object> referenceConstants;
    private final ImmutableList<String> classNames;
    private final IdentityHashMap<String, Supplier<CodecDescriptor>> dynamicCodecs;

    public static Builder newBuilder() {
        return new Builder();
    }

    private ObjectCodecRegistry(ImmutableSet<ObjectCodec<?>> memoizingCodecs, ImmutableList<Object> referenceConstants, ImmutableSortedSet<String> classNames, ImmutableList<String> blacklistedClassNamePrefixes, boolean allowDefaultCodec) {
        this.allowDefaultCodec = allowDefaultCodec;
        int nextTag = 1;
        this.classMappedCodecs = new ConcurrentHashMap(memoizingCodecs.size(), 0.75f, Runtime.getRuntime().availableProcessors());
        ImmutableList.Builder tagMappedMemoizingCodecsBuilder = ImmutableList.builderWithExpectedSize((int)memoizingCodecs.size());
        nextTag = ObjectCodecRegistry.processCodecs(memoizingCodecs, nextTag, (ImmutableList.Builder<CodecDescriptor>)tagMappedMemoizingCodecsBuilder, this.classMappedCodecs);
        this.tagMappedCodecs = tagMappedMemoizingCodecsBuilder.build();
        this.referenceConstantsStartTag = nextTag;
        this.referenceConstantsMap = new IdentityHashMap();
        for (Object constant : referenceConstants) {
            this.referenceConstantsMap.put(constant, nextTag++);
        }
        this.referenceConstants = referenceConstants;
        this.classNames = (ImmutableList)classNames.stream().filter(str -> ObjectCodecRegistry.isAllowed(str, blacklistedClassNamePrefixes)).collect(ImmutableList.toImmutableList());
        this.dynamicCodecs = ObjectCodecRegistry.createDynamicCodecs(this.classNames, nextTag);
        logger.info("Initialized " + this + " with approximate hash: " + this.deepHashCode());
    }

    public CodecDescriptor getCodecDescriptorForObject(Object obj) throws SerializationException.NoCodecException {
        Class<Object> type = obj.getClass();
        CodecDescriptor descriptor = this.getCodecDescriptor(type);
        if (descriptor != null) {
            return descriptor;
        }
        if (!this.allowDefaultCodec) {
            throw new SerializationException.NoCodecException("No codec available for " + type + " and default fallback disabled");
        }
        if (obj instanceof Enum) {
            type = ((Enum)obj).getDeclaringClass();
        }
        return this.getDynamicCodecDescriptor(type.getName(), type);
    }

    @Nullable
    private CodecDescriptor getCodecDescriptor(Class<?> type) {
        for (Class<?> nextType = type; nextType != null; nextType = nextType.getSuperclass()) {
            CodecDescriptor result = (CodecDescriptor)this.classMappedCodecs.get(nextType);
            if (result == null) continue;
            if (nextType != type) {
                this.classMappedCodecs.put(type, result);
            }
            return result;
        }
        return null;
    }

    @Nullable
    Object maybeGetConstantByTag(int tag) {
        if (this.referenceConstantsStartTag <= tag && tag < this.referenceConstantsStartTag + this.referenceConstants.size()) {
            return this.referenceConstants.get(tag - this.referenceConstantsStartTag);
        }
        return null;
    }

    @Nullable
    Integer maybeGetTagForConstant(Object object) {
        return this.referenceConstantsMap.get(object);
    }

    public CodecDescriptor getCodecDescriptorByTag(int tag) throws SerializationException.NoCodecException {
        int tagOffset = tag - 1;
        if (tagOffset < 0) {
            throw new SerializationException.NoCodecException("No codec available for tag " + tag);
        }
        if (tagOffset < this.tagMappedCodecs.size()) {
            return (CodecDescriptor)this.tagMappedCodecs.get(tagOffset);
        }
        tagOffset -= this.tagMappedCodecs.size();
        if (!this.allowDefaultCodec || (tagOffset -= this.referenceConstants.size()) < 0 || tagOffset >= this.classNames.size()) {
            throw new SerializationException.NoCodecException("No codec available for tag " + tag);
        }
        return this.getDynamicCodecDescriptor((String)this.classNames.get(tagOffset), null);
    }

    public Builder getBuilder() {
        Builder builder = ObjectCodecRegistry.newBuilder();
        builder.setAllowDefaultCodec(this.allowDefaultCodec);
        for (Map.Entry entry : this.classMappedCodecs.entrySet()) {
            builder.add(((CodecDescriptor)entry.getValue()).getCodec());
        }
        for (Object constant : this.referenceConstants) {
            builder.addReferenceConstant(constant);
        }
        for (String className : this.classNames) {
            builder.addClassName(className);
        }
        return builder;
    }

    ImmutableList<String> classNames() {
        return this.classNames;
    }

    private static int processCodecs(Iterable<? extends ObjectCodec<?>> memoizingCodecs, int nextTag, ImmutableList.Builder<CodecDescriptor> tagMappedCodecsBuilder, ConcurrentMap<Class<?>, CodecDescriptor> codecsBuilder) {
        for (ObjectCodec codec : ImmutableList.sortedCopyOf(Comparator.comparing(o -> o.getEncodedClass().getName()), memoizingCodecs)) {
            TypedCodecDescriptor codecDescriptor = new TypedCodecDescriptor(nextTag++, codec);
            tagMappedCodecsBuilder.add(codecDescriptor);
            codecsBuilder.put(codec.getEncodedClass(), codecDescriptor);
            for (Class otherClass : codec.additionalEncodedClasses()) {
                codecsBuilder.put(otherClass, codecDescriptor);
            }
        }
        return nextTag;
    }

    private static IdentityHashMap<String, Supplier<CodecDescriptor>> createDynamicCodecs(ImmutableList<String> classNames, int nextTag) {
        IdentityHashMap<String, Supplier<CodecDescriptor>> dynamicCodecs = new IdentityHashMap<String, Supplier<CodecDescriptor>>(classNames.size());
        for (String className : classNames) {
            int tag = nextTag++;
            dynamicCodecs.put(className, (Supplier<CodecDescriptor>)Suppliers.memoize(() -> ObjectCodecRegistry.createDynamicCodecDescriptor(tag, className)));
        }
        return dynamicCodecs;
    }

    private static boolean isAllowed(String className, ImmutableList<String> blacklistedClassNamePefixes) {
        for (String blacklistedClassNamePrefix : blacklistedClassNamePefixes) {
            if (!className.startsWith(blacklistedClassNamePrefix)) continue;
            return false;
        }
        return true;
    }

    private static CodecDescriptor createDynamicCodecDescriptor(int tag, String className) {
        try {
            Class<?> type = Class.forName(className);
            if (type.isEnum()) {
                return ObjectCodecRegistry.createCodecDescriptorForEnum(tag, type);
            }
            return new TypedCodecDescriptor(tag, new DynamicCodec(Class.forName(className)));
        }
        catch (ReflectiveOperationException e) {
            new SerializationException("Could not create codec for type: " + className, e).printStackTrace();
            return null;
        }
    }

    private static CodecDescriptor createCodecDescriptorForEnum(int tag, Class<?> enumType) {
        return new TypedCodecDescriptor(tag, new EnumCodec(enumType));
    }

    private CodecDescriptor getDynamicCodecDescriptor(String className, @Nullable Class<?> type) throws SerializationException.NoCodecException {
        Supplier<CodecDescriptor> supplier = this.dynamicCodecs.get(className);
        if (supplier != null) {
            CodecDescriptor descriptor = supplier.get();
            if (descriptor == null) {
                throw new SerializationException.NoCodecException("There was a problem creating a codec for " + className + ". Check logs for details", type);
            }
            return descriptor;
        }
        if (type != null && LambdaCodec.isProbablyLambda(type)) {
            if (Serializable.class.isAssignableFrom(type)) {
                return (CodecDescriptor)this.classMappedCodecs.get(Serializable.class);
            }
            throw new SerializationException.NoCodecException("No default codec available for " + className + ". If this is a lambda, try casting it to (type & Serializable), like (Supplier<String> & Serializable)", type);
        }
        throw new SerializationException.NoCodecException("No default codec available for " + className, type);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("allowDefaultCodec", this.allowDefaultCodec).add("classMappedCodecs.size", this.classMappedCodecs.size()).add("tagMappedCodecs.size", this.tagMappedCodecs.size()).add("referenceConstantsStartTag", this.referenceConstantsStartTag).add("referenceConstants.size", this.referenceConstants.size()).add("classNames.size", this.classNames.size()).add("dynamicCodecs.size", this.dynamicCodecs.size()).toString();
    }

    private int deepHashCode() {
        int hash = this.toString().hashCode();
        for (CodecDescriptor codecDescriptor : this.tagMappedCodecs) {
            hash = 37 * hash + 31 * codecDescriptor.getTag() + ObjectCodecRegistry.hashClass(codecDescriptor.getCodec().getEncodedClass());
        }
        for (Object referenceConstant : this.referenceConstants) {
            hash = 37 * hash + ObjectCodecRegistry.hashClass(referenceConstant.getClass());
        }
        return 37 * hash + this.classNames.hashCode();
    }

    private static int hashClass(Class<?> clazz) {
        String name;
        int indexOfLambda;
        if (LambdaCodec.isProbablyLambda(clazz) && (indexOfLambda = (name = clazz.getName()).lastIndexOf("$$Lambda$")) > -1) {
            return name.substring(0, indexOfLambda + 9).hashCode();
        }
        return clazz.getName().hashCode();
    }

    public static class Builder {
        private final Map<Class<?>, ObjectCodec<?>> codecs = new HashMap();
        private final ImmutableList.Builder<Object> referenceConstantsBuilder = ImmutableList.builder();
        private final ImmutableSortedSet.Builder<String> classNames = ImmutableSortedSet.naturalOrder();
        private final ImmutableList.Builder<String> blacklistedClassNamePrefixes = ImmutableList.builder();
        private boolean allowDefaultCodec = true;

        public Builder add(ObjectCodec<?> codec) {
            this.codecs.put(codec.getEncodedClass(), codec);
            return this;
        }

        public Builder setAllowDefaultCodec(boolean allowDefaultCodec) {
            this.allowDefaultCodec = allowDefaultCodec;
            return this;
        }

        public Builder addReferenceConstant(Object object) {
            this.referenceConstantsBuilder.add(object);
            return this;
        }

        public Builder addClassName(String className) {
            this.classNames.add((Object)className);
            return this;
        }

        public Builder blacklistClassNamePrefix(String classNamePrefix) {
            this.blacklistedClassNamePrefixes.add((Object)classNamePrefix);
            return this;
        }

        public ObjectCodecRegistry build() {
            return new ObjectCodecRegistry(ImmutableSet.copyOf(this.codecs.values()), this.referenceConstantsBuilder.build(), this.classNames.build(), this.blacklistedClassNamePrefixes.build(), this.allowDefaultCodec);
        }
    }

    private static class TypedCodecDescriptor<T>
    implements CodecDescriptor {
        private final int tag;
        private final ObjectCodec<T> codec;

        private TypedCodecDescriptor(int tag, ObjectCodec<T> codec) {
            this.tag = tag;
            this.codec = codec;
        }

        @Override
        public void serialize(SerializationContext context, Object obj, CodedOutputStream codedOut) throws IOException, SerializationException {
            this.codec.serialize(context, obj, codedOut);
        }

        public T deserialize(DeserializationContext context, CodedInputStream codedIn) throws IOException, SerializationException {
            return this.codec.deserialize(context, codedIn);
        }

        @Override
        public int getTag() {
            return this.tag;
        }

        public ObjectCodec<T> getCodec() {
            return this.codec;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("codec", this.codec).add("tag", this.tag).toString();
        }
    }

    static interface CodecDescriptor {
        public void serialize(SerializationContext var1, Object var2, CodedOutputStream var3) throws IOException, SerializationException;

        public Object deserialize(DeserializationContext var1, CodedInputStream var2) throws IOException, SerializationException;

        public int getTag();

        public ObjectCodec<?> getCodec();
    }
}

