/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.CompileTimeConstantExpressionMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import java.util.Iterator;

@BugPattern(name="CompileTimeConstant", summary="Non-compile-time constant expression passed to parameter with @CompileTimeConstant type annotation.", linkType=BugPattern.LinkType.NONE, severity=BugPattern.SeverityLevel.ERROR, disableable=false, suppressionAnnotations={})
public class CompileTimeConstantChecker
extends BugChecker
implements BugChecker.LambdaExpressionTreeMatcher,
BugChecker.MemberReferenceTreeMatcher,
BugChecker.MethodInvocationTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final String DID_YOU_MEAN_FINAL_FMT_MESSAGE = " Did you mean to make '%s' final?";
    private final Matcher<ExpressionTree> compileTimeConstExpressionMatcher = new CompileTimeConstantExpressionMatcher();

    private Description matchArguments(VisitorState state, Symbol.MethodSymbol calleeSymbol, Iterator<? extends ExpressionTree> actualParams) {
        Symbol lastFormalParam = null;
        for (Symbol.VarSymbol formalParam : calleeSymbol.getParameters()) {
            lastFormalParam = formalParam;
            if (!actualParams.hasNext()) {
                return Description.NO_MATCH;
            }
            ExpressionTree actualParam = actualParams.next();
            if (!CompileTimeConstantExpressionMatcher.hasCompileTimeConstantAnnotation((VisitorState)state, (Symbol)formalParam) || this.compileTimeConstExpressionMatcher.matches((Tree)actualParam, state)) continue;
            return this.handleMatch(actualParam, state);
        }
        if (lastFormalParam == null || (lastFormalParam.flags() & 0x400000000L) == 0L) {
            return Description.NO_MATCH;
        }
        if (!CompileTimeConstantExpressionMatcher.hasCompileTimeConstantAnnotation((VisitorState)state, (Symbol)lastFormalParam)) {
            return Description.NO_MATCH;
        }
        while (actualParams.hasNext()) {
            ExpressionTree actualParam = actualParams.next();
            if (this.compileTimeConstExpressionMatcher.matches((Tree)actualParam, state)) continue;
            return this.handleMatch(actualParam, state);
        }
        return Description.NO_MATCH;
    }

    private Description handleMatch(ExpressionTree actualParam, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol((Tree)actualParam);
        if (!(sym instanceof Symbol.VarSymbol)) {
            return this.describeMatch(actualParam);
        }
        Symbol.VarSymbol var = (Symbol.VarSymbol)sym;
        if (!CompileTimeConstantExpressionMatcher.hasCompileTimeConstantAnnotation((VisitorState)state, (Symbol)var)) {
            return this.describeMatch(actualParam);
        }
        return this.buildDescription(actualParam).setMessage(this.message() + String.format(DID_YOU_MEAN_FINAL_FMT_MESSAGE, var.getSimpleName())).build();
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((NewClassTree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        return this.matchArguments(state, sym, tree.getArguments().iterator());
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        return this.matchArguments(state, sym, tree.getArguments().iterator());
    }

    public Description matchMethod(MethodTree node, VisitorState state) {
        Symbol.MethodSymbol method = ASTHelpers.getSymbol((MethodTree)node);
        if (method == null) {
            return Description.NO_MATCH;
        }
        ArrayList<Integer> compileTimeConstantAnnotationIndexes = new ArrayList<Integer>();
        for (int i = 0; i < ((List)method.getParameters()).size(); ++i) {
            if (!CompileTimeConstantExpressionMatcher.hasCompileTimeConstantAnnotation((VisitorState)state, (Symbol)((Symbol)((List)method.getParameters()).get(i)))) continue;
            compileTimeConstantAnnotationIndexes.add(i);
        }
        if (compileTimeConstantAnnotationIndexes.isEmpty()) {
            return Description.NO_MATCH;
        }
        for (Symbol.MethodSymbol superMethod : ASTHelpers.findSuperMethods((Symbol.MethodSymbol)method, (Types)state.getTypes())) {
            for (Integer index : compileTimeConstantAnnotationIndexes) {
                if (CompileTimeConstantExpressionMatcher.hasCompileTimeConstantAnnotation((VisitorState)state, (Symbol)((Symbol)((List)superMethod.getParameters()).get(index)))) continue;
                return this.buildDescription(node).setMessage("Method with @CompileTimeConstant parameter can't override method without it.").build();
            }
        }
        return Description.NO_MATCH;
    }

    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MemberReferenceTree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        for (Symbol.VarSymbol formalParam : sym.getParameters()) {
            if (!CompileTimeConstantExpressionMatcher.hasCompileTimeConstantAnnotation((VisitorState)state, (Symbol)formalParam)) continue;
            return this.buildDescription(tree).setMessage("References to methods with @CompileTimeConstant parameters are not supported.").build();
        }
        return Description.NO_MATCH;
    }

    public Description matchLambdaExpression(LambdaExpressionTree tree, VisitorState state) {
        for (VariableTree variableTree : tree.getParameters()) {
            if (!CompileTimeConstantExpressionMatcher.hasCompileTimeConstantAnnotation((VisitorState)state, (Symbol)ASTHelpers.getSymbol((VariableTree)variableTree))) continue;
            return this.buildDescription(tree).setMessage("Lambda expressions with @CompileTimeConstant parameters are not supported.").build();
        }
        return Description.NO_MATCH;
    }
}

