/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import javax.lang.model.element.Modifier;

@BugPattern(name="JavaLangClash", summary="Never reuse class names from java.lang", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"})
public class JavaLangClash
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.TypeParameterTreeMatcher {
    public Description matchClass(ClassTree tree, VisitorState state) {
        Name simpleName = ((JCTree.JCClassDecl)tree).getSimpleName();
        return this.check(tree, simpleName, state);
    }

    public Description matchTypeParameter(TypeParameterTree tree, VisitorState state) {
        return this.check(tree, ((JCTree.JCTypeParameter)tree).getName(), state);
    }

    private Description check(Tree tree, Name simpleName, VisitorState state) {
        Symtab symtab = state.getSymtab();
        Symbol.PackageSymbol javaLang = symtab.enterPackage(symtab.java_base, Names.instance((Context)state.context).java_lang);
        Symbol other = (Symbol)Iterables.getFirst((Iterable)javaLang.members().getSymbolsByName(simpleName, s -> s.getModifiers().contains((Object)Modifier.PUBLIC)), null);
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        if (other == null || other.equals(symbol)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(String.format("%s clashes with %s\n", symbol, other)).build();
    }
}

