/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.RequiredModifiers;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import java.util.Set;

@BugPattern(name="RequiredModifiers", summary="This annotation is missing required modifiers as specified by its @RequiredModifiers annotation", linkType=BugPattern.LinkType.NONE, severity=BugPattern.SeverityLevel.WARNING, tags={"LikelyError"})
public class RequiredModifiersChecker
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final String MESSAGE_TEMPLATE = "%s has specified that it must be used together with the following modifiers: %s";

    public Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        RequiredModifiers annotation = (RequiredModifiers)ASTHelpers.getAnnotation((Tree)tree, RequiredModifiers.class);
        if (annotation == null) {
            return Description.NO_MATCH;
        }
        ImmutableSet requiredModifiers = ImmutableSet.copyOf((Object[])annotation.value());
        if (requiredModifiers.isEmpty()) {
            return Description.NO_MATCH;
        }
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (!(parent instanceof ModifiersTree)) {
            return Description.NO_MATCH;
        }
        Sets.SetView missing = Sets.difference((Set)requiredModifiers, ((ModifiersTree)parent).getFlags());
        if (missing.isEmpty()) {
            return Description.NO_MATCH;
        }
        String annotationName = ASTHelpers.getAnnotationName((AnnotationTree)tree);
        String nameString = annotationName != null ? String.format("The annotation '@%s'", annotationName) : "This annotation";
        String customMessage = String.format(MESSAGE_TEMPLATE, nameString, missing);
        return this.buildDescription(tree).setMessage(customMessage).build();
    }
}

