/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.Reachability;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;

@BugPattern(name="SwitchDefault", summary="The default case of a switch should appear at the end of the last statement group", severity=BugPattern.SeverityLevel.SUGGESTION, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class SwitchDefault
extends BugChecker
implements BugChecker.SwitchTreeMatcher {
    public Description matchSwitch(SwitchTree tree, VisitorState state) {
        Optional<CaseTree> maybeDefault = tree.getCases().stream().filter(c -> c.getExpression() == null).findAny();
        if (!maybeDefault.isPresent()) {
            return Description.NO_MATCH;
        }
        ArrayList<CaseTree> defaultStatementGroup = new ArrayList<CaseTree>();
        Iterator<? extends CaseTree> it = tree.getCases().iterator();
        while (it.hasNext()) {
            CaseTree caseTree = it.next();
            defaultStatementGroup.add(caseTree);
            if (caseTree.getExpression() == null) {
                while (it.hasNext() && caseTree.getStatements().isEmpty()) {
                    caseTree = it.next();
                    defaultStatementGroup.add(caseTree);
                }
                break;
            }
            if (caseTree.getStatements().isEmpty()) continue;
            defaultStatementGroup.clear();
        }
        int idx = defaultStatementGroup.indexOf(maybeDefault.get());
        SuggestedFix.Builder fix = SuggestedFix.builder();
        CaseTree defaultTree = (CaseTree)defaultStatementGroup.get(idx);
        if (it.hasNext()) {
            if (!Reachability.canCompleteNormally((CaseTree)((CaseTree)Iterables.getLast(defaultStatementGroup)))) {
                String replacement;
                int start = ((JCTree)defaultStatementGroup.get(0)).getStartPosition();
                int end = state.getEndPosition((Tree)Iterables.getLast(defaultStatementGroup));
                String source = state.getSourceCode().toString();
                if (idx != defaultStatementGroup.size() - 1) {
                    int caseEnd = ((JCTree)((Object)((CaseTree)Iterables.getLast(defaultStatementGroup)).getStatements().get(0))).getStartPosition();
                    int cutStart = ((JCTree)((Object)defaultTree)).getStartPosition();
                    int cutEnd = state.getEndPosition((Tree)defaultTree);
                    replacement = source.substring(start, cutStart) + source.substring(cutEnd, caseEnd) + "\n" + source.substring(cutStart, cutEnd) + source.substring(caseEnd, end);
                } else {
                    replacement = source.substring(start, end);
                }
                CaseTree last = (CaseTree)Iterables.getLast(tree.getCases());
                if (last.getExpression() == null || Reachability.canCompleteNormally((CaseTree)last)) {
                    replacement = "break;\n" + replacement;
                }
                fix.replace(start, end, "").postfixWith((Tree)Iterables.getLast(tree.getCases()), replacement);
            }
        } else if (idx != defaultStatementGroup.size() - 1) {
            fix.delete((Tree)defaultTree);
            CaseTree lastCase = (CaseTree)Iterables.getLast(defaultStatementGroup);
            if (!lastCase.getStatements().isEmpty()) {
                fix.prefixWith((Tree)lastCase.getStatements().get(0), state.getSourceForNode((Tree)defaultTree));
            } else {
                fix.postfixWith((Tree)lastCase, state.getSourceForNode((Tree)defaultTree));
            }
        } else {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription((Tree)defaultStatementGroup.get(0));
        if (!fix.isEmpty()) {
            description.addFix((Fix)fix.build());
        }
        return description.build();
    }
}

