/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization.strings;

import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.skyframe.serialization.CodecRegisterer;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.UnsafeJdk9StringCodec;
import com.google.devtools.build.lib.skyframe.serialization.strings.StringCodec;

public final class StringCodecs {
    private static final StringCodec stringCodec = new StringCodec();
    private static final UnsafeJdk9StringCodec unsafeCodec = UnsafeJdk9StringCodec.canUseUnsafeCodec() ? new UnsafeJdk9StringCodec() : null;

    public static ObjectCodec<String> asciiOptimized() {
        return unsafeCodec != null ? unsafeCodec : stringCodec;
    }

    public static ObjectCodec<String> simple() {
        return stringCodec;
    }

    static class SimpleStringCodecRegisterer
    implements CodecRegisterer<StringCodec> {
        SimpleStringCodecRegisterer() {
        }

        @Override
        public Iterable<StringCodec> getCodecsToRegister() {
            return UnsafeJdk9StringCodec.canUseUnsafeCodec() ? ImmutableList.of() : ImmutableList.of((Object)stringCodec);
        }
    }

    static class UnsafeStringCodecRegisterer
    implements CodecRegisterer<UnsafeJdk9StringCodec> {
        UnsafeStringCodecRegisterer() {
        }

        @Override
        public Iterable<? extends ObjectCodec<?>> getCodecsToRegister() {
            return UnsafeJdk9StringCodec.canUseUnsafeCodec() ? ImmutableList.of((Object)unsafeCodec) : ImmutableList.of();
        }
    }
}

