/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.bugpatterns.AbstractJUnit4InitMethodNotRun;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodTree;
import java.util.Arrays;
import java.util.List;

@BugPattern(name="JUnit4TearDownNotRun", summary="tearDown() method will not be run; please add JUnit's @After annotation", category=BugPattern.Category.JUNIT, severity=BugPattern.SeverityLevel.ERROR)
public class JUnit4TearDownNotRun
extends AbstractJUnit4InitMethodNotRun {
    @Override
    protected Matcher<MethodTree> methodMatcher() {
        return Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{JUnitMatchers.looksLikeJUnit3TearDown, JUnitMatchers.looksLikeJUnit4After}), Matchers.not((Matcher)JUnitMatchers.hasJUnit4AfterAnnotations)});
    }

    @Override
    protected String correctAnnotation() {
        return "org.junit.After";
    }

    @Override
    protected List<AbstractJUnit4InitMethodNotRun.AnnotationReplacements> annotationReplacements() {
        return Arrays.asList(new AbstractJUnit4InitMethodNotRun.AnnotationReplacements("org.junit.Before", "org.junit.After"), new AbstractJUnit4InitMethodNotRun.AnnotationReplacements("org.junit.BeforeClass", "org.junit.AfterClass"));
    }
}

