/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;

class ArrayCodec
implements ObjectCodec<Object[]> {
    ArrayCodec() {
    }

    @Override
    public Class<Object[]> getEncodedClass() {
        return Object[].class;
    }

    @Override
    public void serialize(SerializationContext context, Object[] obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        codedOut.writeInt32NoTag(obj.length);
        try {
            for (Object item : obj) {
                context.serialize(item, codedOut);
            }
        }
        catch (StackOverflowError e) {
            throw new SerializationException("StackOverflow serializing array", e);
        }
    }

    @Override
    public Object[] deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        Object[] result = new Object[codedIn.readInt32()];
        try {
            for (int i = 0; i < result.length; ++i) {
                result[i] = context.deserialize(codedIn);
            }
        }
        catch (StackOverflowError e) {
            throw new SerializationException("StackOverflow deserializing array", e);
        }
        return result;
    }
}

