/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;

public class Log {
    private static Log stdOutErr = new Log(new PrintWriter(System.out), new PrintWriter(System.err));
    private static ThreadLocal<Log> loggers = new ThreadLocal();
    protected PrintWriter err;
    protected PrintWriter out;
    protected Level level = Level.INFO;

    public Log(Writer out, Writer err) {
        this.out = out == null ? null : new PrintWriter(out, true);
        this.err = err == null ? null : new PrintWriter(err, true);
    }

    public static void setLogForCurrentThread(Log log) {
        loggers.set(log);
    }

    public static void setLogLevel(String l) {
        Log.setLogLevel(Level.valueOf(l.toUpperCase(Locale.US)));
    }

    public static void setLogLevel(Level l) {
        Log.get().level = l;
    }

    public static void trace(String msg) {
        Log.log(Level.TRACE, msg);
    }

    public static void debug(String msg) {
        Log.log(Level.DEBUG, msg);
    }

    public static void info(String msg) {
        Log.log(Level.INFO, msg);
    }

    public static void warn(String msg) {
        Log.log(Level.WARN, msg);
    }

    public static void error(String msg) {
        Log.log(Level.ERROR, msg);
    }

    public static void error(Throwable t) {
        Log.log(Level.ERROR, t);
    }

    public static void log(Level l, String msg) {
        Log.get().printLogMsg(l, msg);
    }

    public static void debug(Throwable t) {
        Log.log(Level.DEBUG, t);
    }

    public static void log(Level l, Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter((Writer)sw, true));
        Log.log(l, sw.toString());
    }

    public static boolean isDebugging() {
        return Log.get().isLevelLogged(Level.DEBUG);
    }

    protected boolean isLevelLogged(Level l) {
        return l.ordinal() <= this.level.ordinal();
    }

    public static Log get() {
        Log log = loggers.get();
        return log != null ? log : stdOutErr;
    }

    protected void printLogMsg(Level msgLevel, String msg) {
        if (this.isLevelLogged(msgLevel)) {
            PrintWriter pw = msgLevel.ordinal() <= Level.WARN.ordinal() ? this.err : this.out;
            pw.println(msg);
        }
    }

    public static enum Level {
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

