/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.io.InputStream;
import java.util.List;
import javax.lang.model.element.ElementKind;

@BugPattern(name="InputStreamSlowMultibyteRead", summary="Please also override int read(byte[], int, int), otherwise multi-byte reads from this input stream are likely to be slow.", severity=BugPattern.SeverityLevel.WARNING, tags={"Performance"})
public class InputStreamSlowMultibyteRead
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<ClassTree> IS_INPUT_STREAM = Matchers.isSubtypeOf(InputStream.class);
    private static final Matcher<MethodTree> READ_INT_METHOD = Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsNamed((String)"read"), Matchers.methodReturns((Supplier)Suppliers.INT_TYPE), Matchers.methodHasArity((int)0)});

    public Description matchClass(ClassTree classTree, VisitorState state) {
        if (!IS_INPUT_STREAM.matches((Tree)classTree, state)) {
            return Description.NO_MATCH;
        }
        Symbol.ClassSymbol thisClassSymbol = ASTHelpers.getSymbol((ClassTree)classTree);
        if (((Symbol)thisClassSymbol).getKind() != ElementKind.CLASS) {
            return Description.NO_MATCH;
        }
        MethodTree readByteMethod = classTree.getMembers().stream().filter(MethodTree.class::isInstance).map(MethodTree.class::cast).filter(m -> READ_INT_METHOD.matches((Tree)m, state)).findFirst().orElse(null);
        if (readByteMethod == null) {
            return Description.NO_MATCH;
        }
        Type byteArrayType = state.arrayTypeForType((Type)state.getSymtab().byteType);
        Type.JCPrimitiveType intType = state.getSymtab().intType;
        Symbol.MethodSymbol multiByteReadMethod = ASTHelpers.resolveExistingMethod((VisitorState)state, (Symbol.TypeSymbol)thisClassSymbol, (Name)state.getName("read"), (Iterable)ImmutableList.of((Object)byteArrayType, (Object)intType, (Object)intType), (Iterable)ImmutableList.of());
        return multiByteReadMethod.owner.equals(thisClassSymbol) ? Description.NO_MATCH : this.maybeMatchReadByte(readByteMethod, state);
    }

    private Description maybeMatchReadByte(MethodTree readByteMethod, VisitorState state) {
        Tree tree;
        List<? extends StatementTree> statements;
        if (readByteMethod.getBody() != null && (statements = readByteMethod.getBody().getStatements()).size() == 1 && (tree = (Tree)statements.get(0)).getKind() == Tree.Kind.RETURN && ASTHelpers.constValue((Tree)((ReturnTree)tree).getExpression()) != null) {
            return Description.NO_MATCH;
        }
        TreePath enclosingPath = ASTHelpers.findPathFromEnclosingNodeToTopLevel((TreePath)state.getPath(), ClassTree.class);
        while (enclosingPath != null) {
            ClassTree klazz = (ClassTree)enclosingPath.getLeaf();
            if (JUnitMatchers.isTestCaseDescendant.matches((Tree)klazz, state) || Matchers.hasAnnotation((String)"org.junit.runner.RunWith").matches((Tree)klazz, state)) {
                return Description.NO_MATCH;
            }
            enclosingPath = ASTHelpers.findPathFromEnclosingNodeToTopLevel((TreePath)enclosingPath, ClassTree.class);
        }
        return this.describeMatch(readByteMethod);
    }
}

