/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.regex.Pattern;
import javax.lang.model.element.Modifier;

@BugPattern(name="ReturnValueIgnored", altNames={"ResultOfMethodCallIgnored", "CheckReturnValue"}, summary="Return value of this method must be used", severity=BugPattern.SeverityLevel.ERROR)
public class ReturnValueIgnored
extends AbstractReturnValueIgnored {
    private static final ImmutableSet<String> TYPES_TO_CHECK = ImmutableSet.of((Object)"java.lang.String", (Object)"java.math.BigInteger", (Object)"java.math.BigDecimal", (Object)"java.nio.file.Path");
    private static final Matcher<ExpressionTree> RETURNS_SAME_TYPE = Matchers.allOf((Matcher[])new Matcher[]{(Matcher & Serializable)(t, s) -> TYPES_TO_CHECK.contains((Object)ASTHelpers.getReceiverType((ExpressionTree)t).toString()), (Matcher & Serializable)(t, s) -> ASTHelpers.isSameType((Type)ASTHelpers.getReceiverType((ExpressionTree)t), (Type)ASTHelpers.getReturnType((ExpressionTree)t), (VisitorState)s)});
    private static final Matcher<ExpressionTree> ALLOWED_JAVA_TIME_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().anyClass().named("parse"), MethodMatchers.instanceMethod().anyClass().named("parse"), MethodMatchers.staticMethod().anyClass().named("of"), MethodMatchers.staticMethod().anyClass().named("from"), MethodMatchers.staticMethod().onClass("java.time.ZoneId").named("ofOffset"), MethodMatchers.instanceMethod().onExactClass("java.time.format.DateTimeFormatterBuilder").withNameMatching(Pattern.compile("^(append|parse|pad|optional).*")), MethodMatchers.instanceMethod().onExactClass("java.time.temporal.ChronoField").named("checkValidIntValue"), MethodMatchers.instanceMethod().onExactClass("java.time.temporal.ChronoField").named("checkValidValue"), MethodMatchers.instanceMethod().onExactClass("java.time.temporal.ValueRange").named("checkValidValue")});
    private static final Matcher<ExpressionTree> STREAM_METHOD = MethodMatchers.instanceMethod().onDescendantOf("java.util.stream.BaseStream");
    private static final Matcher<ExpressionTree> ARRAYS_METHODS = MethodMatchers.staticMethod().onClass("java.util.Arrays");
    private static final Matcher<? super ExpressionTree> SPECIALIZED_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{RETURNS_SAME_TYPE, ReturnValueIgnored::functionalMethod, STREAM_METHOD, ARRAYS_METHODS, ReturnValueIgnored::javaTimeTypes, MethodMatchers.instanceMethod().onDescendantOf("java.util.Collection").named("contains").withParameters(new String[]{"java.lang.Object"}), MethodMatchers.instanceMethod().onDescendantOf("java.util.Collection").named("containsAll").withParameters(new String[]{"java.util.Collection"}), MethodMatchers.instanceMethod().onDescendantOf("java.util.Map").namedAnyOf(new String[]{"containsKey", "containsValue"}).withParameters(new String[]{"java.lang.Object"})});

    private static boolean javaTimeTypes(ExpressionTree tree, VisitorState state) {
        if (Matchers.packageStartsWith((String)"java.time").matches((Tree)tree, state)) {
            return false;
        }
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        if (symbol instanceof Symbol.MethodSymbol) {
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
            if (methodSymbol.owner.packge().getQualifiedName().toString().startsWith("java.time") && methodSymbol.getModifiers().contains((Object)Modifier.PUBLIC)) {
                return !ALLOWED_JAVA_TIME_METHODS.matches((Tree)tree, state);
            }
        }
        return false;
    }

    private static boolean functionalMethod(ExpressionTree tree, VisitorState state) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        return symbol instanceof Symbol.MethodSymbol && ((Symbol.MethodSymbol)symbol).owner.packge().getQualifiedName().contentEquals("java.util.function");
    }

    @Override
    public Matcher<? super ExpressionTree> specializedMatcher() {
        return SPECIALIZED_MATCHER;
    }
}

