/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

final class ImmutableSetRuntimeCodec
implements ObjectCodec<Set> {
    private static final Class<Set> LINKED_HASH_MULTIMAP_CLASS = LinkedHashMultimap.create((Multimap)ImmutableMultimap.of((Object)"a", (Object)"b")).get((Object)"a").getClass();
    private static final Class<Set> SINGLETON_SET_CLASS = Collections.singleton("a").getClass();
    private static final Class<Set> SUBSET_CLASS = ((Set)Iterables.getOnlyElement((Iterable)Sets.powerSet((Set)ImmutableSet.of()))).getClass();
    private static final Class<Set> EMPTY_SET_CLASS = Collections.emptySet().getClass();

    ImmutableSetRuntimeCodec() {
    }

    @Override
    public Class<ImmutableSet> getEncodedClass() {
        return ImmutableSet.class;
    }

    @Override
    public ImmutableList<Class<? extends Set>> additionalEncodedClasses() {
        return ImmutableList.of(LINKED_HASH_MULTIMAP_CLASS, SINGLETON_SET_CLASS, EMPTY_SET_CLASS, SUBSET_CLASS);
    }

    @Override
    public void serialize(SerializationContext context, Set object, CodedOutputStream codedOut) throws SerializationException, IOException {
        codedOut.writeInt32NoTag(object.size());
        for (Object obj : object) {
            context.serialize(obj, codedOut);
        }
    }

    @Override
    public ImmutableSet deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        int size = codedIn.readInt32();
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            Object item = context.deserialize(codedIn);
            builder.add(item);
        }
        return builder.build();
    }
}

