/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.time.DurationToLongTimeUnit;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.lang.model.type.TypeMirror;

@BugPattern(name="PreferJavaTimeOverload", altNames={"PreferDurationOverload"}, summary="Prefer using java.time-based APIs when available. Note that this checker does not and cannot guarantee that the overloads have equivalent semantics, but that is generally the case with overloaded methods.", severity=BugPattern.SeverityLevel.WARNING)
public final class PreferJavaTimeOverload
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String JAVA_DURATION = "java.time.Duration";
    private static final String JODA_DURATION = "org.joda.time.Duration";
    private static final ImmutableMap<Matcher<ExpressionTree>, TimeUnit> JODA_DURATION_FACTORY_MATCHERS = new ImmutableMap.Builder().put((Object)Matchers.constructor().forClass("org.joda.time.Duration").withParameters(new String[]{"long"}), (Object)TimeUnit.MILLISECONDS).put((Object)MethodMatchers.staticMethod().onClass("org.joda.time.Duration").named("millis"), (Object)TimeUnit.MILLISECONDS).put((Object)MethodMatchers.staticMethod().onClass("org.joda.time.Duration").named("standardSeconds"), (Object)TimeUnit.SECONDS).put((Object)MethodMatchers.staticMethod().onClass("org.joda.time.Duration").named("standardMinutes"), (Object)TimeUnit.MINUTES).put((Object)MethodMatchers.staticMethod().onClass("org.joda.time.Duration").named("standardHours"), (Object)TimeUnit.HOURS).put((Object)MethodMatchers.staticMethod().onClass("org.joda.time.Duration").named("standardDays"), (Object)TimeUnit.DAYS).build();
    private static final ImmutableMap<TimeUnit, String> TIMEUNIT_TO_DURATION_FACTORY = new ImmutableMap.Builder().put((Object)TimeUnit.NANOSECONDS, (Object)"%s.ofNanos(%s)").put((Object)TimeUnit.MICROSECONDS, (Object)"%s.of(%s, %s)").put((Object)TimeUnit.MILLISECONDS, (Object)"%s.ofMillis(%s)").put((Object)TimeUnit.SECONDS, (Object)"%s.ofSeconds(%s)").put((Object)TimeUnit.MINUTES, (Object)"%s.ofMinutes(%s)").put((Object)TimeUnit.HOURS, (Object)"%s.ofHours(%s)").put((Object)TimeUnit.DAYS, (Object)"%s.ofDays(%s)").build();
    private static final String JAVA_INSTANT = "java.time.Instant";
    private static final String JODA_INSTANT = "org.joda.time.Instant";
    private static final Matcher<ExpressionTree> JODA_INSTANT_CONSTRUCTOR_MATCHER = Matchers.constructor().forClass("org.joda.time.Instant").withParameters(new String[]{"long"});
    private static final String JAVA_TIME_CONVERSIONS = "com.google.thirdparty.jodatime.JavaTimeConversions";
    private static final Matcher<ExpressionTree> TO_JODA_DURATION = MethodMatchers.staticMethod().onClass("com.google.thirdparty.jodatime.JavaTimeConversions").named("toJodaDuration");
    private static final Matcher<ExpressionTree> TO_JODA_INSTANT = MethodMatchers.staticMethod().onClass("com.google.thirdparty.jodatime.JavaTimeConversions").named("toJodaInstant");
    private static final Matcher<ExpressionTree> IGNORED_APIS = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("org.jooq.impl.DSL").named("inline"), MethodMatchers.staticMethod().onClass((TypePredicate & Serializable)(type, state) -> type.toString().startsWith("org.assertj.")).withAnyName()});
    private static final Matcher<ExpressionTree> JAVA_DURATION_DECOMPOSITION_MATCHER = MethodMatchers.instanceMethod().onExactClass("java.time.Duration").namedAnyOf(new String[]{"toNanos", "toMillis", "getSeconds", "toMinutes", "toHours", "toDays"});
    private final boolean hasJava8LibSupport;

    public PreferJavaTimeOverload(ErrorProneFlags flags) {
        this.hasJava8LibSupport = flags.getBoolean("Android:Java8Libs").orElse(false);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        SuggestedFix.Builder fix;
        ExpressionTree arg0;
        String durationFactory;
        Optional<TimeUnit> optionalTimeUnit;
        if (state.isAndroidCompatible() && !this.hasJava8LibSupport) {
            return Description.NO_MATCH;
        }
        if (IGNORED_APIS.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        java.util.List<? extends ExpressionTree> arguments = tree.getArguments();
        if (PreferJavaTimeOverload.isNumericMethodCall(tree, state)) {
            if (PreferJavaTimeOverload.hasJavaTimeOverload(tree, state, JAVA_DURATION)) {
                return this.buildDescriptionForNumericPrimitive(tree, state, arguments, "Duration");
            }
            if (PreferJavaTimeOverload.hasJavaTimeOverload(tree, state, JAVA_INSTANT)) {
                return this.buildDescriptionForNumericPrimitive(tree, state, arguments, "Instant");
            }
        }
        if (PreferJavaTimeOverload.isLongTimeUnitMethodCall(tree, state) && (optionalTimeUnit = DurationToLongTimeUnit.getTimeUnit(arguments.get(1))).isPresent() && PreferJavaTimeOverload.hasJavaTimeOverload(tree, state, JAVA_DURATION) && (durationFactory = (String)TIMEUNIT_TO_DURATION_FACTORY.get((Object)optionalTimeUnit.get())) != null) {
            MethodInvocationTree maybeDurationDecomposition;
            SuggestedFix.Builder fix2 = SuggestedFix.builder();
            String qualifiedDuration = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix2, (String)JAVA_DURATION);
            String value = state.getSourceForNode((Tree)arguments.get(0));
            String replacement = null;
            if (arguments.get(0) instanceof MethodInvocationTree && JAVA_DURATION_DECOMPOSITION_MATCHER.matches((Tree)(maybeDurationDecomposition = (MethodInvocationTree)arguments.get(0)), state) && ASTHelpers.isSameType((Type)ASTHelpers.getReceiverType((ExpressionTree)maybeDurationDecomposition), (Type)state.getTypeFromString(JAVA_DURATION), (VisitorState)state)) {
                replacement = state.getSourceForNode((Tree)ASTHelpers.getReceiver((ExpressionTree)maybeDurationDecomposition));
            }
            if (optionalTimeUnit.get() == TimeUnit.MICROSECONDS) {
                String qualifiedChronoUnit = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix2, (String)"java.time.temporal.ChronoUnit");
                replacement = String.format(durationFactory, qualifiedDuration, value, qualifiedChronoUnit + ".MICROS");
            }
            if (replacement == null) {
                replacement = String.format(durationFactory, qualifiedDuration, value);
            }
            fix2.replace(((JCTree)((Object)arguments.get(0))).getStartPosition(), state.getEndPosition((Tree)arguments.get(1)), replacement);
            return this.describeMatch(tree, (Fix)fix2.build());
        }
        if (PreferJavaTimeOverload.isMethodCallWithSingleParameter(tree, state, "org.joda.time.ReadableDuration")) {
            arg0 = arguments.get(0);
            if (PreferJavaTimeOverload.hasJavaTimeOverload(tree, state, JAVA_DURATION)) {
                fix = SuggestedFix.builder();
                String qualifiedDuration = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)JAVA_DURATION);
                for (Map.Entry entry : JODA_DURATION_FACTORY_MATCHERS.entrySet()) {
                    String durationFactory2;
                    ExpressionTree jodaDurationCreation;
                    if (!((Matcher)entry.getKey()).matches((Tree)arg0, state)) continue;
                    String value = null;
                    if (arg0 instanceof MethodInvocationTree) {
                        jodaDurationCreation = (MethodInvocationTree)arg0;
                        value = state.getSourceForNode((Tree)jodaDurationCreation.getArguments().get(0));
                    }
                    if (arg0 instanceof NewClassTree) {
                        jodaDurationCreation = (NewClassTree)arg0;
                        value = state.getSourceForNode((Tree)jodaDurationCreation.getArguments().get(0));
                    }
                    if (value == null || (durationFactory2 = (String)TIMEUNIT_TO_DURATION_FACTORY.get(entry.getValue())) == null) continue;
                    String replacement = String.format(durationFactory2, qualifiedDuration, value);
                    fix.replace((Tree)arg0, replacement);
                    return this.describeMatch(tree, (Fix)fix.build());
                }
                if (TO_JODA_DURATION.matches((Tree)arg0, state)) {
                    fix.replace((Tree)arg0, state.getSourceForNode((Tree)((MethodInvocationTree)arg0).getArguments().get(0)));
                    return this.describeMatch(tree, (Fix)fix.build());
                }
                fix.replace((Tree)arg0, String.format("%s.ofMillis(%s.getMillis())", qualifiedDuration, state.getSourceForNode((Tree)arg0)));
                return this.describeMatch(tree, (Fix)fix.build());
            }
        }
        if (PreferJavaTimeOverload.isMethodCallWithSingleParameter(tree, state, "org.joda.time.ReadableInstant")) {
            arg0 = arguments.get(0);
            if (PreferJavaTimeOverload.hasJavaTimeOverload(tree, state, JAVA_INSTANT)) {
                fix = SuggestedFix.builder();
                String qualifiedInstant = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)JAVA_INSTANT);
                if (JODA_INSTANT_CONSTRUCTOR_MATCHER.matches((Tree)arg0, state) && arg0 instanceof NewClassTree) {
                    NewClassTree jodaInstantCreation = (NewClassTree)arg0;
                    String value = state.getSourceForNode((Tree)jodaInstantCreation.getArguments().get(0));
                    fix.replace((Tree)arg0, String.format("%s.ofEpochMilli(%s)", qualifiedInstant, value));
                    return this.describeMatch(tree, (Fix)fix.build());
                }
                if (TO_JODA_INSTANT.matches((Tree)arg0, state)) {
                    fix.replace((Tree)arg0, state.getSourceForNode((Tree)((MethodInvocationTree)arg0).getArguments().get(0)));
                    return this.describeMatch(tree, (Fix)fix.build());
                }
                fix.replace((Tree)arg0, String.format("%s.ofEpochMilli(%s.getMillis())", qualifiedInstant, state.getSourceForNode((Tree)arg0)));
                return this.describeMatch(tree, (Fix)fix.build());
            }
        }
        return Description.NO_MATCH;
    }

    private Description buildDescriptionForNumericPrimitive(MethodInvocationTree tree, VisitorState state, java.util.List<? extends ExpressionTree> arguments, String javaTimeType) {
        return this.buildDescription(tree).setMessage(String.format("If the numeric primitive (%s) represents a %s, please call %s(%s) instead.", state.getSourceForNode((Tree)arguments.get(0)), javaTimeType, state.getSourceForNode((Tree)tree.getMethodSelect()), javaTimeType)).build();
    }

    private static boolean isNumericMethodCall(MethodInvocationTree tree, VisitorState state) {
        java.util.List params = ASTHelpers.getSymbol((MethodInvocationTree)tree).getParameters();
        if (params.size() == 1) {
            TypeMirror type0 = ((Symbol.VarSymbol)params.get(0)).asType();
            return ASTHelpers.isSameType((Type)type0, (Type)state.getSymtab().intType, (VisitorState)state) || ASTHelpers.isSameType((Type)type0, (Type)state.getSymtab().longType, (VisitorState)state) || ASTHelpers.isSameType((Type)type0, (Type)state.getSymtab().doubleType, (VisitorState)state);
        }
        return false;
    }

    private static boolean isMethodCallWithSingleParameter(MethodInvocationTree tree, VisitorState state, String typeName) {
        Type type = state.getTypeFromString(typeName);
        java.util.List params = ASTHelpers.getSymbol((MethodInvocationTree)tree).getParameters();
        return params.size() == 1 && ASTHelpers.isSubtype((Type)((Symbol.VarSymbol)params.get(0)).asType(), (Type)type, (VisitorState)state);
    }

    private static boolean isLongTimeUnitMethodCall(MethodInvocationTree tree, VisitorState state) {
        Type.JCPrimitiveType longType = state.getSymtab().longType;
        Type timeUnitType = state.getTypeFromString("java.util.concurrent.TimeUnit");
        java.util.List params = ASTHelpers.getSymbol((MethodInvocationTree)tree).getParameters();
        if (params.size() == 2) {
            return ASTHelpers.isSameType((Type)((Symbol.VarSymbol)params.get(0)).asType(), (Type)longType, (VisitorState)state) && ASTHelpers.isSameType((Type)((Symbol.VarSymbol)params.get(1)).asType(), (Type)timeUnitType, (VisitorState)state);
        }
        return false;
    }

    private static boolean hasJavaTimeOverload(MethodInvocationTree tree, VisitorState state, String typeName) {
        Symbol.MethodSymbol calledMethod = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        if (calledMethod == null) {
            return false;
        }
        MethodTree t = (MethodTree)state.findEnclosing(new Class[]{MethodTree.class});
        Symbol.MethodSymbol enclosingMethod = t == null ? null : ASTHelpers.getSymbol((MethodTree)t);
        Type type = state.getTypeFromString(typeName);
        return PreferJavaTimeOverload.hasMatchingMethods(calledMethod.name, (Predicate<Symbol.MethodSymbol>)((Predicate)input -> !input.equals(calledMethod) && !input.equals(enclosingMethod) && (enclosingMethod == null || !enclosingMethod.overrides((Symbol)input, (Symbol.TypeSymbol)input.owner, state.getTypes(), true)) && input.isStatic() == calledMethod.isStatic() && ((List)input.getParameters()).size() == 1 && ASTHelpers.isSameType((Type)((Symbol.VarSymbol)((List)input.getParameters()).get(0)).asType(), (Type)type, (VisitorState)state) && ASTHelpers.isSameType((Type)input.getReturnType(), (Type)calledMethod.getReturnType(), (VisitorState)state)), (Type)ASTHelpers.enclosingClass((Symbol)calledMethod).asType(), state.getTypes());
    }

    private static boolean hasMatchingMethods(Name name, Predicate<Symbol.MethodSymbol> predicate, Type startClass, Types types) {
        Filter matchesMethodPredicate = sym -> sym instanceof Symbol.MethodSymbol && predicate.apply((Object)((Symbol.MethodSymbol)sym));
        for (Type superClass : types.closure(startClass)) {
            Symbol.TypeSymbol superClassSymbol = superClass.tsym;
            Scope.WriteableScope superClassSymbols = superClassSymbol.members();
            if (superClassSymbols == null || Iterables.isEmpty((Iterable)superClassSymbols.getSymbolsByName(name, matchesMethodPredicate, Scope.LookupKind.NON_RECURSIVE))) continue;
            return true;
        }
        return false;
    }
}

