/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.common.collect.Lists;
import com.google.errorprone.util.OffsetComment;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Name;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ErrorProneToken {
    private final int offset;
    private final Tokens.Token token;

    ErrorProneToken(Tokens.Token token, int offset) {
        this.token = token;
        this.offset = offset;
    }

    public Tokens.TokenKind kind() {
        return this.token.kind;
    }

    public int pos() {
        return this.offset + this.token.pos;
    }

    public int endPos() {
        return this.offset + this.token.endPos;
    }

    public List<Tokens.Comment> comments() {
        if (this.token.comments == null) {
            return Collections.emptyList();
        }
        if (this.offset == 0) {
            return Lists.reverse(this.token.comments);
        }
        return Lists.reverse(this.token.comments.stream().map(c -> new OffsetComment((Tokens.Comment)c, this.offset)).collect(Collectors.toList()));
    }

    public Name name() {
        return this.token.name();
    }

    public String stringVal() {
        return this.token.stringVal();
    }

    public int radix() {
        return this.token.radix();
    }

    public String toString() {
        return this.token.toString();
    }
}

