/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.List;
import java.util.Optional;

@BugPattern(name="ProtoTruthMixedDescriptors", summary="The arguments passed to `ignoringFields` are inconsistent with the proto which is the subject of the assertion.", severity=BugPattern.SeverityLevel.ERROR)
public final class ProtoTruthMixedDescriptors
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> IGNORING = MethodMatchers.instanceMethod().onDescendantOfAny(new String[]{"com.google.common.truth.extensions.proto.ProtoFluentAssertion", "com.google.common.truth.extensions.proto.ProtoSubject"}).named("ignoringFields");
    private static final Matcher<ExpressionTree> ASSERT_THAT = MethodMatchers.staticMethod().onClass("com.google.common.truth.extensions.proto.ProtoTruth").named("assertThat");
    private static final Supplier<Type> MESSAGE = Suppliers.typeFromString((String)"com.google.protobuf.Message");
    private static final Supplier<Type> GENERATED_MESSAGE = Suppliers.typeFromString((String)"com.google.protobuf.GeneratedMessage");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!IGNORING.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> arguments = tree.getArguments();
        ImmutableSet types = (ImmutableSet)arguments.stream().map(t -> ProtoTruthMixedDescriptors.protoType(t, state)).filter(Optional::isPresent).map(Optional::get).collect(ImmutableSet.toImmutableSet());
        if (types.size() > 1) {
            return this.describeMatch(tree);
        }
        if (types.size() != 1) {
            return Description.NO_MATCH;
        }
        Symbol.TypeSymbol type = (Symbol.TypeSymbol)Iterables.getOnlyElement((Iterable)types);
        return ASTHelpers.streamReceivers((ExpressionTree)tree).filter(t -> ASSERT_THAT.matches((Tree)t, state)).map(t -> this.validateReceiver(tree, (MethodInvocationTree)t, type, state)).findFirst().orElse(Description.NO_MATCH);
    }

    private static Optional<Symbol.TypeSymbol> protoType(ExpressionTree tree, VisitorState state) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        if (symbol != null && symbol.owner != null && ASTHelpers.isSubtype((Type)symbol.owner.type, (Type)((Type)MESSAGE.get(state)), (VisitorState)state)) {
            return Optional.of(symbol.owner.type.tsym);
        }
        return Optional.empty();
    }

    private Description validateReceiver(MethodInvocationTree tree, MethodInvocationTree receiver, Symbol.TypeSymbol type, VisitorState state) {
        if (receiver.getArguments().size() != 1) {
            return Description.NO_MATCH;
        }
        ExpressionTree argument = (ExpressionTree)Iterables.getOnlyElement(receiver.getArguments());
        Type subjectType = ASTHelpers.getType((Tree)argument);
        if (ASTHelpers.isSubtype((Type)subjectType, (Type)state.getSymtab().iterableType, (VisitorState)state)) {
            if (subjectType.getTypeArguments().isEmpty()) {
                return Description.NO_MATCH;
            }
            subjectType = (Type)Iterables.getOnlyElement(subjectType.getTypeArguments());
        }
        return subjectType == null || subjectType.tsym.equals(type) || !ASTHelpers.isSubtype((Type)subjectType, (Type)((Type)GENERATED_MESSAGE.get(state)), (VisitorState)state) ? Description.NO_MATCH : this.describeMatch(tree);
    }
}

