/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.instance;

import org.mockito.creation.instance.Instantiator;
import org.mockito.internal.creation.instance.InstantiationException;
import org.mockito.mock.MockCreationSettings;
import org.mockito.plugins.InstantiatorProvider;
import org.mockito.plugins.InstantiatorProvider2;

public class InstantiatorProviderAdapter
implements InstantiatorProvider2 {
    private final InstantiatorProvider provider;

    public InstantiatorProviderAdapter(InstantiatorProvider provider) {
        this.provider = provider;
    }

    @Override
    public Instantiator getInstantiator(final MockCreationSettings<?> settings) {
        return new Instantiator(){

            @Override
            public <T> T newInstance(Class<T> cls) {
                try {
                    return InstantiatorProviderAdapter.this.provider.getInstantiator(settings).newInstance(cls);
                }
                catch (InstantiationException e) {
                    throw new org.mockito.creation.instance.InstantiationException(e.getMessage(), e.getCause());
                }
            }
        };
    }
}

