/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.javacutil;

import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Options;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.org.plumelib.util.StringsPlume;

@Deprecated
public class PluginUtil {
    public static final String CHECKER_QUAL_PATH_OPT = "-checkerQualJar";
    public static final String JAVAC_PATH_OPT = "-javacJar";
    public static final String JDK_PATH_OPT = "-jdkJar";
    private static final String LINE_SEPARATOR = System.lineSeparator();

    public static List<File> toFiles(List<String> fileNames) {
        ArrayList<File> files = new ArrayList<File>(fileNames.size());
        for (String fn : fileNames) {
            files.add(new File(fn));
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFofn(File destination, List<File> files) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(destination));){
            for (File file : files) {
                bw.write(PluginUtil.wrapArg(file.getAbsolutePath()));
                bw.newLine();
            }
            bw.flush();
        }
    }

    public static void writeFofn(File destination, File ... files) throws IOException {
        PluginUtil.writeFofn(destination, Arrays.asList(files));
    }

    public static File writeTmpFofn(String prefix, String suffix, boolean deleteOnExit, List<File> files) throws IOException {
        File tmpFile = File.createTempFile(prefix, suffix);
        if (deleteOnExit) {
            tmpFile.deleteOnExit();
        }
        PluginUtil.writeFofn(tmpFile, files);
        return tmpFile;
    }

    public static File writeTmpFile(String prefix, String suffix, boolean deleteOnExit, List<String> args) throws IOException {
        File tmpFile = File.createTempFile(prefix, suffix);
        if (deleteOnExit) {
            tmpFile.deleteOnExit();
        }
        PluginUtil.writeFile(tmpFile, args);
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File destination, List<String> contents) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(destination));){
            for (String line : contents) {
                bw.write(line);
                bw.newLine();
            }
            bw.flush();
        }
    }

    public static List<String> readFile(File argFile) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(argFile));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            lines.add(line);
        }
        br.close();
        return lines;
    }

    public static <T> String join(CharSequence delimiter, T @Nullable [] objs) {
        if (objs == null) {
            return "null";
        }
        return StringsPlume.join(delimiter, objs);
    }

    public static String join(CharSequence delimiter, @Nullable Iterable<?> values) {
        if (values == null) {
            return "null";
        }
        return StringsPlume.join(delimiter, values);
    }

    @SafeVarargs
    public static <T> String joinLines(T ... a) {
        return PluginUtil.join((CharSequence)LINE_SEPARATOR, a);
    }

    public static String joinLines(@Nullable Iterable<? extends Object> v) {
        return PluginUtil.join((CharSequence)LINE_SEPARATOR, v);
    }

    public static List<String> getStringProp(Map<CheckerProp, Object> props, CheckerProp prop, String cmdLineArgStart, String ... extras) {
        ArrayList<String> out = new ArrayList<String>();
        String strProp = (String)props.get((Object)prop);
        if (strProp != null && !strProp.isEmpty()) {
            out.add(cmdLineArgStart + strProp);
            for (String extra : extras) {
                out.add(extra);
            }
        }
        return out;
    }

    public static List<String> getBooleanProp(Map<CheckerProp, Object> props, CheckerProp prop, String cmdLineArg) {
        Boolean aSkip = (Boolean)props.get((Object)prop);
        if (aSkip != null && aSkip.booleanValue()) {
            return Arrays.asList(cmdLineArg);
        }
        return new ArrayList<String>();
    }

    private static void addOptions(List<String> cmd, Map<CheckerProp, Object> props) {
        for (CheckerProp cp : CheckerProp.values()) {
            cmd.addAll(cp.getCmdLine(props));
        }
    }

    public static boolean getBooleanSystemProperty(String key) {
        return Boolean.valueOf(System.getProperty(key, "false"));
    }

    public static boolean getBooleanSystemProperty(String key, boolean defaultValue) {
        String value = System.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        throw new Error(String.format("Value for system property %s should be boolean, but is \"%s\".", key, value));
    }

    public static File writeTmpSrcFofn(String prefix, boolean deleteOnExit, List<File> files) throws IOException {
        return PluginUtil.writeTmpFofn(prefix, ".src_files", deleteOnExit, files);
    }

    public static File writeTmpCpFile(String prefix, boolean deleteOnExit, String classpath) throws IOException {
        return PluginUtil.writeTmpFile(prefix, ".classpath", deleteOnExit, Arrays.asList("-classpath", PluginUtil.wrapArg(classpath)));
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.toLowerCase().contains("win");
    }

    public static String wrapArg(String classpath) {
        if (classpath.contains(" ")) {
            return '\"' + PluginUtil.escapeQuotesAndSlashes(classpath) + '\"';
        }
        return classpath;
    }

    public static String escapeQuotesAndSlashes(String toEscape) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("\\\\", "\\\\\\\\");
        replacements.put("\"", "\\\\\"");
        String replacement = toEscape;
        for (Map.Entry entry : replacements.entrySet()) {
            replacement = replacement.replaceAll((String)entry.getKey(), (String)entry.getValue());
        }
        return replacement;
    }

    public static String getJavaCommand(String javaHome, PrintStream out) {
        if (javaHome == null || javaHome.equals("")) {
            return "java";
        }
        File java = new File(javaHome, "bin" + File.separator + "java");
        File javaExe = new File(javaHome, "bin" + File.separator + "java.exe");
        if (java.exists()) {
            return java.getAbsolutePath();
        }
        if (javaExe.exists()) {
            return javaExe.getAbsolutePath();
        }
        if (out != null) {
            out.printf("Could not find java executable at: (%s,%s)%n  Using \"java\" command.%n", java.getAbsolutePath(), javaExe.getAbsolutePath());
        }
        return "java";
    }

    public static String fileArgToStr(File fileArg) {
        return "@" + fileArg.getAbsolutePath();
    }

    public static List<String> getCmd(@Nullable String executable, @Nullable File javacPath, @Nullable File jdkPath, File srcFofn, String processors, String checkerHome, String javaHome, File classPathFofn, String bootClassPath, Map<CheckerProp, Object> props, PrintStream out, boolean procOnly, String outputDirectory) {
        ArrayList<String> cmd = new ArrayList<String>();
        String java = executable != null ? executable : PluginUtil.getJavaCommand(javaHome, out);
        cmd.add(java);
        cmd.add("-jar");
        cmd.add(checkerHome);
        if (procOnly) {
            cmd.add("-proc:only");
        } else if (outputDirectory != null) {
            cmd.add("-d");
            cmd.add(outputDirectory);
        }
        if (bootClassPath != null && !bootClassPath.trim().isEmpty()) {
            cmd.add("-Xbootclasspath/p:" + bootClassPath);
        }
        if (javacPath != null) {
            cmd.add(JAVAC_PATH_OPT);
            cmd.add(javacPath.getAbsolutePath());
        }
        if (jdkPath != null) {
            cmd.add(JDK_PATH_OPT);
            cmd.add(jdkPath.getAbsolutePath());
        }
        if (classPathFofn != null) {
            cmd.add(PluginUtil.fileArgToStr(classPathFofn));
        }
        if (processors != null) {
            cmd.add("-processor");
            cmd.add(processors);
        }
        PluginUtil.addOptions(cmd, props);
        cmd.add(PluginUtil.fileArgToStr(srcFofn));
        return cmd;
    }

    public static List<String> toJavaOpts(List<String> opts) {
        ArrayList<String> outOpts = new ArrayList<String>(opts.size());
        for (String opt : opts) {
            outOpts.add("-J" + opt);
        }
        return outOpts;
    }

    public static List<String> getCmdArgsOnly(File srcFofn, String processors, String checkerHome, String javaHome, File classpathFofn, String bootClassPath, Map<CheckerProp, Object> props, PrintStream out, boolean procOnly, String outputDirectory) {
        List<String> cmd = PluginUtil.getCmd(null, null, null, srcFofn, processors, checkerHome, javaHome, classpathFofn, bootClassPath, props, out, procOnly, outputDirectory);
        cmd.remove(0);
        return cmd;
    }

    public static List<String> getCmdArgsOnly(File javacPath, File jdkPath, File srcFofn, String processors, String checkerHome, String javaHome, File classpathFofn, String bootClassPath, Map<CheckerProp, Object> props, PrintStream out, boolean procOnly, String outputDirectory) {
        List<String> cmd = PluginUtil.getCmd(null, javacPath, jdkPath, srcFofn, processors, checkerHome, javaHome, classpathFofn, bootClassPath, props, out, procOnly, outputDirectory);
        cmd.remove(0);
        return cmd;
    }

    public static int getJreVersion() {
        String jreVersionStr = System.getProperty("java.version");
        Pattern oldVersionPattern = Pattern.compile("^1\\.(\\d+)\\..*$");
        Matcher oldVersionMatcher = oldVersionPattern.matcher(jreVersionStr);
        if (oldVersionMatcher.matches()) {
            String v = oldVersionMatcher.group(1);
            assert (v != null) : "@AssumeAssertion(nullness): inspection";
            return Integer.parseInt(v);
        }
        Pattern newVersionPattern = Pattern.compile("^(\\d+).*$");
        Matcher newVersionMatcher = newVersionPattern.matcher(jreVersionStr);
        if (newVersionMatcher.matches()) {
            String v = newVersionMatcher.group(1);
            assert (v != null) : "@AssumeAssertion(nullness): inspection";
            return Integer.parseInt(v);
        }
        Pattern eaVersionPattern = Pattern.compile("^(\\d+)-ea$");
        Matcher eaVersionMatcher = eaVersionPattern.matcher(jreVersionStr);
        if (eaVersionMatcher.matches()) {
            String v = eaVersionMatcher.group(1);
            assert (v != null) : "@AssumeAssertion(nullness): inspection";
            return Integer.parseInt(v);
        }
        throw new RuntimeException("Could not determine version from property java.version=" + jreVersionStr);
    }

    public static String getJdkJarPrefix() {
        int jreVersion = PluginUtil.getJreVersion();
        if (jreVersion < 8) {
            throw new AssertionError((Object)("Unsupported JRE version: " + jreVersion));
        }
        String prefix = "jdk" + jreVersion;
        return prefix;
    }

    public static String getJdkJarName() {
        String fileName = PluginUtil.getJdkJarPrefix() + ".jar";
        return fileName;
    }

    public static @Nullable String getReleaseValue(ProcessingEnvironment env) {
        Context ctx = ((JavacProcessingEnvironment)env).getContext();
        Options options = Options.instance(ctx);
        return options.get(Option.RELEASE);
    }

    public static enum CheckerProp {
        MISC_COMPILER{

            @Override
            public List<String> getCmdLine(Map<CheckerProp, Object> props) {
                List miscOpts = (List)props.get((Object)this);
                if (miscOpts != null && !miscOpts.isEmpty()) {
                    return new ArrayList<String>(miscOpts);
                }
                return new ArrayList<String>();
            }
        }
        ,
        A_SKIP{

            @Override
            public List<String> getCmdLine(Map<CheckerProp, Object> props) {
                return PluginUtil.getStringProp(props, this, "-AskipUses=", new String[0]);
            }
        }
        ,
        A_LINT{

            @Override
            public List<String> getCmdLine(Map<CheckerProp, Object> props) {
                return PluginUtil.getStringProp(props, this, "-Alint=", new String[0]);
            }
        }
        ,
        A_WARNS{

            @Override
            public List<String> getCmdLine(Map<CheckerProp, Object> props) {
                return PluginUtil.getBooleanProp(props, this, "-Awarns");
            }
        }
        ,
        A_NO_MSG_TXT{

            @Override
            public List<String> getCmdLine(Map<CheckerProp, Object> props) {
                return PluginUtil.getBooleanProp(props, this, "-Anomsgtext");
            }
        }
        ,
        A_SHOW_CHECKS{

            @Override
            public List<String> getCmdLine(Map<CheckerProp, Object> props) {
                return PluginUtil.getBooleanProp(props, this, "-Ashowchecks");
            }
        }
        ,
        A_FILENAMES{

            @Override
            public List<String> getCmdLine(Map<CheckerProp, Object> props) {
                return PluginUtil.getBooleanProp(props, this, "-Afilenames");
            }
        }
        ,
        A_DETAILED_MSG{

            @Override
            public List<String> getCmdLine(Map<CheckerProp, Object> props) {
                return PluginUtil.getBooleanProp(props, this, "-Adetailedmsgtext");
            }
        };


        public abstract List<String> getCmdLine(Map<CheckerProp, Object> var1);
    }
}

