/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_TypeCompatibilityUtils_TypeCompatibilityReport;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.lang.model.type.TypeKind;

public final class TypeCompatibilityUtils {
    private static final String WITHOUT_EQUALS_REASON = ". Though these types are the same, the type doesn't implement equals.";
    private final boolean treatBuildersAsIncomparable;
    private static final Supplier<Name> EQUALS = VisitorState.memoize((Supplier & Serializable)state -> state.getName("equals"));
    private static final Supplier<Type> COM_GOOGLE_PROTOBUF_DYNAMICMESSAGE = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("com.google.protobuf.DynamicMessage"));
    private static final Supplier<Type> COM_GOOGLE_PROTOBUF_MESSAGE = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("com.google.protobuf.Message"));
    private static final Supplier<Type> COM_GOOGLE_PROTOBUF_MESSAGELITE = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("com.google.protobuf.MessageLite"));
    private static final Supplier<Type> JAVA_UTIL_COLLECTION = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("java.util.Collection"));

    public static TypeCompatibilityUtils fromFlags(ErrorProneFlags flags) {
        return new TypeCompatibilityUtils(flags.getBoolean("TypeCompatibility:TreatBuildersAsIncomparable").orElse(true));
    }

    public static TypeCompatibilityUtils allOn() {
        return new TypeCompatibilityUtils(true);
    }

    private TypeCompatibilityUtils(boolean treatBuildersAsIncomparable) {
        this.treatBuildersAsIncomparable = treatBuildersAsIncomparable;
    }

    public TypeCompatibilityReport compatibilityOfTypes(Type receiverType, Type argumentType, VisitorState state) {
        return this.compatibilityOfTypes(receiverType, argumentType, TypeCompatibilityUtils.typeSet(state), TypeCompatibilityUtils.typeSet(state), state);
    }

    private TypeCompatibilityReport compatibilityOfTypes(Type leftType, Type rightType, Set<Type> previouslySeenComponentsOfLeftType, Set<Type> previouslySeenComponentsOfRightType, VisitorState state) {
        Type rightUpperBound;
        Type leftUpperBound;
        if (leftType == null || rightType == null || leftType.getKind() == TypeKind.NULL || rightType.getKind() == TypeKind.NULL) {
            return TypeCompatibilityReport.compatible();
        }
        Types types = state.getTypes();
        if (types.isSameType(leftUpperBound = ASTHelpers.getUpperBound((Type)leftType, (Types)types), rightUpperBound = ASTHelpers.getUpperBound((Type)rightType, (Types)types))) {
            if (this.treatBuildersAsIncomparable && !leftUpperBound.tsym.isEnum() && leftUpperBound.isFinal() && leftUpperBound.tsym.name.toString().endsWith("Builder")) {
                Names names = state.getNames();
                Symbol.MethodSymbol equals = (Symbol.MethodSymbol)state.getSymtab().objectType.tsym.members().findFirst(state.getNames().equals);
                return Iterables.isEmpty((Iterable)ASTHelpers.scope((Scope)types.membersClosure(leftUpperBound, false)).getSymbolsByName(names.toString, m -> m != equals && m.overrides(equals, leftUpperBound.tsym, types, false))) ? TypeCompatibilityReport.incompatible(leftType, rightType, WITHOUT_EQUALS_REASON) : TypeCompatibilityReport.compatible();
            }
            return TypeCompatibilityReport.compatible();
        }
        if (leftType.isPrimitive() && rightType.isPrimitive() && !ASTHelpers.isSameType((Type)leftType, (Type)rightType, (VisitorState)state)) {
            return TypeCompatibilityReport.incompatible(leftType, rightType);
        }
        if (!TypeCompatibilityUtils.isFeasiblyCompatible(leftType, rightType, state)) {
            return TypeCompatibilityReport.incompatible(leftType, rightType);
        }
        Type erasedLeftType = types.erasure(leftType);
        Type erasedRightType = types.erasure(rightType);
        Type commonSupertype = types.lub(erasedRightType, erasedLeftType);
        if (commonSupertype.getTag().equals((Object)TypeTag.BOT) || commonSupertype.getTag().equals((Object)TypeTag.ERROR)) {
            return TypeCompatibilityReport.compatible();
        }
        TypeCompatibilityReport compatibilityReport = this.checkForGenericsMismatch(leftType, rightType, commonSupertype, previouslySeenComponentsOfLeftType, previouslySeenComponentsOfRightType, state);
        if (!compatibilityReport.isCompatible()) {
            return compatibilityReport;
        }
        return TypeCompatibilityUtils.areTypesIncompatibleCollections(leftType, rightType, commonSupertype, state) || this.areIncompatibleProtoTypes(erasedLeftType, erasedRightType, commonSupertype, state) ? TypeCompatibilityReport.incompatible(leftType, rightType) : TypeCompatibilityReport.compatible();
    }

    private static boolean isFeasiblyCompatible(Type leftType, Type rightType, VisitorState state) {
        if (ASTHelpers.isCastable((Type)rightType, (Type)leftType, (VisitorState)state)) {
            return true;
        }
        Types types = state.getTypes();
        Symbol.TypeSymbol rightClass = ASTHelpers.getUpperBound((Type)rightType, (Types)state.getTypes()).tsym;
        return ASTHelpers.findMatchingMethods((Name)((Name)EQUALS.get(state)), m -> TypeCompatibilityUtils.customEqualsMethod(m, state), (Type)leftType, (Types)types).stream().anyMatch(method -> rightClass.isSubClass(method.enclClass(), types));
    }

    private static boolean customEqualsMethod(Symbol.MethodSymbol methodSymbol, VisitorState state) {
        Symbol.ClassSymbol owningClass = methodSymbol.enclClass();
        return !methodSymbol.isStatic() && (methodSymbol.flags() & 0x1000L) == 0L && state.getTypes().isSameType(methodSymbol.getReturnType(), state.getSymtab().booleanType) && ((List)methodSymbol.getParameters()).size() == 1 && state.getTypes().isSameType(((Symbol.VarSymbol)((List)methodSymbol.getParameters()).get((int)0)).type, state.getSymtab().objectType) && !owningClass.equals(state.getSymtab().objectType.tsym) && !owningClass.equals(state.getSymtab().enumSym);
    }

    private static boolean areTypesIncompatibleCollections(Type leftType, Type rightType, Type nearestCommonSupertype, VisitorState state) {
        Type collectionType = (Type)JAVA_UTIL_COLLECTION.get(state);
        return ASTHelpers.isSameType((Type)nearestCommonSupertype, (Type)collectionType, (VisitorState)state) && !ASTHelpers.isSameType((Type)leftType, (Type)collectionType, (VisitorState)state) && !ASTHelpers.isSameType((Type)rightType, (Type)collectionType, (VisitorState)state);
    }

    private boolean areIncompatibleProtoTypes(Type leftType, Type rightType, Type nearestCommonSupertype, VisitorState state) {
        Type dynamicMessage = (Type)COM_GOOGLE_PROTOBUF_DYNAMICMESSAGE.get(state);
        if (ASTHelpers.isSameType((Type)leftType, (Type)dynamicMessage, (VisitorState)state) || ASTHelpers.isSameType((Type)rightType, (Type)dynamicMessage, (VisitorState)state)) {
            return false;
        }
        Type protoBase = (Type)COM_GOOGLE_PROTOBUF_MESSAGE.get(state);
        if (ASTHelpers.isSameType((Type)nearestCommonSupertype, (Type)protoBase, (VisitorState)state) && !ASTHelpers.isSameType((Type)leftType, (Type)protoBase, (VisitorState)state) && !ASTHelpers.isSameType((Type)rightType, (Type)protoBase, (VisitorState)state)) {
            String rightClassPart;
            String leftClassPart = TypeCompatibilityUtils.classNamePart(leftType);
            return !TypeCompatibilityUtils.classesAreMutableAndImmutableOfSameType(leftClassPart, rightClassPart = TypeCompatibilityUtils.classNamePart(rightType)) && !TypeCompatibilityUtils.classesAreMutableAndImmutableOfSameType(rightClassPart, leftClassPart);
        }
        Type messageLite = (Type)COM_GOOGLE_PROTOBUF_MESSAGELITE.get(state);
        return ASTHelpers.isSubtype((Type)nearestCommonSupertype, (Type)messageLite, (VisitorState)state) && TypeCompatibilityUtils.isConcrete(leftType, state.getTypes()) && TypeCompatibilityUtils.isConcrete(rightType, state.getTypes());
    }

    private static boolean isConcrete(Type type, Types types) {
        Type toEvaluate = ASTHelpers.getUpperBound((Type)type, (Types)types);
        return (toEvaluate.tsym.flags() & 0x600L) == 0L;
    }

    private static boolean classesAreMutableAndImmutableOfSameType(String l, String r) {
        return l.startsWith("Mutable") && l.substring("Mutable".length()).equals(r);
    }

    private static String classNamePart(Type type) {
        String packageName;
        String fullClassname = type.asElement().getQualifiedName().toString();
        String prefix = fullClassname.substring((packageName = ASTHelpers.enclosingPackage((Symbol)type.asElement()).fullname.toString()).length());
        return prefix.startsWith(".") ? prefix.substring(1) : prefix;
    }

    private TypeCompatibilityReport checkForGenericsMismatch(Type leftType, Type rightType, Type superType, Set<Type> previousLeftTypes, Set<Type> previousRightTypes, VisitorState state) {
        java.util.List<Type> leftGenericTypes = TypeCompatibilityUtils.typeArgsAsSuper(leftType, superType, state);
        java.util.List<Type> rightGenericTypes = TypeCompatibilityUtils.typeArgsAsSuper(rightType, superType, state);
        return Streams.zip(leftGenericTypes.stream(), rightGenericTypes.stream(), TypePair::new).filter(tp -> !previousLeftTypes.contains(tp.left) && !ASTHelpers.isSameType((Type)tp.left, (Type)leftType, (VisitorState)state) && !previousRightTypes.contains(tp.right) && !ASTHelpers.isSameType((Type)tp.right, (Type)rightType, (VisitorState)state)).map(types -> {
            TreeSet<Type> nextLeftTypes = TypeCompatibilityUtils.typeSet(state);
            nextLeftTypes.addAll(previousLeftTypes);
            nextLeftTypes.add(leftType);
            TreeSet<Type> nextRightTypes = TypeCompatibilityUtils.typeSet(state);
            nextRightTypes.addAll(previousRightTypes);
            nextRightTypes.add(rightType);
            return this.compatibilityOfTypes(types.left, types.right, nextLeftTypes, nextRightTypes, state);
        }).filter(tcr -> !tcr.isCompatible()).findFirst().orElse(TypeCompatibilityReport.compatible());
    }

    private static java.util.List<Type> typeArgsAsSuper(Type baseType, Type superType, VisitorState state) {
        Type projectedType = state.getTypes().asSuper(baseType, superType.tsym);
        if (projectedType != null) {
            return projectedType.getTypeArguments();
        }
        return new ArrayList<Type>();
    }

    private static TreeSet<Type> typeSet(VisitorState state) {
        return new TreeSet<Type>((t1, t2) -> state.getTypes().isSameType((Type)t1, (Type)t2) ? 0 : t1.toString().compareTo(t2.toString()));
    }

    @AutoValue
    public static abstract class TypeCompatibilityReport {
        private static final TypeCompatibilityReport COMPATIBLE = new AutoValue_TypeCompatibilityUtils_TypeCompatibilityReport(true, null, null, null);

        public abstract boolean isCompatible();

        @Nullable
        public abstract Type lhs();

        @Nullable
        public abstract Type rhs();

        @Nullable
        public abstract String extraReason();

        static TypeCompatibilityReport compatible() {
            return COMPATIBLE;
        }

        static TypeCompatibilityReport incompatible(Type lhs, Type rhs) {
            return TypeCompatibilityReport.incompatible(lhs, rhs, "");
        }

        static TypeCompatibilityReport incompatible(Type lhs, Type rhs, String extraReason) {
            return new AutoValue_TypeCompatibilityUtils_TypeCompatibilityReport(false, lhs, rhs, extraReason);
        }
    }

    private static final class TypePair {
        final Type left;
        final Type right;

        TypePair(Type left, Type right) {
            this.left = left;
            this.right = right;
        }
    }
}

