/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind.helpers;

import java.text.MessageFormat;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.helpers.Messages;

public class ValidationEventImpl
implements ValidationEvent {
    private int severity;
    private String message;
    private Throwable linkedException;
    private ValidationEventLocator locator;

    public ValidationEventImpl(int n, String string, ValidationEventLocator validationEventLocator) {
        this(n, string, validationEventLocator, null);
    }

    public ValidationEventImpl(int n, String string, ValidationEventLocator validationEventLocator, Throwable throwable) {
        this.setSeverity(n);
        this.message = string;
        this.locator = validationEventLocator;
        this.linkedException = throwable;
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException(Messages.format("ValidationEventImpl.IllegalSeverity"));
        }
        this.severity = n;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    @Override
    public Throwable getLinkedException() {
        return this.linkedException;
    }

    public void setLinkedException(Throwable throwable) {
        this.linkedException = throwable;
    }

    @Override
    public ValidationEventLocator getLocator() {
        return this.locator;
    }

    public void setLocator(ValidationEventLocator validationEventLocator) {
        this.locator = validationEventLocator;
    }

    public String toString() {
        String string;
        switch (this.getSeverity()) {
            case 0: {
                string = "WARNING";
                break;
            }
            case 1: {
                string = "ERROR";
                break;
            }
            case 2: {
                string = "FATAL_ERROR";
                break;
            }
            default: {
                string = String.valueOf(this.getSeverity());
            }
        }
        return MessageFormat.format("[severity={0},message={1},locator={2}]", string, this.getMessage(), this.getLocator());
    }
}

