/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.repositoryv2.AndroidSdkHandler;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;

public final class SdkMavenRepository
extends Enum<SdkMavenRepository> {
    public static final /* enum */ SdkMavenRepository ANDROID = new SdkMavenRepository("android", "Android Support Repository");
    public static final /* enum */ SdkMavenRepository GOOGLE = new SdkMavenRepository("google", "Google Support Repository");
    private final String mDir;
    private final String myDisplayName;
    private static final /* synthetic */ SdkMavenRepository[] $VALUES;

    public static SdkMavenRepository[] values() {
        return (SdkMavenRepository[])$VALUES.clone();
    }

    public static SdkMavenRepository valueOf(String name) {
        return Enum.valueOf(SdkMavenRepository.class, name);
    }

    private SdkMavenRepository(String dir, String displayName) {
        this.mDir = dir;
        this.myDisplayName = displayName;
    }

    @Deprecated
    public File getRepositoryLocation(File sdkHome, boolean requireExists) {
        return this.getRepositoryLocation(sdkHome, requireExists, FileOpUtils.create());
    }

    public File getRepositoryLocation(File sdkHome, boolean requireExists, FileOp fileOp) {
        if (sdkHome != null) {
            File dir = new File(sdkHome, "extras" + File.separator + this.mDir + File.separator + "m2repository");
            if (!requireExists || fileOp.isDirectory(dir)) {
                return dir;
            }
        }
        return null;
    }

    public boolean isInstalled(File sdkHome, FileOp fileOp) {
        return this.getRepositoryLocation(sdkHome, true, fileOp) != null;
    }

    public boolean isInstalled(AndroidSdkHandler sdkHandler) {
        if (sdkHandler != null) {
            ConsoleProgressIndicator progress = new ConsoleProgressIndicator();
            RepoManager mgr = sdkHandler.getSdkManager((ProgressIndicator)progress);
            return mgr.getPackages().getLocalPackages().containsKey(this.getPackageId());
        }
        return false;
    }

    public String getPackageId() {
        return String.format("extras;%s;%s", this.mDir, "m2repository");
    }

    @Deprecated
    public GradleCoordinate getHighestInstalledVersion(File sdkHome, String groupId, String artifactId, String filter, boolean allowPreview) {
        return this.getHighestInstalledVersion(sdkHome, groupId, artifactId, filter, allowPreview, FileOpUtils.create());
    }

    public GradleCoordinate getHighestInstalledVersion(File sdkHome, String groupId, String artifactId, String filter, boolean allowPreview, FileOp fileOp) {
        File repository = this.getRepositoryLocation(sdkHome, true, fileOp);
        if (repository != null) {
            return SdkMavenRepository.getHighestInstalledVersion(groupId, artifactId, repository, filter, allowPreview, fileOp);
        }
        return null;
    }

    @Deprecated
    public static GradleCoordinate getHighestInstalledVersion(String groupId, String artifactId, File repository, String filter, boolean allowPreview) {
        return SdkMavenRepository.getHighestInstalledVersion(groupId, artifactId, repository, filter, allowPreview, FileOpUtils.create());
    }

    public static GradleCoordinate getHighestInstalledVersion(String groupId, String artifactId, File repository, String filter, boolean allowPreview, FileOp fileOp) {
        assert ("m2repository".equals(repository.getName())) : repository;
        File versionDir = new File(repository, groupId.replace('.', File.separatorChar) + File.separator + artifactId);
        File[] versions = fileOp.listFiles(versionDir);
        ArrayList versionCoordinates = Lists.newArrayList();
        for (File dir : versions) {
            GradleCoordinate gc;
            if (!fileOp.isDirectory(dir) || filter != null && !dir.getName().startsWith(filter) || (gc = GradleCoordinate.parseCoordinateString(groupId + ":" + artifactId + ":" + dir.getName())) == null || !allowPreview && gc.isPreview() || !allowPreview && "5.2.08".equals(gc.getRevision()) && "play-services".equals(gc.getArtifactId())) continue;
            versionCoordinates.add(gc);
        }
        if (!versionCoordinates.isEmpty()) {
            return Collections.max(versionCoordinates, GradleCoordinate.COMPARE_PLUS_HIGHER);
        }
        return null;
    }

    public static SdkMavenRepository getByGroupId(String groupId) {
        if ("com.android.support".equals(groupId) || "com.android.support.test".equals(groupId)) {
            return ANDROID;
        }
        if (groupId.startsWith("com.google.android.")) {
            return GOOGLE;
        }
        return null;
    }

    public String getDirName() {
        return this.mDir;
    }

    static {
        $VALUES = new SdkMavenRepository[]{ANDROID, GOOGLE};
    }
}

