/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

abstract class RecursableDiffEntity {
    private Boolean isAnyChildIgnored = null;
    private Boolean isAnyChildMatched = null;

    private RecursableDiffEntity() {
    }

    abstract Iterable<? extends RecursableDiffEntity> childEntities();

    abstract boolean isMatched();

    abstract boolean isIgnored();

    final boolean isAnyChildMatched() {
        if (this.isAnyChildMatched == null) {
            this.isAnyChildMatched = false;
            for (RecursableDiffEntity recursableDiffEntity : this.childEntities()) {
                if ((!recursableDiffEntity.isMatched() || recursableDiffEntity.isContentEmpty()) && !recursableDiffEntity.isAnyChildMatched()) continue;
                this.isAnyChildMatched = true;
                break;
            }
        }
        return this.isAnyChildMatched;
    }

    final boolean isAnyChildIgnored() {
        if (this.isAnyChildIgnored == null) {
            this.isAnyChildIgnored = false;
            for (RecursableDiffEntity recursableDiffEntity : this.childEntities()) {
                if ((!recursableDiffEntity.isIgnored() || recursableDiffEntity.isContentEmpty()) && !recursableDiffEntity.isAnyChildIgnored()) continue;
                this.isAnyChildIgnored = true;
                break;
            }
        }
        return this.isAnyChildIgnored;
    }

    abstract void printContents(boolean var1, String var2, StringBuilder var3);

    abstract boolean isContentEmpty();

    final void printChildContents(boolean includeMatches, String fieldPrefix, StringBuilder sb) {
        for (RecursableDiffEntity recursableDiffEntity : this.childEntities()) {
            recursableDiffEntity.printContents(includeMatches, fieldPrefix, sb);
        }
    }

    static abstract class WithResultCode
    extends RecursableDiffEntity {
        WithResultCode() {
        }

        abstract Result result();

        @Override
        final boolean isMatched() {
            return this.result() == Result.MATCHED || this.result() == Result.IGNORED;
        }

        @Override
        final boolean isIgnored() {
            return this.result() == Result.IGNORED;
        }

        static enum Result {
            MATCHED,
            ADDED,
            REMOVED,
            MODIFIED,
            MOVED_OUT_OF_ORDER,
            IGNORED;


            static Builder builder() {
                return new Builder();
            }

            static final class Builder {
                private Result state = MATCHED;

                private Builder() {
                }

                public void markAddedIf(boolean condition) {
                    this.setIf(condition, ADDED);
                }

                public void markRemovedIf(boolean condition) {
                    this.setIf(condition, REMOVED);
                }

                public void markModifiedIf(boolean condition) {
                    this.setIf(condition, MODIFIED);
                }

                public Result build() {
                    return this.state;
                }

                private void setIf(boolean condition, Result newState) {
                    if (condition && this.state == MATCHED) {
                        this.state = newState;
                    }
                }
            }
        }
    }

    static abstract class WithoutResultCode
    extends RecursableDiffEntity {
        private Boolean isMatched = null;
        private Boolean isIgnored = null;

        WithoutResultCode() {
        }

        @Override
        final boolean isMatched() {
            if (this.isMatched == null) {
                this.isMatched = true;
                for (RecursableDiffEntity recursableDiffEntity : this.childEntities()) {
                    if (recursableDiffEntity.isMatched()) continue;
                    this.isMatched = false;
                    break;
                }
            }
            return this.isMatched;
        }

        @Override
        final boolean isIgnored() {
            if (this.isIgnored == null) {
                this.isIgnored = true;
                for (RecursableDiffEntity recursableDiffEntity : this.childEntities()) {
                    if (recursableDiffEntity.isIgnored()) continue;
                    this.isIgnored = false;
                    break;
                }
            }
            return this.isIgnored;
        }
    }
}

