/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Types;
import javax.annotation.Nullable;

@BugPattern(summary="Casting inside an if block should be plausibly consistent with the instanceof type", severity=BugPattern.SeverityLevel.WARNING)
public class InstanceOfAndCastMatchWrongType
extends BugChecker
implements BugChecker.TypeCastTreeMatcher {
    public Description matchTypeCast(TypeCastTree typeCastTree, VisitorState visitorState) {
        CastingMatcher castingMatcher = new CastingMatcher();
        if (!(typeCastTree.getExpression() instanceof IdentifierTree) && !(typeCastTree.getExpression() instanceof ArrayAccessTree)) {
            return Description.NO_MATCH;
        }
        if (castingMatcher.matches(typeCastTree, visitorState)) {
            return this.describeMatch(typeCastTree, (Fix)SuggestedFix.replace((Tree)castingMatcher.nodeToReplace, (String)visitorState.getSourceForNode(typeCastTree.getType())));
        }
        return Description.NO_MATCH;
    }

    private static boolean expressionsEqual(ExpressionTree expr1, ExpressionTree expr2) {
        if (!expr1.getKind().equals((Object)expr2.getKind())) {
            return false;
        }
        if (!(expr1.getKind().equals((Object)Tree.Kind.ARRAY_ACCESS) || expr1.getKind().equals((Object)Tree.Kind.IDENTIFIER) || expr1 instanceof LiteralTree)) {
            return false;
        }
        if (expr1.getKind() == Tree.Kind.ARRAY_ACCESS) {
            ArrayAccessTree arrayAccessTree1 = (ArrayAccessTree)expr1;
            ArrayAccessTree arrayAccessTree2 = (ArrayAccessTree)expr2;
            return InstanceOfAndCastMatchWrongType.expressionsEqual(arrayAccessTree1.getExpression(), arrayAccessTree2.getExpression()) && InstanceOfAndCastMatchWrongType.expressionsEqual(arrayAccessTree1.getIndex(), arrayAccessTree2.getIndex());
        }
        if (expr1 instanceof LiteralTree) {
            LiteralTree literalTree1 = (LiteralTree)expr1;
            LiteralTree literalTree2 = (LiteralTree)expr2;
            return literalTree1.getValue().equals(literalTree2.getValue());
        }
        return Objects.equal((Object)ASTHelpers.getSymbol((Tree)expr1), (Object)ASTHelpers.getSymbol((Tree)expr2));
    }

    private static class CastingMatcher
    implements Matcher<Tree> {
        Tree nodeToReplace;

        private CastingMatcher() {
        }

        public boolean matches(Tree tree, VisitorState state) {
            TreePath pathToTop = ASTHelpers.findPathFromEnclosingNodeToTopLevel((TreePath)state.getPath(), IfTree.class);
            while (pathToTop != null) {
                IfTree ifTree = (IfTree)pathToTop.getLeaf();
                ExpressionTree expressionTree = ASTHelpers.stripParentheses((ExpressionTree)ifTree.getCondition());
                TreeScannerInstanceOfWrongType treeScannerInstanceOfWrongType = new TreeScannerInstanceOfWrongType(state);
                treeScannerInstanceOfWrongType.scan(expressionTree, ((TypeCastTree)tree).getExpression());
                InstanceOfTree treeInstance = treeScannerInstanceOfWrongType.getRelevantTree();
                if (treeInstance == null) {
                    pathToTop = ASTHelpers.findPathFromEnclosingNodeToTopLevel((TreePath)pathToTop, IfTree.class);
                    continue;
                }
                if (ifTree.getElseStatement() != null && Iterables.contains((Iterable)state.getPath(), (Object)ifTree.getElseStatement())) {
                    return false;
                }
                Types types = state.getTypes();
                InstanceOfTree instanceOfTree = treeInstance;
                this.nodeToReplace = instanceOfTree.getType();
                treeScannerInstanceOfWrongType.scan(ifTree.getThenStatement(), instanceOfTree.getExpression());
                int pos = treeScannerInstanceOfWrongType.earliestStart;
                if (pos < ASTHelpers.getStartPosition((Tree)tree)) {
                    return false;
                }
                boolean isCastable = types.isCastable(types.erasure(ASTHelpers.getType((Tree)instanceOfTree.getType())), types.erasure(ASTHelpers.getType((Tree)tree)));
                ExpressionTree typeCastExp = ((TypeCastTree)tree).getExpression();
                boolean isSameExpression = InstanceOfAndCastMatchWrongType.expressionsEqual(typeCastExp, instanceOfTree.getExpression());
                return isSameExpression && !isCastable;
            }
            return false;
        }
    }

    static class TreeScannerInstanceOfWrongType
    extends TreeScanner<Void, ExpressionTree> {
        int earliestStart = Integer.MAX_VALUE;
        private InstanceOfTree relevantTree;
        private boolean notApplicable = false;
        private final VisitorState state;

        @Nullable
        InstanceOfTree getRelevantTree() {
            if (this.notApplicable) {
                return null;
            }
            return this.relevantTree;
        }

        public TreeScannerInstanceOfWrongType(VisitorState currState) {
            this.state = currState;
        }

        @Override
        public Void visitBinary(BinaryTree binTree, ExpressionTree expr) {
            if (binTree.getKind().equals((Object)Tree.Kind.CONDITIONAL_OR)) {
                this.notApplicable = true;
            }
            return (Void)super.visitBinary(binTree, expr);
        }

        @Override
        public Void visitUnary(UnaryTree tree, ExpressionTree expr) {
            if (tree.getKind().equals((Object)Tree.Kind.LOGICAL_COMPLEMENT)) {
                this.notApplicable = true;
            }
            return (Void)super.visitUnary(tree, expr);
        }

        @Override
        public Void visitInstanceOf(InstanceOfTree tree, ExpressionTree expr) {
            if (InstanceOfAndCastMatchWrongType.expressionsEqual(tree.getExpression(), expr)) {
                this.relevantTree = tree;
            }
            return (Void)super.visitInstanceOf(tree, expr);
        }

        @Override
        public Void visitAssignment(AssignmentTree tree, ExpressionTree expr) {
            if (InstanceOfAndCastMatchWrongType.expressionsEqual(tree.getVariable(), expr)) {
                this.earliestStart = Math.min(this.earliestStart, this.state.getEndPosition((Tree)tree));
            }
            return (Void)super.visitAssignment(tree, expr);
        }
    }
}

