/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.TypeCompatibility;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import javax.inject.Inject;

@BugPattern(summary="An equality test between objects with incompatible types always returns false", severity=BugPattern.SeverityLevel.WARNING)
public class EqualsIncompatibleType
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.MemberReferenceTreeMatcher {
    private static final Matcher<ExpressionTree> STATIC_EQUALS_MATCHER = Matchers.staticEqualsInvocation();
    private static final Matcher<ExpressionTree> INSTANCE_EQUALS_MATCHER = Matchers.instanceEqualsInvocation();
    private static final Matcher<ExpressionTree> IS_EQUAL_MATCHER = Matchers.staticMethod().onClass("java.util.function.Predicate").named("isEqual");
    private static final Matcher<Tree> ASSERT_FALSE_MATCHER = Matchers.toType(MethodInvocationTree.class, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().anyClass().named("assertFalse"), Matchers.staticMethod().anyClass().named("assertFalse")}));
    private final TypeCompatibility typeCompatibility;

    @Inject
    EqualsIncompatibleType(TypeCompatibility typeCompatibility) {
        this.typeCompatibility = typeCompatibility;
    }

    public Description matchMethodInvocation(MethodInvocationTree invocationTree, VisitorState state) {
        if (STATIC_EQUALS_MATCHER.matches((Tree)invocationTree, state)) {
            return this.match(invocationTree, ASTHelpers.getType((Tree)invocationTree.getArguments().get(0)), ASTHelpers.getType((Tree)invocationTree.getArguments().get(1)), state);
        }
        if (INSTANCE_EQUALS_MATCHER.matches((Tree)invocationTree, state)) {
            return this.match(invocationTree, ASTHelpers.getReceiverType((ExpressionTree)invocationTree), ASTHelpers.getType((Tree)invocationTree.getArguments().get(0)), state);
        }
        if (IS_EQUAL_MATCHER.matches((Tree)invocationTree, state)) {
            Type targetType = ASTHelpers.targetType((VisitorState)state).type();
            if (targetType.getTypeArguments().size() != 1) {
                return Description.NO_MATCH;
            }
            return this.match(invocationTree, ASTHelpers.getType((Tree)invocationTree.getArguments().get(0)), state.getTypes().wildLowerBound((Type)Iterables.getOnlyElement(targetType.getTypeArguments())), state);
        }
        return Description.NO_MATCH;
    }

    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        if (STATIC_EQUALS_MATCHER.matches((Tree)tree, state)) {
            Type type = state.getTypes().findDescriptorType(ASTHelpers.getType((Tree)tree));
            return this.match(tree, type.getParameterTypes().get(0), type.getParameterTypes().get(1), state);
        }
        if (INSTANCE_EQUALS_MATCHER.matches((Tree)tree, state)) {
            Type type = state.getTypes().findDescriptorType(ASTHelpers.getType((Tree)tree));
            return this.match(tree, ASTHelpers.getType((Tree)ASTHelpers.getReceiver((ExpressionTree)tree)), type.getParameterTypes().get(0), state);
        }
        if (IS_EQUAL_MATCHER.matches((Tree)tree, state)) {
            Type type = state.getTypes().findDescriptorType(ASTHelpers.getType((Tree)tree));
            if (type.getReturnType().getTypeArguments().size() != 1) {
                return Description.NO_MATCH;
            }
            return this.match(tree, (Type)Iterables.getOnlyElement(type.getReturnType().getTypeArguments()), type.getParameterTypes().get(0), state);
        }
        return Description.NO_MATCH;
    }

    private Description match(ExpressionTree invocationTree, Type receiverType, Type argumentType, VisitorState state) {
        TypeCompatibility.TypeCompatibilityReport compatibilityReport = this.typeCompatibility.compatibilityOfTypes(receiverType, argumentType, state);
        if (compatibilityReport.isCompatible()) {
            return Description.NO_MATCH;
        }
        if (ASSERT_FALSE_MATCHER.matches(state.getPath().getParentPath().getLeaf(), state)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.getGeneratedBy((VisitorState)state).contains((Object)"com.google.auto.value.processor.AutoValueProcessor")) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(invocationTree).setMessage(EqualsIncompatibleType.getMessage(invocationTree, receiverType, argumentType, compatibilityReport.lhs(), compatibilityReport.rhs(), state) + compatibilityReport.extraReason()).build();
    }

    private static String getMessage(ExpressionTree invocationTree, Type receiverType, Type argumentType, Type conflictingReceiverType, Type conflictingArgumentType, VisitorState state) {
        TypeStringPair typeStringPair = new TypeStringPair(receiverType, argumentType);
        String baseMessage = "Calling " + ASTHelpers.getSymbol((Tree)invocationTree).getSimpleName() + " on incompatible types " + typeStringPair.getReceiverTypeString() + " and " + typeStringPair.getArgumentTypeString();
        if (state.getTypes().isSameType(receiverType, conflictingReceiverType)) {
            return baseMessage;
        }
        TypeStringPair conflictingTypes = new TypeStringPair(conflictingReceiverType, conflictingArgumentType);
        return baseMessage + ". They are incompatible because " + conflictingTypes.getReceiverTypeString() + " and " + conflictingTypes.getArgumentTypeString() + " are incompatible.";
    }

    private static class TypeStringPair {
        private String receiverTypeString;
        private String argumentTypeString;

        private TypeStringPair(Type receiverType, Type argumentType) {
            this.receiverTypeString = Signatures.prettyType((Type)receiverType);
            this.argumentTypeString = Signatures.prettyType((Type)argumentType);
            if (this.argumentTypeString.equals(this.receiverTypeString)) {
                this.receiverTypeString = receiverType.toString();
                this.argumentTypeString = argumentType.toString();
            }
        }

        private String getReceiverTypeString() {
            return this.receiverTypeString;
        }

        private String getArgumentTypeString() {
            return this.argumentTypeString;
        }
    }
}

