/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.javacutil;

import java.util.Objects;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.javacutil.CollectionUtils;
import org.checkerframework.errorprone.javacutil.DeepCopyable;

public class Pair<V1, V2> {
    public final V1 first;
    public final V2 second;
    private int hashCode = -1;

    private Pair(V1 v1, V2 v2) {
        this.first = v1;
        this.second = v2;
    }

    public static <V1, V2> Pair<V1, V2> of(V1 v1, V2 v2) {
        return new Pair<V1, V2>(v1, v2);
    }

    public static <V1 extends Cloneable, V2 extends Cloneable> Pair<V1, V2> cloneElements(Pair<V1, V2> orig) {
        Cloneable oldFirst = (Cloneable)orig.first;
        Cloneable newFirst = oldFirst == null ? oldFirst : CollectionUtils.clone(oldFirst);
        Cloneable oldSecond = (Cloneable)orig.second;
        Cloneable newSecond = oldSecond == null ? oldSecond : CollectionUtils.clone(oldSecond);
        return Pair.of(newFirst, newSecond);
    }

    public static <V1 extends DeepCopyable<V1>, V2 extends DeepCopyable<V2>> Pair<V1, V2> deepCopy(Pair<V1, V2> orig) {
        return Pair.of(DeepCopyable.deepCopyOrNull((DeepCopyable)orig.first), DeepCopyable.deepCopyOrNull((DeepCopyable)orig.second));
    }

    public static <V1 extends DeepCopyable<V1>, V2> Pair<V1, V2> deepCopyFirst(Pair<V1, V2> orig) {
        return Pair.of(DeepCopyable.deepCopyOrNull((DeepCopyable)orig.first), orig.second);
    }

    public static <V1, V2 extends DeepCopyable<V2>> Pair<V1, V2> deepCopySecond(Pair<V1, V2> orig) {
        return Pair.of(orig.first, DeepCopyable.deepCopyOrNull((DeepCopyable)orig.second));
    }

    @SideEffectFree
    public String toString() {
        return "Pair(" + this.first + ", " + this.second + ")";
    }

    @Pure
    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = Objects.hash(this.first, this.second);
        }
        return this.hashCode;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)o;
        return Objects.equals(this.first, other.first) && Objects.equals(this.second, other.second);
    }
}

