/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.defaultanswers;

import java.io.IOException;
import java.io.Serializable;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.internal.MockitoCore;
import org.mockito.internal.creation.settings.CreationSettings;
import org.mockito.internal.stubbing.InvocationContainerImpl;
import org.mockito.internal.stubbing.StubbedInvocationMatcher;
import org.mockito.internal.stubbing.defaultanswers.ReturnsEmptyValues;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.reflection.GenericMetadataSupport;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.mock.MockCreationSettings;
import org.mockito.stubbing.Answer;

public class ReturnsDeepStubs
implements Answer<Object>,
Serializable {
    private static final long serialVersionUID = -7105341425736035847L;

    @Override
    public Object answer(InvocationOnMock invocation) throws Throwable {
        GenericMetadataSupport returnTypeGenericMetadata = this.actualParameterizedType(invocation.getMock()).resolveGenericReturnType(invocation.getMethod());
        MockCreationSettings mockSettings = MockUtil.getMockSettings(invocation.getMock());
        Class<?> rawType = returnTypeGenericMetadata.rawType();
        if (!MockUtil.typeMockabilityOf(rawType, mockSettings.getMockMaker()).mockable()) {
            if (invocation.getMethod().getReturnType().equals(rawType)) {
                return ReturnsDeepStubs.delegate().answer(invocation);
            }
            return ReturnsDeepStubs.delegate().returnValueFor(rawType);
        }
        if (rawType.equals(Object.class) && !returnTypeGenericMetadata.hasRawExtraInterfaces()) {
            return null;
        }
        return this.deepStub(invocation, returnTypeGenericMetadata);
    }

    private Object deepStub(InvocationOnMock invocation, GenericMetadataSupport returnTypeGenericMetadata) throws Throwable {
        InvocationContainerImpl container = MockUtil.getInvocationContainer(invocation.getMock());
        Answer<?> existingAnswer = container.findStubbedAnswer();
        if (existingAnswer != null) {
            return existingAnswer.answer(invocation);
        }
        StubbedInvocationMatcher stubbing = this.recordDeepStubAnswer(this.newDeepStubMock(returnTypeGenericMetadata, invocation.getMock()), container);
        stubbing.markStubUsed(stubbing.getInvocation());
        return stubbing.answer(invocation);
    }

    private Object newDeepStubMock(GenericMetadataSupport returnTypeGenericMetadata, Object parentMock) {
        MockCreationSettings parentMockSettings = MockUtil.getMockSettings(parentMock);
        return ReturnsDeepStubs.mockitoCore().mock(returnTypeGenericMetadata.rawType(), this.withSettingsUsing(returnTypeGenericMetadata, parentMockSettings));
    }

    private MockSettings withSettingsUsing(GenericMetadataSupport returnTypeGenericMetadata, MockCreationSettings<?> parentMockSettings) {
        MockSettings mockSettings = returnTypeGenericMetadata.hasRawExtraInterfaces() ? Mockito.withSettings().extraInterfaces(returnTypeGenericMetadata.rawExtraInterfaces()) : Mockito.withSettings();
        return this.propagateSerializationSettings(mockSettings, parentMockSettings).defaultAnswer(this.returnsDeepStubsAnswerUsing(returnTypeGenericMetadata)).mockMaker(parentMockSettings.getMockMaker());
    }

    private MockSettings propagateSerializationSettings(MockSettings mockSettings, MockCreationSettings parentMockSettings) {
        return mockSettings.serializable(parentMockSettings.getSerializableMode());
    }

    private ReturnsDeepStubs returnsDeepStubsAnswerUsing(GenericMetadataSupport returnTypeGenericMetadata) {
        return new ReturnsDeepStubsSerializationFallback(returnTypeGenericMetadata);
    }

    private StubbedInvocationMatcher recordDeepStubAnswer(Object mock, InvocationContainerImpl container) {
        DeeplyStubbedAnswer answer = new DeeplyStubbedAnswer(mock);
        return container.addAnswer(answer, false, null);
    }

    protected GenericMetadataSupport actualParameterizedType(Object mock) {
        CreationSettings mockSettings = (CreationSettings)MockUtil.getMockHandler(mock).getMockSettings();
        return GenericMetadataSupport.inferFrom(mockSettings.getTypeToMock());
    }

    private static MockitoCore mockitoCore() {
        return LazyHolder.MOCKITO_CORE;
    }

    private static ReturnsEmptyValues delegate() {
        return LazyHolder.DELEGATE;
    }

    private static class LazyHolder {
        private static final MockitoCore MOCKITO_CORE = new MockitoCore();
        private static final ReturnsEmptyValues DELEGATE = new ReturnsEmptyValues();

        private LazyHolder() {
        }
    }

    private static class DeeplyStubbedAnswer
    implements Answer<Object>,
    Serializable {
        private final Object mock;

        DeeplyStubbedAnswer(Object mock) {
            this.mock = mock;
        }

        @Override
        public Object answer(InvocationOnMock invocation) throws Throwable {
            return this.mock;
        }
    }

    private static class ReturnsDeepStubsSerializationFallback
    extends ReturnsDeepStubs
    implements Serializable {
        private final GenericMetadataSupport returnTypeGenericMetadata;

        public ReturnsDeepStubsSerializationFallback(GenericMetadataSupport returnTypeGenericMetadata) {
            this.returnTypeGenericMetadata = returnTypeGenericMetadata;
        }

        @Override
        protected GenericMetadataSupport actualParameterizedType(Object mock) {
            return this.returnTypeGenericMetadata;
        }

        private Object writeReplace() throws IOException {
            return Mockito.RETURNS_DEEP_STUBS;
        }
    }
}

