/*
 * Decompiled with CFR 0.152.
 */
package proguard.util.kotlin.asserter;

import proguard.classfile.util.WarningPrinter;
import proguard.util.kotlin.asserter.Reporter;

class DefaultReporter
implements Reporter {
    private final WarningPrinter warningPrinter;
    private int count;
    private String errorMessage = "";
    private String contextName = "";

    DefaultReporter(WarningPrinter warningPrinter) {
        this.warningPrinter = warningPrinter;
        this.count = 0;
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public void report(String error) {
        if (this.count == 0) {
            this.warningPrinter.print(this.contextName, String.format(this.errorMessage, this.contextName));
        }
        ++this.count;
        this.warningPrinter.print(this.contextName, "  " + error);
    }

    @Override
    public void resetCounter(String contextName) {
        this.contextName = contextName;
        this.count = 0;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void print(String className, String s) {
        this.warningPrinter.print(className, s);
    }
}

