/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Reachability;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

@BugPattern(summary="The default case of a switch should appear at the end of the last statement group", tags={"Style"}, severity=BugPattern.SeverityLevel.SUGGESTION)
public class SwitchDefault
extends BugChecker
implements BugChecker.SwitchTreeMatcher {
    public Description matchSwitch(SwitchTree tree, VisitorState state) {
        Optional maybeDefault = ASTHelpers.getSwitchDefault((SwitchTree)tree);
        if (!maybeDefault.isPresent()) {
            return Description.NO_MATCH;
        }
        ArrayList<CaseTree> defaultStatementGroup = new ArrayList<CaseTree>();
        Iterator<? extends CaseTree> it = tree.getCases().iterator();
        while (it.hasNext()) {
            CaseTree caseTree = it.next();
            defaultStatementGroup.add(caseTree);
            if (caseTree.getExpression() == null) {
                while (it.hasNext() && SwitchDefault.isNullOrEmpty(caseTree.getStatements())) {
                    caseTree = it.next();
                    defaultStatementGroup.add(caseTree);
                }
                break;
            }
            if (SwitchDefault.isNullOrEmpty(caseTree.getStatements())) continue;
            defaultStatementGroup.clear();
        }
        int idx = defaultStatementGroup.indexOf(maybeDefault.get());
        SuggestedFix.Builder fix = SuggestedFix.builder();
        CaseTree defaultTree = (CaseTree)defaultStatementGroup.get(idx);
        if (it.hasNext()) {
            if (!Reachability.canCompleteNormally((CaseTree)((CaseTree)Iterables.getLast(defaultStatementGroup)))) {
                Object replacement;
                int start = ASTHelpers.getStartPosition((Tree)((Tree)defaultStatementGroup.get(0)));
                int end = state.getEndPosition((Tree)Iterables.getLast(defaultStatementGroup));
                String source = state.getSourceCode().toString();
                if (idx != defaultStatementGroup.size() - 1) {
                    int caseEnd = ASTHelpers.getStartPosition((Tree)((CaseTree)Iterables.getLast(defaultStatementGroup)).getStatements().get(0));
                    int cutStart = ASTHelpers.getStartPosition((Tree)defaultTree);
                    int cutEnd = state.getEndPosition((Tree)defaultTree);
                    replacement = source.substring(start, cutStart) + source.substring(cutEnd, caseEnd) + "\n" + source.substring(cutStart, cutEnd) + source.substring(caseEnd, end);
                } else {
                    replacement = source.substring(start, end);
                }
                CaseTree last = (CaseTree)Iterables.getLast(tree.getCases());
                if (last.getExpression() == null || Reachability.canCompleteNormally((CaseTree)last)) {
                    replacement = "break;\n" + (String)replacement;
                }
                fix.replace(start, end, "").postfixWith((Tree)Iterables.getLast(tree.getCases()), (String)replacement);
            }
        } else if (idx != defaultStatementGroup.size() - 1) {
            fix.delete((Tree)defaultTree);
            CaseTree lastCase = (CaseTree)Iterables.getLast(defaultStatementGroup);
            if (!SwitchDefault.isNullOrEmpty(lastCase.getStatements())) {
                fix.prefixWith((Tree)lastCase.getStatements().get(0), state.getSourceForNode((Tree)defaultTree));
            } else {
                fix.postfixWith((Tree)lastCase, state.getSourceForNode((Tree)defaultTree));
            }
        } else {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription((Tree)defaultStatementGroup.get(0));
        if (!fix.isEmpty()) {
            description.addFix((Fix)fix.build());
        }
        return description.build();
    }

    private static <T> boolean isNullOrEmpty(@Nullable List<T> elementList) {
        return elementList == null || elementList.isEmpty();
    }
}

