/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.instrument;

import com.google.caliper.core.BenchmarkClassModel;
import com.google.caliper.core.InvalidBenchmarkException;
import com.google.caliper.core.InvalidInstrumentException;
import com.google.caliper.runner.RunScoped;
import com.google.caliper.runner.config.CaliperConfig;
import com.google.caliper.runner.config.InstrumentConfig;
import com.google.caliper.runner.config.VmType;
import com.google.caliper.runner.instrument.ArbitraryMeasurementInstrument;
import com.google.caliper.runner.instrument.DaggerInstrumentComponent;
import com.google.caliper.runner.instrument.Instrument;
import com.google.caliper.runner.instrument.InstrumentComponent;
import com.google.caliper.runner.instrument.InstrumentInjectorModule;
import com.google.caliper.runner.instrument.NanoTimeGranularity;
import com.google.caliper.runner.instrument.NanoTimeGranularityModule;
import com.google.caliper.runner.instrument.RuntimeInstrument;
import com.google.caliper.runner.options.CaliperOptions;
import com.google.caliper.util.InvalidCommandException;
import com.google.caliper.util.ShortDuration;
import com.google.caliper.util.Stderr;
import com.google.caliper.util.Util;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import dagger.MapKey;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoMap;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import javax.inject.Provider;

@Module(includes={NanoTimeGranularityModule.class})
public abstract class InstrumentModule {
    private InstrumentModule() {
    }

    @Provides
    @IntoMap
    @InstrumentClassKey(value=ArbitraryMeasurementInstrument.class)
    static Instrument provideArbitraryMeasurementInstrument() {
        return new ArbitraryMeasurementInstrument();
    }

    @Provides
    @IntoMap
    @InstrumentClassKey(value=RuntimeInstrument.class)
    static Instrument provideRuntimeInstrument(@NanoTimeGranularity ShortDuration nanoTimeGranularity) {
        return new RuntimeInstrument(nanoTimeGranularity);
    }

    @RunScoped
    @Provides
    static ImmutableSet<Instrument> provideInstruments(CaliperOptions options, CaliperConfig config, Map<Class<? extends Instrument>, Provider<Instrument>> availableInstruments, ImmutableSet<VmType> vmTypes, @Stderr PrintWriter stderr) throws InvalidCommandException {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ImmutableSet<String> configuredInstruments = config.getConfiguredInstruments();
        ImmutableSet<String> selectedInstruments = options.instrumentNames();
        if (selectedInstruments.isEmpty()) {
            selectedInstruments = config.getDefaultInstruments();
        }
        for (String instrumentName : selectedInstruments) {
            if (!configuredInstruments.contains((Object)instrumentName)) {
                throw new InvalidCommandException("%s is not a configured instrument (%s). use --print-config to see the configured instruments.", new Object[]{instrumentName, configuredInstruments});
            }
            InstrumentConfig instrumentConfig = config.getInstrumentConfig(instrumentName);
            String className = instrumentConfig.className();
            try {
                Class<Instrument> clazz = Util.lenientClassForName((String)className).asSubclass(Instrument.class);
                Provider<Instrument> instrumentProvider = availableInstruments.get(clazz);
                if (instrumentProvider == null) {
                    throw new InvalidInstrumentException("Instrument %s not supported", new Object[]{className});
                }
                if (InstrumentModule.isSupportedByAllVms(clazz, vmTypes)) {
                    Instrument instrument = (Instrument)instrumentProvider.get();
                    InstrumentInjectorModule injectorModule = new InstrumentInjectorModule(instrumentConfig, instrumentName);
                    InstrumentComponent instrumentComponent = DaggerInstrumentComponent.builder().instrumentInjectorModule(injectorModule).build();
                    instrumentComponent.injectInstrument(instrument);
                    builder.add((Object)instrument);
                    continue;
                }
                stderr.format("Instrument %s not supported on at least one target VM; ignoring\n", className);
            }
            catch (ClassNotFoundException e) {
                throw new InvalidCommandException("Cannot find instrument class '%s'", new Object[]{className});
            }
        }
        return builder.build();
    }

    private static boolean isSupportedByAllVms(Class<?> instrumentClass, ImmutableSet<VmType> vmTypes) {
        for (VmType vmType : vmTypes) {
            if (vmType.supports(instrumentClass)) continue;
            return false;
        }
        return true;
    }

    @Provides
    static ImmutableSet<Instrument.InstrumentedMethod> provideInstrumentedMethods(CaliperOptions options, BenchmarkClassModel benchmarkClass, ImmutableSet<Instrument> instruments) throws InvalidBenchmarkException {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ImmutableSet<String> benchmarkMethodNames = options.benchmarkMethodNames();
        HashSet<String> unusedBenchmarkNames = new HashSet<String>((Collection<String>)benchmarkMethodNames);
        for (Instrument instrument : instruments) {
            for (BenchmarkClassModel.MethodModel method : InstrumentModule.findAllBenchmarkMethods(benchmarkClass, instrument)) {
                if (!benchmarkMethodNames.isEmpty() && !benchmarkMethodNames.contains((Object)method.name())) continue;
                builder.add((Object)instrument.createInstrumentedMethod(method));
                unusedBenchmarkNames.remove(method.name());
            }
        }
        if (!unusedBenchmarkNames.isEmpty()) {
            throw new InvalidBenchmarkException("Invalid benchmark method(s) specified in options: %s", new Object[]{unusedBenchmarkNames});
        }
        return builder.build();
    }

    private static ImmutableSortedSet<BenchmarkClassModel.MethodModel> findAllBenchmarkMethods(BenchmarkClassModel benchmarkClass, Instrument instrument) throws InvalidBenchmarkException {
        ImmutableSortedSet.Builder result = ImmutableSortedSet.orderedBy((Comparator)Ordering.natural().onResultOf((Function)new Function<BenchmarkClassModel.MethodModel, String>(){

            public String apply(BenchmarkClassModel.MethodModel method) {
                return method.name();
            }
        }));
        HashSet<String> benchmarkMethodNames = new HashSet<String>();
        TreeSet<String> overloadedMethodNames = new TreeSet<String>();
        for (BenchmarkClassModel.MethodModel method : benchmarkClass.methods()) {
            if (!instrument.isBenchmarkMethod(method)) continue;
            result.add((Object)method);
            if (benchmarkMethodNames.add(method.name())) continue;
            overloadedMethodNames.add(method.name());
        }
        if (!overloadedMethodNames.isEmpty()) {
            throw new InvalidBenchmarkException("Overloads are disallowed for benchmark methods, found overloads of %s in benchmark %s", new Object[]{overloadedMethodNames, benchmarkClass.simpleName()});
        }
        return result.build();
    }

    @MapKey
    public static @interface InstrumentClassKey {
        public Class<? extends Instrument> value();
    }
}

