/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow.nullnesspropagation;

import com.google.errorprone.dataflow.AccessPath;
import com.google.errorprone.dataflow.AccessPathValues;
import com.google.errorprone.dataflow.nullnesspropagation.MethodInfo;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnnotations;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessPropagationTransfer;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;

class TrustingNullnessPropagation
extends NullnessPropagationTransfer {
    private static final long serialVersionUID = -3128676755493202966L;

    TrustingNullnessPropagation() {
        super(Nullness.NONNULL, (Predicate<MethodInfo>)((Object)TrustReturnAnnotation.INSTANCE));
    }

    @Override
    Nullness fieldNullness(@Nullable NullnessPropagationTransfer.ClassAndField accessed, @Nullable AccessPath path, AccessPathValues<Nullness> store) {
        if (accessed == null) {
            return this.defaultAssumption;
        }
        return this.standardFieldNullness(accessed, path, store);
    }

    private static enum TrustReturnAnnotation implements com.google.common.base.Predicate<MethodInfo>
    {
        INSTANCE;


        public boolean apply(MethodInfo input) {
            return NullnessAnnotations.fromAnnotationMirrors(input.annotations()).orElse(Nullness.NONNULL) == Nullness.NONNULL;
        }
    }
}

