/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.AbstractTester;
import com.google.common.collect.testing.DerivedCollectionGenerators;
import com.google.common.collect.testing.FeatureSpecificTestSuiteBuilder;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestSortedSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.testers.SortedSetNavigationTester;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.TestSuite;

@GwtIncompatible
public class SortedSetTestSuiteBuilder<E>
extends SetTestSuiteBuilder<E> {
    public static <E> SortedSetTestSuiteBuilder<E> using(TestSortedSetGenerator<E> generator) {
        SortedSetTestSuiteBuilder<E> builder = new SortedSetTestSuiteBuilder<E>();
        builder.usingGenerator(generator);
        return builder;
    }

    @Override
    protected List<Class<? extends AbstractTester>> getTesters() {
        List<Class<? extends AbstractTester>> testers = Helpers.copyToList(super.getTesters());
        testers.add(SortedSetNavigationTester.class);
        return testers;
    }

    @Override
    public TestSuite createTestSuite() {
        if (!this.getFeatures().contains(CollectionFeature.KNOWN_ORDER)) {
            List<Feature<?>> features = Helpers.copyToList(this.getFeatures());
            features.add(CollectionFeature.KNOWN_ORDER);
            this.withFeatures(features);
        }
        return super.createTestSuite();
    }

    @Override
    protected List<TestSuite> createDerivedSuites(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<Collection<E>, E>> parentBuilder) {
        List<TestSuite> derivedSuites = super.createDerivedSuites(parentBuilder);
        if (!parentBuilder.getFeatures().contains(CollectionFeature.SUBSET_VIEW)) {
            derivedSuites.add(this.createSubsetSuite(parentBuilder, DerivedCollectionGenerators.Bound.NO_BOUND, DerivedCollectionGenerators.Bound.EXCLUSIVE));
            derivedSuites.add(this.createSubsetSuite(parentBuilder, DerivedCollectionGenerators.Bound.INCLUSIVE, DerivedCollectionGenerators.Bound.NO_BOUND));
            derivedSuites.add(this.createSubsetSuite(parentBuilder, DerivedCollectionGenerators.Bound.INCLUSIVE, DerivedCollectionGenerators.Bound.EXCLUSIVE));
        }
        return derivedSuites;
    }

    final TestSuite createSubsetSuite(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<Collection<E>, E>> parentBuilder, DerivedCollectionGenerators.Bound from, DerivedCollectionGenerators.Bound to) {
        TestSortedSetGenerator delegate = (TestSortedSetGenerator)parentBuilder.getSubjectGenerator().getInnerGenerator();
        ArrayList features = new ArrayList(parentBuilder.getFeatures());
        features.remove(CollectionFeature.ALLOWS_NULL_VALUES);
        features.add(CollectionFeature.SUBSET_VIEW);
        return ((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)this.newBuilderUsing(delegate, to, from).named(parentBuilder.getName() + " subSet " + (Object)((Object)from) + "-" + (Object)((Object)to))).withFeatures(features)).suppressing(parentBuilder.getSuppressedTests())).withSetUp(parentBuilder.getSetUp())).withTearDown(parentBuilder.getTearDown())).createTestSuite();
    }

    SortedSetTestSuiteBuilder<E> newBuilderUsing(TestSortedSetGenerator<E> delegate, DerivedCollectionGenerators.Bound to, DerivedCollectionGenerators.Bound from) {
        return SortedSetTestSuiteBuilder.using(new DerivedCollectionGenerators.SortedSetSubsetTestSetGenerator<E>(delegate, to, from));
    }
}

