/*
 * Decompiled with CFR 0.152.
 */
package scalax.io.support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$any2stringadd$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scalax.io.DefaultResourceContext$;
import scalax.io.OpenOption;
import scalax.io.Resource$;
import scalax.io.StandardOpenOption$;
import scalax.io.extractor.FileChannelExtractor$;
import scalax.io.extractor.ReadableByteChannelExtractor$;
import scalax.io.extractor.WritableByteChannelExtractor$;
import scalax.io.managed.OutputStreamResource;
import scalax.io.nio.SeekableFileChannel;
import scalax.io.support.DeletingFileOutputStream;

public final class FileUtils$ {
    public static FileUtils$ MODULE$;

    static {
        new FileUtils$();
    }

    public OutputStreamResource<FileOutputStream> openOutputStream(File jfile, Seq<OpenOption> openOptions) {
        return Resource$.MODULE$.fromOutputStream((Function0<FileOutputStream> & java.io.Serializable & Serializable)() -> {
            Tuple2<Object, Seq<OpenOption>> tuple2 = MODULE$.preOpen(jfile, openOptions, true);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            boolean append = tuple2._1$mcZ$sp();
            Seq<OpenOption> options = tuple2._2();
            Tuple2<Boolean, Seq<OpenOption>> tuple22 = new Tuple2<Boolean, Seq<OpenOption>>(BoxesRunTime.boxToBoolean(append), options);
            Tuple2<Boolean, Seq<OpenOption>> tuple23 = tuple22;
            boolean append2 = tuple23._1$mcZ$sp();
            Seq<OpenOption> options2 = tuple23._2();
            return options2.contains(StandardOpenOption$.MODULE$.DeleteOnClose()) ? new DeletingFileOutputStream(jfile, append2) : new FileOutputStream(jfile, append2);
        });
    }

    public SeekableFileChannel openChannel(RandomAccessFile raf, Seq<OpenOption> openOptions) {
        if (openOptions.contains(StandardOpenOption$.MODULE$.DeleteOnClose())) {
            throw new UnsupportedOperationException("DeleteOnClose is not supported on FileChannels pre Java 7 implementations.");
        }
        if (openOptions.contains(StandardOpenOption$.MODULE$.Truncate()) && openOptions.exists((Function1<OpenOption, Object> & java.io.Serializable & Serializable)opt -> BoxesRunTime.boxToBoolean(FileUtils$.$anonfun$openChannel$1(opt)))) {
            raf.setLength(0L);
        }
        if (openOptions.contains(StandardOpenOption$.MODULE$.Append())) {
            raf.seek(raf.length());
        }
        return new SeekableFileChannel(raf.getChannel());
    }

    public SeekableFileChannel openChannel(File jfile, Seq<OpenOption> openOptions) {
        Seq<OpenOption> options;
        Tuple2<Object, Seq<OpenOption>> tuple2 = this.preOpen(jfile, openOptions, false);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq<OpenOption> seq = options = tuple2._2();
        Seq<OpenOption> options2 = seq;
        if (options2.contains(StandardOpenOption$.MODULE$.DeleteOnClose())) {
            throw new UnsupportedOperationException("DeleteOnClose is not supported on FileChannels pre Java 7 implementations.");
        }
        return this.openChannel(this.randomAccessFile(jfile, options2), options2);
    }

    private Tuple2<Object, Seq<OpenOption>> preOpen(File jfile, Seq<OpenOption> openOptions, boolean processTruncate) {
        Seq<OpenOption> options = openOptions.isEmpty() ? StandardOpenOption$.MODULE$.WriteTruncate() : openOptions;
        BooleanRef append = BooleanRef.create(false);
        options.foreach((Function1<OpenOption, Object> & java.io.Serializable & Serializable)x0$1 -> {
            void var5_13;
            OpenOption openOption = x0$1;
            Enumeration.Val val = StandardOpenOption$.MODULE$.Append();
            OpenOption openOption2 = openOption;
            if (!(val != null ? !((Object)val).equals(openOption2) : openOption2 != null)) {
                append$1.elem = true;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return var5_13;
            }
            Enumeration.Val val2 = StandardOpenOption$.MODULE$.Create();
            OpenOption openOption3 = openOption;
            if (!(val2 != null ? !((Object)val2).equals(openOption3) : openOption3 != null) && !jfile.exists()) {
                Boolean bl = BoxesRunTime.boxToBoolean(jfile.createNewFile());
                return var5_13;
            }
            Enumeration.Val val3 = StandardOpenOption$.MODULE$.CreateFull();
            OpenOption openOption4 = openOption;
            if (!(val3 != null ? !((Object)val3).equals(openOption4) : openOption4 != null) && !jfile.exists()) {
                Option parent = Option$.MODULE$.apply(jfile.getParentFile()).orElse((Function0<Option> & java.io.Serializable & Serializable)() -> Option$.MODULE$.apply(jfile.getAbsoluteFile().getParentFile()));
                ((File)parent.getOrElse((Function0<Nothing$> & java.io.Serializable & Serializable)() -> {
                    throw new IOException("unable to get parent file of" + jfile);
                })).mkdirs();
                Boolean bl = BoxesRunTime.boxToBoolean(jfile.createNewFile());
                return var5_13;
            }
            Enumeration.Val val4 = StandardOpenOption$.MODULE$.CreateNew();
            OpenOption openOption5 = openOption;
            if (!(val4 != null ? !((Object)val4).equals(openOption5) : openOption5 != null)) {
                if (jfile.exists()) {
                    throw new IOException(Predef$any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(jfile), " already exists, openOption '") + StandardOpenOption$.MODULE$.CreateNew() + "' cannot be used with an existing file");
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return var5_13;
            }
            Enumeration.Val val5 = StandardOpenOption$.MODULE$.Truncate();
            OpenOption openOption6 = openOption;
            if (!(val5 != null ? !((Object)val5).equals(openOption6) : openOption6 != null)) {
                if (processTruncate && options.exists((Function1<OpenOption, Object> & java.io.Serializable & Serializable)opt -> BoxesRunTime.boxToBoolean(FileUtils$.$anonfun$preOpen$4(opt))) && jfile.length() > 0L) {
                    new FileOutputStream(jfile).close();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return var5_13;
                }
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return var5_13;
        });
        return new Tuple2<Object, Seq<OpenOption>>(BoxesRunTime.boxToBoolean(append.elem), options);
    }

    private RandomAccessFile randomAccessFile(File jfile, Seq<OpenOption> openOptions) {
        Seq unsortedChars = openOptions.collect(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends OpenOption, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Character c;
                boolean bl;
                A1 A1 = x1;
                Enumeration.Val val = StandardOpenOption$.MODULE$.Write();
                A1 A12 = A1;
                if (!(val != null ? !((Object)val).equals(A12) : A12 != null)) {
                    bl = true;
                } else {
                    Enumeration.Val val2 = StandardOpenOption$.MODULE$.Append();
                    A1 A13 = A1;
                    bl = !(val2 != null ? !((Object)val2).equals(A13) : A13 != null);
                }
                if (bl) {
                    c = BoxesRunTime.boxToCharacter('w');
                } else {
                    Enumeration.Val val3 = StandardOpenOption$.MODULE$.Read();
                    A1 A14 = A1;
                    if (!(val3 != null ? !((Object)val3).equals(A14) : A14 != null)) {
                        c = BoxesRunTime.boxToCharacter('r');
                    } else {
                        Enumeration.Val val4 = StandardOpenOption$.MODULE$.Sync();
                        A1 A15 = A1;
                        if (!(val4 != null ? !((Object)val4).equals(A15) : A15 != null)) {
                            c = BoxesRunTime.boxToCharacter('s');
                        } else {
                            Enumeration.Val val5 = StandardOpenOption$.MODULE$.DSync();
                            A1 A16 = A1;
                            c = !(val5 != null ? !((Object)val5).equals(A16) : A16 != null) ? BoxesRunTime.boxToCharacter('d') : function1.apply(x1);
                        }
                    }
                }
                return (B1)c;
            }

            public final boolean isDefinedAt(OpenOption x1) {
                boolean bl;
                boolean bl2;
                OpenOption openOption = x1;
                Enumeration.Val val = StandardOpenOption$.MODULE$.Write();
                OpenOption openOption2 = openOption;
                if (!(val != null ? !((Object)val).equals(openOption2) : openOption2 != null)) {
                    bl2 = true;
                } else {
                    Enumeration.Val val2 = StandardOpenOption$.MODULE$.Append();
                    OpenOption openOption3 = openOption;
                    bl2 = !(val2 != null ? !((Object)val2).equals(openOption3) : openOption3 != null);
                }
                if (bl2) {
                    bl = true;
                } else {
                    Enumeration.Val val3 = StandardOpenOption$.MODULE$.Read();
                    OpenOption openOption4 = openOption;
                    if (!(val3 != null ? !((Object)val3).equals(openOption4) : openOption4 != null)) {
                        bl = true;
                    } else {
                        Enumeration.Val val4 = StandardOpenOption$.MODULE$.Sync();
                        OpenOption openOption5 = openOption;
                        if (!(val4 != null ? !((Object)val4).equals(openOption5) : openOption5 != null)) {
                            bl = true;
                        } else {
                            Enumeration.Val val5 = StandardOpenOption$.MODULE$.DSync();
                            OpenOption openOption6 = openOption;
                            bl = !(val5 != null ? !((Object)val5).equals(openOption6) : openOption6 != null);
                        }
                    }
                }
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq sortedChars = (Seq)((SeqLike)unsortedChars.distinct()).sortWith((Function2<Object, Object, Object> & java.io.Serializable & Serializable)(x, y) -> BoxesRunTime.boxToBoolean(FileUtils$.$anonfun$randomAccessFile$1(BoxesRunTime.unboxToChar(x), BoxesRunTime.unboxToChar(y))));
        Seq chars = sortedChars.mkString().endsWith("sd") ? (Seq)sortedChars.takeWhile((Function1<Object, Object> & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToBoolean(FileUtils$.$anonfun$randomAccessFile$2(BoxesRunTime.unboxToChar(x$2)))) : sortedChars;
        return chars.contains(BoxesRunTime.boxToCharacter('r')) ? new RandomAccessFile(jfile, chars.mkString()) : new RandomAccessFile(jfile, 'r' + chars.mkString());
    }

    public void copy(InputStream in, OutputStream out) {
        byte[] buf = new byte[4096];
        int read = in.read(buf);
        while (read > -1) {
            if (read == 0) {
                Thread.sleep(100L);
            } else {
                out.write(buf, 0, read);
            }
            read = in.read(buf);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Object copy(ReadableByteChannel in, WritableByteChannel out) {
        void var3_10;
        Tuple2<ReadableByteChannel, WritableByteChannel> tuple2 = new Tuple2<ReadableByteChannel, WritableByteChannel>(in, out);
        if (tuple2 != null) {
            ReadableByteChannel fc = tuple2._1();
            WritableByteChannel oc = tuple2._2();
            if (fc instanceof FileChannel) {
                FileChannel fileChannel = (FileChannel)fc;
                Long l = BoxesRunTime.boxToLong(fileChannel.transferTo(0L, Long.MAX_VALUE, oc));
                return var3_10;
            }
        }
        if (tuple2 != null) {
            ReadableByteChannel ic = tuple2._1();
            WritableByteChannel fc = tuple2._2();
            if (fc instanceof FileChannel) {
                FileChannel fileChannel = (FileChannel)fc;
                Long l = BoxesRunTime.boxToLong(fileChannel.transferFrom(ic, 0L, Long.MAX_VALUE));
                return var3_10;
            }
        }
        ByteBuffer buf = DefaultResourceContext$.MODULE$.createNioBuffer(None$.MODULE$, new Some<Channel>(in), true);
        int read = in.read(buf);
        while (true) {
            java.io.Serializable serializable;
            if (read <= -1) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return var3_10;
            }
            if (read == 0) {
                Thread.sleep(100L);
                serializable = BoxedUnit.UNIT;
            } else {
                buf.flip();
                serializable = BoxesRunTime.boxToInteger(out.write(buf));
            }
            buf.clear();
            read = in.read(buf);
        }
    }

    public Object tryCopy(Function0<BoxedUnit> failureCase, Object in, Object out) {
        Object object;
        Option<FileChannel> inFileChan = FileChannelExtractor$.MODULE$.unapply(in);
        Option<FileChannel> outFileChan = FileChannelExtractor$.MODULE$.unapply(out);
        Option<ReadableByteChannel> readableByteChan = ReadableByteChannelExtractor$.MODULE$.unapply(in);
        Option<WritableByteChannel> writableByteChan = WritableByteChannelExtractor$.MODULE$.unapply(out);
        if (inFileChan.nonEmpty() && outFileChan.nonEmpty()) {
            object = BoxesRunTime.boxToLong(outFileChan.get().transferFrom(inFileChan.get(), 0L, Long.MAX_VALUE));
        } else if (in instanceof InputStream && out instanceof OutputStream) {
            this.copy((InputStream)in, (OutputStream)out);
            object = BoxedUnit.UNIT;
        } else if (readableByteChan.nonEmpty() && outFileChan.nonEmpty()) {
            object = BoxesRunTime.boxToLong(outFileChan.get().transferFrom(readableByteChan.get(), 0L, Long.MAX_VALUE));
        } else if (inFileChan.nonEmpty() && writableByteChan.nonEmpty()) {
            object = BoxesRunTime.boxToLong(inFileChan.get().transferTo(0L, Long.MAX_VALUE, writableByteChan.get()));
        } else if (out instanceof WritableByteChannel && readableByteChan.nonEmpty()) {
            object = this.copy(readableByteChan.get(), (WritableByteChannel)out);
        } else {
            failureCase.apply$mcV$sp();
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$openChannel$1(OpenOption opt) {
        OpenOption openOption = opt;
        Enumeration.Val val = StandardOpenOption$.MODULE$.Write();
        if (openOption == null) {
            if (val == null) return true;
        } else if (openOption.equals(val)) return true;
        OpenOption openOption2 = opt;
        Enumeration.Val val2 = StandardOpenOption$.MODULE$.Append();
        if (openOption2 != null) {
            if (!openOption2.equals(val2)) return false;
            return true;
        }
        if (val2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$preOpen$4(OpenOption opt) {
        OpenOption openOption = opt;
        Enumeration.Val val = StandardOpenOption$.MODULE$.Write();
        if (openOption == null) {
            if (val == null) return true;
        } else if (openOption.equals(val)) return true;
        OpenOption openOption2 = opt;
        Enumeration.Val val2 = StandardOpenOption$.MODULE$.Append();
        if (openOption2 != null) {
            if (!openOption2.equals(val2)) return false;
            return true;
        }
        if (val2 == null) return true;
        return false;
    }

    private static final int value$1(char x) {
        int n;
        char c = x;
        switch (c) {
            case 'r': {
                n = 0;
                break;
            }
            case 'w': {
                n = 1;
                break;
            }
            case 's': {
                n = 2;
                break;
            }
            case 'd': {
                n = 3;
                break;
            }
            default: {
                throw new MatchError(BoxesRunTime.boxToCharacter(c));
            }
        }
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$randomAccessFile$1(char x, char y) {
        return FileUtils$.value$1(x) < FileUtils$.value$1(y);
    }

    public static final /* synthetic */ boolean $anonfun$randomAccessFile$2(char x$2) {
        return x$2 != 's';
    }

    private FileUtils$() {
        MODULE$ = this;
    }
}

