/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.ketch;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.internal.ketch.KetchReplica;
import org.eclipse.jgit.lib.Config;

public class ReplicaConfig {
    private KetchReplica.Participation participation = KetchReplica.Participation.FULL;
    private KetchReplica.CommitMethod commitMethod = KetchReplica.CommitMethod.ALL_REFS;
    private KetchReplica.CommitSpeed commitSpeed = KetchReplica.CommitSpeed.BATCHED;
    private long minRetry = TimeUnit.SECONDS.toMillis(5L);
    private long maxRetry = TimeUnit.MINUTES.toMillis(1L);

    public static ReplicaConfig newFromConfig(Config cfg, String name) {
        return new ReplicaConfig().fromConfig(cfg, name);
    }

    public KetchReplica.Participation getParticipation() {
        return this.participation;
    }

    public KetchReplica.CommitMethod getCommitMethod() {
        return this.commitMethod;
    }

    public KetchReplica.CommitSpeed getCommitSpeed() {
        return this.commitSpeed;
    }

    public long getMinRetry(TimeUnit unit) {
        return unit.convert(this.minRetry, TimeUnit.MILLISECONDS);
    }

    public long getMaxRetry(TimeUnit unit) {
        return unit.convert(this.maxRetry, TimeUnit.MILLISECONDS);
    }

    public ReplicaConfig fromConfig(Config cfg, String name) {
        this.participation = cfg.getEnum("remote", name, "ketch-type", this.participation);
        this.commitMethod = cfg.getEnum("remote", name, "ketch-commit", this.commitMethod);
        this.commitSpeed = cfg.getEnum("remote", name, "ketch-speed", this.commitSpeed);
        this.minRetry = ReplicaConfig.getMillis(cfg, name, "ketch-minRetry", this.minRetry);
        this.maxRetry = ReplicaConfig.getMillis(cfg, name, "ketch-maxRetry", this.maxRetry);
        return this;
    }

    private static long getMillis(Config cfg, String name, String key, long defaultValue) {
        String valStr = cfg.getString("remote", name, key);
        if (valStr == null) {
            return defaultValue;
        }
        if ((valStr = valStr.trim()).isEmpty()) {
            return defaultValue;
        }
        Matcher m3 = UnitMap.PATTERN.matcher(valStr);
        if (!m3.matches()) {
            return defaultValue;
        }
        String digits = m3.group(1);
        String unitName = m3.group(2).trim();
        TimeUnit unit = UnitMap.UNITS.get(unitName);
        if (unit == null) {
            return defaultValue;
        }
        try {
            if (digits.indexOf(46) == -1) {
                return unit.toMillis(Long.parseLong(digits));
            }
            double val = Double.parseDouble(digits);
            return (long)(val * (double)unit.toMillis(1L));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    static class UnitMap {
        static final Pattern PATTERN = Pattern.compile("^([1-9][0-9]*(?:\\.[0-9]*)?)\\s*(.*)$");
        static final Map<String, TimeUnit> UNITS;

        private UnitMap() {
        }

        static {
            HashMap<String, TimeUnit> m3 = new HashMap<String, TimeUnit>();
            TimeUnit u = TimeUnit.MILLISECONDS;
            m3.put("", u);
            m3.put("ms", u);
            m3.put("millis", u);
            m3.put("millisecond", u);
            m3.put("milliseconds", u);
            u = TimeUnit.SECONDS;
            m3.put("s", u);
            m3.put("sec", u);
            m3.put("secs", u);
            m3.put("second", u);
            m3.put("seconds", u);
            u = TimeUnit.MINUTES;
            m3.put("m", u);
            m3.put("min", u);
            m3.put("mins", u);
            m3.put("minute", u);
            m3.put("minutes", u);
            u = TimeUnit.HOURS;
            m3.put("h", u);
            m3.put("hr", u);
            m3.put("hrs", u);
            m3.put("hour", u);
            m3.put("hours", u);
            u = TimeUnit.DAYS;
            m3.put("d", u);
            m3.put("day", u);
            m3.put("days", u);
            UNITS = Collections.unmodifiableMap(m3);
        }
    }
}

