/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.util.GetOpt;
import netscape.ldap.util.LDIF;
import netscape.ldap.util.LDIFAddContent;
import netscape.ldap.util.LDIFAttributeContent;
import netscape.ldap.util.LDIFDeleteContent;
import netscape.ldap.util.LDIFModDNContent;
import netscape.ldap.util.LDIFModifyContent;
import netscape.ldap.util.LDIFRecord;

public class LDAPModify
extends LDAPTool {
    private static boolean m_continuous = false;
    private static boolean m_force = false;
    private static boolean m_add = false;
    private static boolean m_binaryFiles = false;
    private static String m_rejectsFile = null;
    private static LDIF m_ldif = null;
    private static String m_file = null;

    public static void main(String[] stringArray) {
        LDAPModify.extractParameters(stringArray);
        try {
            if (!m_justShow) {
                m_client = new LDAPConnection();
                m_client.connect(m_ldaphost, m_ldapport);
            }
        }
        catch (Exception exception) {
            System.err.println("Error: client connection failed!");
            System.exit(0);
        }
        try {
            if (!m_justShow) {
                m_client.authenticate(m_version, m_binddn, m_passwd);
            }
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            System.exit(0);
        }
        try {
            m_ldif = m_file != null ? new LDIF(m_file) : new LDIF();
        }
        catch (Exception exception) {
            if (m_file == null) {
                m_file = "stdin";
            }
            System.err.println("Failed to read LDIF file " + m_file + ", " + exception.toString());
            System.exit(0);
        }
        try {
            LDAPModify.doModify();
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
        try {
            if (!m_justShow) {
                m_client.disconnect();
            }
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
        System.exit(0);
    }

    private static void doUsage() {
        System.err.println("usage: LDAPModify [options]");
        System.err.println("options");
        System.err.println("  -h host       LDAP server name or IP address");
        System.err.println("  -p port       LDAP server TCP port number");
        System.err.println("  -V version    LDAP protocol version number (default is 3)");
        System.err.println("  -D binddn     bind dn");
        System.err.println("  -w password   bind passwd (for simple authentication)");
        System.err.println("  -d level      set LDAP debugging level to 'level'");
        System.err.println("  -R            do not automatically follow referrals");
        System.err.println("  -O hop limit  maximum number of referral hops to traverse");
        System.err.println("  -H            display usage information");
        System.err.println("  -c            continuous mode (do not stop on errors)");
        System.err.println("  -M            manage references (treat them as regular entries)");
        System.err.println("  -f file       read modifications from file instead of standard input");
        System.err.println("  -a            add entries");
        System.err.println("  -b            read values that start with / from files (for bin attrs)");
        System.err.println("  -n            show what would be done but don't actually do it");
        System.err.println("  -v            run in verbose mode");
        System.err.println("  -r            replace existing values by default");
        System.err.println("  -e rejectfile save rejected entries in 'rejfile'");
        System.err.println("  -y proxy-DN   DN to use for access control");
    }

    protected static void extractParameters(String[] stringArray) {
        String string = "abcHFre:f:";
        GetOpt getOpt = LDAPTool.extractParameters(string, stringArray);
        if (getOpt.hasOption('H')) {
            LDAPModify.doUsage();
            System.exit(0);
        }
        if (getOpt.hasOption('F')) {
            m_force = true;
        }
        if (getOpt.hasOption('a')) {
            m_add = true;
        }
        if (getOpt.hasOption('c')) {
            m_continuous = true;
        }
        if (getOpt.hasOption('r')) {
            m_add = false;
        }
        if (getOpt.hasOption('b')) {
            m_binaryFiles = true;
        }
        if (getOpt.hasOption('f')) {
            m_file = getOpt.getOptionParam('f');
        }
        if (getOpt.hasOption('e')) {
            m_rejectsFile = getOpt.getOptionParam('e');
        }
    }

    private static void doModify() throws IOException {
        Object object;
        Serializable serializable;
        PrintWriter printWriter = null;
        Object[] objectArray = null;
        if (!m_justShow) {
            objectArray = m_client.getConstraints();
            serializable = new Vector();
            if (m_proxyControl != null) {
                ((Vector)serializable).addElement(m_proxyControl);
            }
            if (m_ordinary) {
                ((Vector)serializable).addElement(new LDAPControl("2.16.840.1.113730.3.4.2", true, null));
            }
            if (((Vector)serializable).size() > 0) {
                object = new LDAPControl[((Vector)serializable).size()];
                ((Vector)serializable).copyInto((Object[])object);
                objectArray.setServerControls((LDAPControl[])object);
            }
            objectArray.setReferrals(m_referrals);
            if (m_referrals) {
                LDAPModify.setDefaultReferralCredentials((LDAPConstraints)objectArray);
            }
            objectArray.setHopLimit(m_hopLimit);
        }
        serializable = m_ldif.nextRecord();
        while (serializable != null) {
            int n;
            LDAPAttribute[] lDAPAttributeArray;
            int n2;
            Serializable[] serializableArray;
            Object object2;
            LDAPControl[] lDAPControlArray;
            object = objectArray;
            if (!m_justShow && (lDAPControlArray = ((LDIFRecord)serializable).getControls()) != null) {
                object2 = lDAPControlArray;
                serializableArray = objectArray.getServerControls();
                if (serializableArray != null) {
                    object2 = new LDAPControl[serializableArray.length + lDAPControlArray.length];
                    for (n2 = 0; n2 < serializableArray.length; ++n2) {
                        object2[n2] = serializableArray[n2];
                    }
                    for (n2 = 0; n2 < lDAPControlArray.length; ++n2) {
                        object2[n2 + serializableArray.length] = lDAPControlArray[n2];
                    }
                }
                object = (LDAPSearchConstraints)objectArray.clone();
                ((LDAPConstraints)object).setServerControls((LDAPControl[])object2);
            }
            lDAPControlArray = ((LDIFRecord)serializable).getContent();
            object2 = null;
            serializableArray = null;
            n2 = 0;
            boolean bl = false;
            LDAPEntry lDAPEntry = null;
            if (lDAPControlArray instanceof LDIFModifyContent) {
                object2 = ((LDIFModifyContent)lDAPControlArray).getModifications();
            } else if (lDAPControlArray instanceof LDIFAddContent) {
                serializableArray = ((LDIFAddContent)lDAPControlArray).getAttributes();
            } else if (lDAPControlArray instanceof LDIFAttributeContent) {
                if (m_add) {
                    serializableArray = ((LDIFAttributeContent)lDAPControlArray).getAttributes();
                } else {
                    lDAPAttributeArray = ((LDIFAttributeContent)lDAPControlArray).getAttributes();
                    object2 = new LDAPModification[lDAPAttributeArray.length];
                    for (n = 0; n < lDAPAttributeArray.length; ++n) {
                        object2[n] = new LDAPModification(2, lDAPAttributeArray[n]);
                    }
                }
            } else if (lDAPControlArray instanceof LDIFDeleteContent) {
                n2 = 1;
            } else if (lDAPControlArray instanceof LDIFModDNContent) {
                bl = true;
            }
            if (serializableArray != null) {
                lDAPAttributeArray = new LDAPAttributeSet();
                for (n = 0; n < serializableArray.length; ++n) {
                    lDAPAttributeArray.add((LDAPAttribute)serializableArray[n]);
                }
                lDAPEntry = new LDAPEntry(((LDIFRecord)serializable).getDN(), (LDAPAttributeSet)lDAPAttributeArray);
            }
            boolean bl2 = false;
            if (m_binaryFiles) {
                LDAPAttribute lDAPAttribute;
                if (object2 != null) {
                    for (n = 0; n < ((LDAPControl[])object2).length; ++n) {
                        LDAPControl lDAPControl = object2[n];
                        LDAPAttribute lDAPAttribute2 = ((LDAPModification)((Object)object2[n])).getAttribute();
                        lDAPAttribute = LDAPModify.checkFiles(lDAPAttribute2);
                        if (lDAPAttribute == null) {
                            bl2 = true;
                            continue;
                        }
                        object2[n] = new LDAPModification(((LDAPModification)((Object)lDAPControl)).getOp(), lDAPAttribute);
                    }
                } else if (serializableArray != null) {
                    LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                    for (int i = 0; i < serializableArray.length; ++i) {
                        Serializable serializable2 = serializableArray[i];
                        lDAPAttribute = LDAPModify.checkFiles((LDAPAttribute)serializable2);
                        if (lDAPAttribute == null) {
                            bl2 = true;
                            break;
                        }
                        lDAPAttributeSet.add(lDAPAttribute);
                    }
                    if (!bl2) {
                        lDAPEntry = new LDAPEntry(((LDIFRecord)serializable).getDN(), lDAPAttributeSet);
                    }
                }
            }
            n = 0;
            if (!bl2) {
                try {
                    if (object2 != null) {
                        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
                        System.out.println("\nmodifying entry " + ((LDIFRecord)serializable).getDN());
                        for (int i = 0; i < ((LDAPControl[])object2).length; ++i) {
                            if (m_verbose) {
                                System.out.println("\t" + object2[i]);
                            }
                            lDAPModificationSet.add(((LDAPModification)((Object)object2[i])).getOp(), ((LDAPModification)((Object)object2[i])).getAttribute());
                        }
                        if (!m_justShow) {
                            m_client.modify(((LDIFRecord)serializable).getDN(), lDAPModificationSet, (LDAPConstraints)object);
                        }
                    } else if (lDAPEntry != null) {
                        System.out.println("\nadding new entry " + lDAPEntry.getDN());
                        if (m_verbose) {
                            LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
                            for (int i = 0; i < lDAPAttributeSet.size(); ++i) {
                                System.out.println("\t" + lDAPAttributeSet.elementAt(i));
                            }
                        }
                        if (!m_justShow) {
                            m_client.add(lDAPEntry, (LDAPConstraints)object);
                        }
                    } else if (n2 != 0) {
                        System.out.println("\ndeleting entry " + ((LDIFRecord)serializable).getDN());
                        if (!m_justShow) {
                            m_client.delete(((LDIFRecord)serializable).getDN(), (LDAPConstraints)object);
                        }
                    } else if (bl) {
                        System.out.println("\nmodifying RDN of entry " + ((LDIFRecord)serializable).getDN() + " and/or moving it beneath a new parent");
                        if (m_verbose) {
                            System.out.println("\t" + lDAPControlArray.toString());
                        }
                        if (!m_justShow) {
                            LDIFModDNContent lDIFModDNContent = (LDIFModDNContent)lDAPControlArray;
                            m_client.rename(((LDIFRecord)serializable).getDN(), lDIFModDNContent.getRDN(), lDIFModDNContent.getNewParent(), lDIFModDNContent.getDeleteOldRDN(), (LDAPConstraints)object);
                            System.out.println("rename completed");
                        }
                    }
                }
                catch (LDAPException lDAPException) {
                    System.err.println(((LDIFRecord)serializable).getDN() + ": " + lDAPException.errorCodeToString());
                    if (lDAPException.getLDAPErrorMessage() != null) {
                        System.err.println("additional info: " + lDAPException.getLDAPErrorMessage());
                    }
                    if (!m_continuous) {
                        System.exit(1);
                    }
                    bl2 = true;
                    n = lDAPException.getLDAPResultCode();
                }
            }
            if (bl2 && m_rejectsFile != null) {
                try {
                    if (printWriter == null) {
                        printWriter = new PrintWriter(new FileOutputStream(m_rejectsFile));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (printWriter != null) {
                    printWriter.println("dn: " + ((LDIFRecord)serializable).getDN() + " # Error: " + n);
                    if (object2 != null) {
                        for (int i = 0; i < ((LDAPControl[])object2).length; ++i) {
                            printWriter.println(((LDAPModification)((Object)object2[i])).toString());
                        }
                    } else if (lDAPEntry != null) {
                        printWriter.println("Add " + lDAPEntry.toString());
                    } else if (n2 != 0) {
                        printWriter.println("Delete " + ((LDIFRecord)serializable).getDN());
                    } else if (bl) {
                        printWriter.println("ModDN " + ((LDIFModDNContent)lDAPControlArray).toString());
                    }
                    printWriter.flush();
                }
            }
            serializable = m_ldif.nextRecord();
        }
        System.exit(0);
    }

    private static LDAPAttribute checkFiles(LDAPAttribute lDAPAttribute) {
        LDAPAttribute lDAPAttribute2 = new LDAPAttribute(lDAPAttribute.getName());
        Enumeration enumeration = lDAPAttribute.getStringValues();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string != null && string.length() > 1) {
                    try {
                        File file = new File(string);
                        FileInputStream fileInputStream = new FileInputStream(file);
                        byte[] byArray = new byte[(int)file.length()];
                        fileInputStream.read(byArray, 0, (int)file.length());
                        lDAPAttribute2.addValue(byArray);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        lDAPAttribute2.addValue(string);
                    }
                    catch (IOException iOException) {
                        System.err.println("Unable to read value from file " + string);
                        if (!m_continuous) {
                            System.exit(1);
                        }
                        lDAPAttribute2 = null;
                    }
                    continue;
                }
                lDAPAttribute2.addValue(string);
            }
        } else {
            System.err.println("Failed to do string conversion for " + lDAPAttribute.getName());
        }
        return lDAPAttribute2;
    }
}

