/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.IncorrectClosureArgumentsException;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import groovy.lang.MissingMethodException;
import groovy.lang.Writable;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.codehaus.groovy.runtime.InvokerHelper;

public abstract class Closure
extends GroovyObjectSupport
implements Cloneable,
Runnable {
    private static final Object[] noParameters = new Object[]{null};
    private Object delegate;
    private Object owner;
    private MetaMethod doCallMethod;

    public Closure(Object delegate) {
        this.delegate = delegate;
        this.owner = delegate;
    }

    public Object invokeMethod(String method, Object arguments) {
        return Closure.doInvokeMethod(method, arguments, this);
    }

    private static Object doInvokeMethod(String method, Object arguments, Closure me) {
        if ("doCall".equals(method)) {
            return me.call(arguments);
        }
        if ("call".equals(method)) {
            return me.call(arguments);
        }
        if ("curry".equals(method)) {
            return me.curry(arguments);
        }
        try {
            return me.getMetaClass().invokeMethod((Object)me, method, arguments);
        }
        catch (MissingMethodException e) {
            block10: {
                if (me.owner != me) {
                    try {
                        return InvokerHelper.invokeMethod(me.owner, method, arguments);
                    }
                    catch (GroovyRuntimeException e3) {
                        Object aDelegate = me.delegate;
                        if (aDelegate == null || aDelegate == me.owner || aDelegate == me) break block10;
                        try {
                            return InvokerHelper.invokeMethod(aDelegate, method, arguments);
                        }
                        catch (GroovyRuntimeException e2) {
                            // empty catch block
                        }
                    }
                }
            }
            throw e;
        }
    }

    public Object getProperty(String property) {
        try {
            return this.getMetaClass().getProperty(this, property);
        }
        catch (GroovyRuntimeException e) {
            try {
                return InvokerHelper.getProperty(this.owner, property);
            }
            catch (GroovyRuntimeException e3) {
                if (this.delegate != null && this.delegate != this && this.delegate != this.owner) {
                    try {
                        return InvokerHelper.getProperty(this.delegate, property);
                    }
                    catch (GroovyRuntimeException e2) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
    }

    public void setProperty(String property, Object newValue) {
        try {
            this.getMetaClass().setProperty(this, property, newValue);
            return;
        }
        catch (GroovyRuntimeException e) {
            try {
                InvokerHelper.setProperty(this.owner, property, newValue);
            }
            catch (GroovyRuntimeException e3) {
                if (this.delegate != null & this.delegate != this && this.delegate != this.owner) {
                    try {
                        InvokerHelper.setProperty(this.delegate, property, newValue);
                        return;
                    }
                    catch (GroovyRuntimeException e2) {
                        System.out.println("Caught e2: " + e2);
                    }
                }
                throw e;
            }
            return;
        }
    }

    public Object call() {
        return this.call(null);
    }

    public Object call(Object arguments) {
        MetaMethod method = this.getDoCallMethod();
        Object[] parameters = Closure.getParameters(arguments);
        try {
            method.checkParameters(parameters);
            return method.invoke(this, parameters);
        }
        catch (IllegalArgumentException e) {
            throw new IncorrectClosureArgumentsException(this, arguments, method.getParameterTypes());
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            return Closure.throwRuntimeException(cause);
        }
    }

    protected static Object[] getParameters(Object arguments) {
        if (arguments instanceof Object[]) {
            if (arguments == null || ((Object[])arguments).length == 0) {
                return noParameters;
            }
            return (Object[])arguments;
        }
        return new Object[]{arguments};
    }

    protected MetaMethod getDoCallMethod() {
        if (this.doCallMethod == null) {
            List list;
            MetaClass metaClass = this.getMetaClass();
            if (metaClass == null) {
                metaClass = InvokerHelper.getMetaClass(this);
            }
            if (!(list = metaClass.getMethods("doCall")).isEmpty()) {
                this.doCallMethod = (MetaMethod)list.get(0);
            }
            if (this.doCallMethod == null) {
                throw new MissingMethodException("doCall", this.getClass(), noParameters);
            }
        }
        return this.doCallMethod;
    }

    protected static Object throwRuntimeException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            RuntimeException re = (RuntimeException)throwable;
            throw re;
        }
        throw new GroovyRuntimeException(throwable.getMessage(), throwable);
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }

    public Class[] getParameterTypes() {
        return this.getDoCallMethod().getParameterTypes();
    }

    public Closure asWritable() {
        return new WritableClosure(this);
    }

    public void run() {
        this.call();
    }

    public Closure curry(Object arguments) {
        return new CurriedClosure(this, arguments);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static class CurriedWritableClosure
    extends CurriedClosure
    implements Writable {
        public CurriedWritableClosure(Closure closure, Object arguments) {
            super(closure, arguments);
        }

        public Closure asWritable() {
            return this;
        }

        public void writeTo(Writer out) throws IOException {
            this.call(new Object[]{out});
        }

        public Closure curry(Object arguments) {
            Object[] args = (Object[])arguments;
            Object[] new_curried_args = new Object[this.curried_args.length + args.length];
            System.arraycopy(this.curried_args, 0, new_curried_args, 0, this.curried_args.length);
            System.arraycopy(args, 0, new_curried_args, this.curried_args.length, args.length);
            return new CurriedWritableClosure(this.closure, new_curried_args);
        }

        public Object clone() throws CloneNotSupportedException {
            return new CurriedWritableClosure((Closure)this.closure.clone(), this.curried_args.clone());
        }
    }

    private static class WritableClosure
    extends DelegatingClosure
    implements Writable {
        public WritableClosure(Closure closure) {
            super(closure);
        }

        public Closure asWritable() {
            return this;
        }

        public void writeTo(Writer out) throws IOException {
            this.call(new Object[]{out});
        }

        public Closure curry(Object arguments) {
            return new CurriedWritableClosure(this.closure, arguments);
        }
    }

    private static class CurriedClosure
    extends DelegatingClosure {
        protected final Object[] curried_args;

        public CurriedClosure(Closure closure, Object arguments) {
            super(closure);
            this.curried_args = CurriedClosure.getParameters(arguments);
        }

        public Object call() {
            return this.closure.call(this.curried_args);
        }

        public Object call(Object args) {
            Object[] new_args = (Object[])args;
            Object[] all_args = new Object[new_args.length + this.curried_args.length];
            System.arraycopy(this.curried_args, 0, all_args, 0, this.curried_args.length);
            System.arraycopy(new_args, 0, all_args, this.curried_args.length, new_args.length);
            return this.closure.call(all_args);
        }

        public Closure curry(Object arguments) {
            Object[] args = CurriedClosure.getParameters(arguments);
            Object[] new_curried_args = new Object[this.curried_args.length + args.length];
            System.arraycopy(this.curried_args, 0, new_curried_args, 0, this.curried_args.length);
            System.arraycopy(args, 0, new_curried_args, this.curried_args.length, args.length);
            return new CurriedClosure(this.closure, new_curried_args);
        }

        public Closure asWritable() {
            return new CurriedWritableClosure(this.closure, this.curried_args);
        }

        public Object clone() throws CloneNotSupportedException {
            return new CurriedClosure((Closure)this.closure.clone(), this.curried_args.clone());
        }
    }

    private static class DelegatingClosure
    extends Closure {
        protected final Closure closure;

        public DelegatingClosure(Closure closure) {
            super(closure.delegate);
            this.closure = closure;
        }

        public Object call() {
            return this.closure.call();
        }

        public Object call(Object arguments) {
            return this.closure.call(arguments);
        }

        public Object clone() throws CloneNotSupportedException {
            return this.closure.clone();
        }

        public Object getDelegate() {
            return this.closure.getDelegate();
        }

        protected MetaMethod getDoCallMethod() {
            return this.closure.getDoCallMethod();
        }

        public Class[] getParameterTypes() {
            return this.closure.getParameterTypes();
        }

        public Object getProperty(String property) {
            return this.closure.getProperty(property);
        }

        public Object invokeMethod(String method, Object arguments) {
            return Closure.doInvokeMethod(method, arguments, (Closure)this);
        }

        public void setDelegate(Object delegate) {
            this.closure.setDelegate(delegate);
        }

        public void setProperty(String property, Object newValue) {
            this.closure.setProperty(property, newValue);
        }

        public Closure asWritable() {
            return this.closure.asWritable();
        }

        public Closure curry(Object arguments) {
            return (Closure)this.closure.invokeMethod("curry", arguments);
        }

        public boolean equals(Object arg0) {
            return this.closure.equals(arg0);
        }

        public MetaClass getMetaClass() {
            return this.closure.getMetaClass();
        }

        public int hashCode() {
            return this.closure.hashCode();
        }

        public void setMetaClass(MetaClass metaClass) {
            this.closure.setMetaClass(metaClass);
        }

        public String toString() {
            return this.closure.toString();
        }
    }
}

