/*
 * Decompiled with CFR 0.152.
 */
package groovy.sql;

import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingPropertyException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;

public class GroovyResultSet
extends GroovyObjectSupport {
    private ResultSet resultSet;
    private boolean updated;

    public GroovyResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public Object getProperty(String property) {
        try {
            return this.resultSet.getObject(property);
        }
        catch (SQLException e) {
            throw new MissingPropertyException(property, GroovyResultSet.class, e);
        }
    }

    public void setProperty(String property, Object newValue) {
        try {
            this.resultSet.updateObject(property, newValue);
            this.updated = true;
        }
        catch (SQLException e) {
            throw new MissingPropertyException(property, GroovyResultSet.class, e);
        }
    }

    public boolean next() throws SQLException {
        if (this.updated) {
            this.resultSet.updateRow();
            this.updated = false;
        }
        return this.resultSet.next();
    }

    public boolean previous() throws SQLException {
        if (this.updated) {
            this.resultSet.updateRow();
            this.updated = false;
        }
        return this.resultSet.previous();
    }

    public Object getAt(int index) throws SQLException {
        index = this.normalizeIndex(index);
        return this.resultSet.getObject(index);
    }

    public void putAt(int index, Object newValue) throws SQLException {
        index = this.normalizeIndex(index);
        this.resultSet.updateObject(index, newValue);
    }

    public void add(Map values) throws SQLException {
        this.resultSet.moveToInsertRow();
        Iterator iter = values.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.resultSet.updateObject(entry.getKey().toString(), entry.getValue());
        }
        this.resultSet.insertRow();
    }

    protected int normalizeIndex(int index) throws SQLException {
        if (index < 0) {
            int columnCount = this.resultSet.getMetaData().getColumnCount();
            while ((index += columnCount) < 0) {
            }
        }
        return index + 1;
    }
}

