/***
*
* BNBT Beta 8.0 - A C++ BitTorrent Tracker
* Copyright (C) 2003-2004 Trevor Hogan
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
***/

#include "bnbt.h"
#include "atom.h"
#include "tracker.h"
#include "util.h"

void CTracker :: serverResponseInfo( struct request_t *pRequest, struct response_t *pResponse )
{
	struct bnbttv btv = UTIL_CurrentTime( );

	pResponse->strCode = "200 OK";

	pResponse->mapHeaders.insert( pair<string, string>( "Content-Type", string( "text/html; charset=" ) + gstrCharSet ) );

	pResponse->strContent += "<html>\n";
	pResponse->strContent += "<head>\n";
	pResponse->strContent += "<title>BNBT Tracker Info</title>\n";

	if( !gstrStyle.empty( ) )
		pResponse->strContent += "<link rel=stylesheet type=\"text/css\" href=\"" + gstrStyle + "\">\n";

	pResponse->strContent += "</head>\n";
	pResponse->strContent += "<body>\n";

	if( pRequest->user.strLogin.empty( ) )
		pResponse->strContent += "<p class=\"login1_info\">You are not logged in. Click <a href=\"/login.html\">here</a> to login.</p>\n";
	else
		pResponse->strContent += "<p class=\"login2_info\">You are logged in as <span class=\"username\">" + UTIL_RemoveHTML( pRequest->user.strLogin ) + "</span>. Click <a href=\"/login.html?logout=1\">here</a> to logout.</p>\n";

	pResponse->strContent += "<h3>BNBT Tracker Info</h3>\n";

	if( pRequest->user.iAccess & ACCESS_VIEW )
	{
		time_t tNow = time( NULL );
		char *szTime = asctime( localtime( &tNow ) );
		szTime[strlen( szTime ) - 1] = '\0';

		pResponse->strContent += "<ul>\n";
		pResponse->strContent += "<li><strong>Tracker Version:</strong> BNBT " + string( BNBT_VER ) + "</li>\n";
		pResponse->strContent += "<li><strong>Server Time:</strong> " + string( szTime ) + "</li>\n";
		pResponse->strContent += "<li><strong>Uptime:</strong> " + UTIL_SecondsToString( GetTime( ) ) + "</li>\n";

		if( m_pDFile )
		{
			pResponse->strContent += "<li><strong>Tracking " + CAtomLong( m_pDFile->getValuePtr( )->size( ) ).toString( ) + " Files, ";

			unsigned long iPeers = 0;

			map<string, CAtom *> *pmapDicti = m_pDFile->getValuePtr( );

			for( map<string, CAtom *> :: iterator i = pmapDicti->begin( ); i != pmapDicti->end( ); i++ )
			{
				if( (*i).second->isDicti( ) )
					iPeers += (unsigned long)( (CAtomDicti *)(*i).second )->getValuePtr( )->size( );
			}

			pResponse->strContent += CAtomLong( iPeers ).toString( ) + " Peers";

			if( m_bCountUniquePeers )
				pResponse->strContent += ", " + CAtomLong( m_pIPs->getValuePtr( )->size( ) ).toString( ) + " Unique";

			pResponse->strContent += "</strong></li>\n";
		}

		if( m_pUsers )
			pResponse->strContent += "<li><strong>" + CAtomLong( m_pUsers->getValuePtr( )->size( ) ).toString( ) + " Users</strong></li>\n";

		pResponse->strContent += "</ul>\n";
	}
	else
		pResponse->strContent += "<p class=\"denied\">You are not authorized to view this page.</p>\n";

	if( m_bGen )
		pResponse->strContent += "<p class=\"gen\">Generated in " + UTIL_ElapsedTimeStr( btv, UTIL_CurrentTime( ) ) + " seconds.</p>\n";

	pResponse->strContent += "</body>\n";
	pResponse->strContent += "</html>\n";
}
