/*
 * Decompiled with CFR 0.152.
 */
package ccl.util.test;

import ccl.util.ClassPathUtil;
import ccl.util.Exitable;
import ccl.util.FileUtil;
import ccl.util.IniFile;
import ccl.util.Init;
import ccl.util.NullOutputStream;
import ccl.util.Test;
import ccl.util.Util;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;

public class InitTest
extends Test
implements Exitable {
    private Init _init = null;

    private void _testGetApplicationPath(String sRCSHeader_) throws IOException {
        String sTempDir = FileUtil.createTempDir();
        String sAppDir = FileUtil.concatPath(sTempDir, "classes" + File.separator + "ccl9.26");
        String sTempJar = FileUtil.concatPath(sAppDir, "lib");
        FileUtil.md(sTempJar);
        Init initTemp = new Init(this, null, sRCSHeader_);
        String sOrigJar = initTemp.getApplicationPath();
        sOrigJar = FileUtil.concatPath(sOrigJar, "lib" + File.separator + "ccl.jar");
        sTempJar = sTempJar + File.separator + "inittest.jar";
        FileUtil.copy(sOrigJar, sTempJar);
        String sOrigClasspath = System.getProperty("java.class.path");
        String sTempClasspath = sTempJar + File.pathSeparator + sOrigClasspath;
        System.setProperty("java.class.path", sTempClasspath);
        Init init = new Init(this, null, sRCSHeader_);
        this.Assert(init.getApplicationName().equals("InitTest"), "Application name should be 'Inittest' but is '" + init.getApplicationName() + "'!");
        this.Assert(FileUtil.equalsPath(init.getApplicationPath(), sAppDir), "Application path should be '" + sAppDir + "' but is '" + init.getApplicationPath() + "'!");
        System.setProperty("java.class.path", sOrigClasspath);
        FileUtil.deleteRecursively(sTempDir);
        String sApplicationHome = ClassPathUtil.getApplicationHome(this);
        Util.debug(this, (Object)("_testGetApplicationPath(..).sApplicationHome: " + sApplicationHome));
        String sTestDir = FileUtil.concatPath(ClassPathUtil.getApplicationHome(this), "test");
        String sInittest2File = FileUtil.concatPath(sTestDir, "inittest2.ini");
        String sInittest2Content = FileUtil.readFile(sInittest2File);
        init = new Init(this, null, sRCSHeader_, sInittest2Content);
        this.Assert(init.getKeyValue("ConfigPath").equals("/home/leecc/pp/config"), "ConfigPath (should be '/home/leecc/pp/config'): '" + init.getKeyValue("ConfigPath") + "'");
        String[] asArg = new String[]{"-inifile", sInittest2File};
        init = new Init(this, asArg, sRCSHeader_);
        this.Assert(init.getKeyValue("ConfigPath").equals("/home/leecc/pp/config"), "ConfigPath (should be '/home/leecc/pp/config'): '" + init.getKeyValue("ConfigPath") + "'");
    }

    private void _testCommaInOptionDescription() {
        String sIniFileContent = "[Init]\nAuthor=Chr. Clemens Lee\n\n[Help]\nHelpUsage=\nOptions=localid,exchange\nlocalid=s,m,The local id (e.g. wkn) of a stock.,,,\nexchange=s,o,The stock exchange symbol (e.g. ETR for Xetra, NYS, etc.). By default ETR is used.\n";
        Init init = new Init(this, new String[0], "$Header: /home/clemens/src/java/ccl/src/ccl/util/test/RCS/InitTest.java,v 1.24 2003/10/18 07:53:25 clemens Exp clemens $", sIniFileContent);
        String sHelpMessage = init.getHelpMessage();
        Util.debug(this, (Object)("_testCommaInOptionDescription().helpMessage: '" + sHelpMessage + "'"));
        this.bugIf(Util.isEmpty(sHelpMessage));
        this.bugIf(sHelpMessage.indexOf("NYS") == -1);
        this.bugIf(sHelpMessage.indexOf(",,,") == -1);
    }

    private void _testHardCodedInitContent() {
        String sIniFileContent = "[Init]\nAuthor=Chr. Clemens Lee\n\n[Help]\nHelpUsage=some_parameters\nOptions=localid,exchange\nlocalid=s,m,The local id (e.g. wkn) of a stock.,,,\nexchange=s,o,The stock exchange symbol (e.g. ETR for Xetra, NYS, etc.). By default ETR is used.\n";
        Init init = new Init(this, new String[0], "$Header: /home/clemens/src/java/ccl/src/ccl/util/test/RCS/InitTest.java,v 1.24 2003/10/18 07:53:25 clemens Exp clemens $", sIniFileContent);
        String sHelpMessage = init.getHelpMessage();
        Util.debug(this, (Object)("_testCommaInOptionDescription().helpMessage: '" + sHelpMessage + "'"));
        this.bugIf(sHelpMessage.indexOf("some_parameters") == -1);
    }

    public InitTest() {
    }

    public InitTest(Test pTest_) {
        super(pTest_);
    }

    protected void _doIt() throws Exception {
        String sIniFileContent;
        String sLocalDir = FileUtil.getClassPath(this);
        String sTestIniFile = FileUtil.concatPath(sLocalDir, "test.ini");
        this.bugIf(FileUtil.delete(sTestIniFile), "InitTest: delete funktioniert auch nicht.");
        String sRCSHeader = "$Header: /home/clemens/src/java/ccl/src/ccl/util/test/RCS/InitTest.java,v 1.24 2003/10/18 07:53:25 clemens Exp clemens $";
        Init pInit = new Init(this, null, sRCSHeader);
        this.bugIf(pInit == null, "InitTest");
        int version = pInit.getVersion();
        int release = pInit.getRelease();
        this.bugIf(version != 1, "version: " + version);
        this.bugIf(release < version, "VersionString, Version, Release: " + pInit.getVersionString() + ", " + version + ", " + release);
        pInit.setFileFullName(FileUtil.concatPath(sLocalDir, "test.proj"));
        FileUtil.delete(sTestIniFile);
        String[] asArg = new String[]{"-jedit", "-inifile", FileUtil.concatPath(sLocalDir, "test10.ini")};
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new NullOutputStream()));
            pInit = new Init(this, asArg, sRCSHeader);
            System.setOut(out);
            this.bugIf(false);
        }
        catch (Exception pException) {
            System.setOut(out);
            Util.printlnErr(this, (Object)("_doIt().pException: " + pException));
            pException.printStackTrace();
            this.bugIf(true, "test10.ini failed!");
        }
        if (this._init != null) {
            this.Assert(FileUtil.existsFile(FileUtil.concatPath(this._init.getApplicationPath(), "lib" + File.separator + "ccl.jar")), "Application path: " + this._init.getApplicationPath());
            this.Assert(Util.endsWith(this._init.getHelpBrokerURL(), File.separator + "doc" + File.separator + "ccl.hs"), "Help set: " + this._init.getHelpBrokerURL());
            this.Assert(this._init.getAuthor().equals("Chr. Clemens Lee"));
        }
        this.Assert((sIniFileContent = FileUtil.getResourceAsString(this, "clearsight.ini")).indexOf("\nAuthor=Chr. Clemens Lee\n") != -1);
        String sIniFileName = FileUtil.concatPath(FileUtil.getTempDir(), "clearsight.ini");
        FileUtil.delete(sIniFileName);
        FileUtil.writeFile(sIniFileName, "[Init]\nOldFiles=/home/clemens/bunin/clearsight/test.csml;\nFile=/home/clemens/bunin/clearsight/pp.csml\n");
        asArg = new String[]{"-inifile", sIniFileName};
        Init init = new Init(this, asArg, sRCSHeader, null);
        this.bugIf(Util.isEmpty(init.getKeyValue("File")));
        asArg = new String[]{"-inifile", sIniFileName};
        init = new Init(this, asArg, sRCSHeader, sIniFileContent);
        this.bugIf(Util.isEmpty(init.getKeyValue("File")));
        String sAuthor = IniFile.getKeyValueFromString("Init", "Author", sIniFileContent);
        this.Assert(sAuthor.equals("Chr. Clemens Lee"), "IniFile Author 0: " + sAuthor);
        sAuthor = IniFile.getKeyValue(null, "Init", "Author", sIniFileContent);
        this.Assert(sAuthor.equals("Chr. Clemens Lee"), "IniFile Author 1: " + sAuthor);
        sAuthor = IniFile.getKeyValue(sIniFileName, "Init", "Author", sIniFileContent);
        this.Assert(sAuthor.equals("Chr. Clemens Lee"), "IniFile Author 2: " + sAuthor);
        this.Assert(init.getAuthor().equals("Chr. Clemens Lee"), "Author: " + init.getAuthor());
        this._testGetApplicationPath(sRCSHeader);
        this._testCommaInOptionDescription();
        this._testHardCodedInitContent();
    }

    public void setInit(Init init_) {
        this._init = init_;
    }

    public static void main(String[] args) {
        InitTest pTest = new InitTest();
        pTest.setVerbose(true);
        pTest.run();
        Test.printResult(pTest);
        System.exit(0);
    }

    public void setExit() {
    }
}

