/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing;

import ccl.swing.AutoGridBagLayout;
import ccl.swing.SwingUtil;
import ccl.util.Util;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * $Id: OKCancelDialog.java,v 1.6 2003/05/01 16:44:25 clemens Exp clemens $
 */

public class OKCancelDialog extends ExitJDialog 
{
    private OKCancelPanel _pOKCancelPanel = null;

    public OKCancelDialog( String sMessage_ ) 
{
        this( new Frame(), sMessage_ );
    }

    public OKCancelDialog( Frame frmParent_, String sMessage_ ) 
{
        super( frmParent_, "Dialog", true );
        
        Util.panicIf(sMessage_ == null);

        ((JPanel)getContentPane()).setBorder
               ( BorderFactory.createEmptyBorder( 8, 8, 5, 8 ) );

        AutoGridBagLayout agblLayout = new AutoGridBagLayout();
        agblLayout.setInsets(7);
        getContentPane().setLayout(agblLayout);

        // message lines
        int maxLength = 0;
        Vector vMessages = Util.stringToLines(sMessage_);
        for(Enumeration e = vMessages.elements(); e.hasMoreElements(); ) 
{
            // Message
            String sLine = (String)e.nextElement();
            JLabel lblLine = new JLabel(sLine);
            agblLayout.setAnchor(GridBagConstraints.WEST);
            agblLayout.setExtend(3, 1);
            getContentPane().add(lblLine);
            agblLayout.setExtend(1, 1);
            agblLayout.setAnchor(GridBagConstraints.CENTER);
            if (lblLine.getSize().width > maxLength) 
{
                maxLength = lblLine.getSize().width;
            }
            agblLayout.endLine();
        }

        // Buttons
        _pOKCancelPanel = new OKCancelPanel( this );
        _pOKCancelPanel.setInitialFocusOnOKButton();

        agblLayout.setExpandHorizontal();
        getContentPane().add( new JLabel( " " ) );
        agblLayout.setExpandNone();
        getContentPane().add( _pOKCancelPanel );
        agblLayout.endLine();

        pack();
        SwingUtil.centerComponent(this);
    }

    public boolean isOK() 
{
        return _pOKCancelPanel.isOK();
    }
}
