/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing.test;

import ccl.swing.InputCancelDialog;
import ccl.swing.SwingUtil;
import ccl.util.Test;
import ccl.util.Util;
import java.util.Vector;
import javax.swing.JFrame;

/**
 * Insert your test code into the _doIt() method and
 * test bugs with 'bugIf( boolean expression );' or
 * 'bugIf( boolean expression, "comment about what went wrong" );'.
 * Then just invoke the main routine.
 *
 * @version $Id: InputCancelDialogTest.java,v 1.6 2003/05/01 16:44:35 clemens Exp clemens $
 * @author  Chr. Clemens Lee
 */
public class InputCancelDialogTest extends Test 
{
    public InputCancelDialogTest() 
{
        super();
    }

    public InputCancelDialogTest( Test pTest_ ) 
{
        super( pTest_ );
    }

    /**
     * Insert your test code into the _doIt() method and
     * test bugs with 'bugIf( boolean expression );' or
     * 'bugIf( boolean expression, "comment about what went wrong" );'.
     * Then just invoke the main routine.
     *
     * @exception   Exception   if anything goes wrong.
     */
    protected void _doIt()
        throws Exception
    {
        JFrame frmBig = new JFrame( "test" );
        SwingUtil.maximizeWindow( frmBig );
        frmBig.show();
        Util.sleep( 2 );
        Vector vHistory = new Vector();
        vHistory.addElement( "line 1" );
        vHistory.addElement( "line 12" );
        vHistory.addElement( "line 13" );
        vHistory.addElement( "line 14" );
        vHistory.addElement( "line 15" );
        vHistory.addElement( "line 16" );
        vHistory.addElement( "line 17" );
        vHistory.addElement( "line 18" );
        vHistory.addElement( "line 19" );
        vHistory.addElement( "line 101" );
        vHistory.addElement( "line 181" );
        InputCancelDialog dialog = new InputCancelDialog( frmBig, "Test input", "test", vHistory );
        dialog.show();
        if ( dialog.isOK() ) 
{
            Util.println( dialog.getValue() );
        }
        dialog = new InputCancelDialog( frmBig, "Test input", "test 2" );
        dialog.show();
        if ( dialog.isOK() ) 
{
            Util.println( dialog.getValue() );
        }
        Util.println( InputCancelDialog.input( frmBig, "Test 3: ", "", vHistory ) );
        Util.println( InputCancelDialog.input( frmBig, "Test 3: ", "", vHistory ) );
    }

    public static void main( String[] asArg_ ) 
{
        Test pTest = (Test)(new InputCancelDialogTest());
        pTest.setVerbose( true );
        pTest.run();
        Test.printResult( pTest );

        System.exit( 0 );
    }
}
