#include "chess.h"
/* *INDENT-OFF* */
/*
 ************************************************************
 *                                                          *
 *  Pawn scoring terms.                                     *
 *                                                          *
 ************************************************************
 */
const int pawn_can_promote          = 525;
const int pawn_file_width           =   8;
const int pawn_unsupported[2]       = { -8, -4 };
const int pawn_defects[2][8] = {
  { 0, 0, 0, 1, 2, 3, 0, 0 },               /* [black][8] */
  { 0, 0, 3, 2, 1, 0, 0, 0 }                /* [white][8] */
};
const int passed_pawn[8] = { 0, 0, 0, 2, 6, 12, 21, 0 };
const int passed_pawn_base[2] = { 4, 8 };
const int passed_pawn_free_advance = 8;
const int passed_pawn_free_advance_1 = 5;
const int passed_pawn_defended = 3;
const int passed_pawn_defended_1 = 2;
const int passed_pawn_candidate[2][8] = {
  { 0, 2, 2,  6, 13, 32, 0, 0 },            /* [mg][rank] */
  { 0, 5, 5, 11, 27, 65, 0, 0 }             /* [eg][rank] */
};
const int pawn_doubled[2][8] = {
  { 5,  8,  9,  9,  9,  9,  8,  5},
  {17, 19, 19, 19, 19, 19, 19, 17}
};
const int pawn_isolated[2][8] = {
  {14, 21, 23, 23, 23, 23, 21, 14},
  {10, 14, 16, 16, 16, 16, 14, 10}
};
const int pawn_backward[2][8] = {
  {12, 17, 19, 19, 19, 19, 17, 12},
  { 8, 11, 16, 16, 16, 16, 11,  8}
};
const int pawn_connected[8][8] = {
  {  0,   0,   0,   0,   0,   0,   0,   0},
  {  0,   1,   1,   2,   2,   1,   1,   0},
  {  1,   2,   2,   3,   3,   2,   2,   1},
  {  3,   5,   5,   6,   6,   5,   5,   3},
  { 11,  13,  13,  14,  14,  13,  13,  11},
  { 25,  27,  27,  28,  28,  27,  27,  25},
  { 48,  52,  52,  53,  53,  52,  52,  48},
  {  0,   0,   0,   0,   0,   0,   0,   0}
};
const int pval[2][2][64] = {
  {{ 0,   0,   0,   0,   0,   0,   0,   0,
   -10,   0,   0,   0,   0,   0,   0, -10,
   -10,   0,   0,   0,   0,   0,   0, -10,
   -10,   0,   6,  10,  10,   6,   0, -10,  /* [mg][black][64] */
   -10,   0,  10,  21,  21,  10,   0, -10,
   -10,   0,   7,  11,  11,   7,   0, -10,
   -10,   0,   0,   0,   0,   0,   0, -10,
     0,   0,   0,   0,   0,   0,   0,   0 },

   { 0,   0,   0,   0,   0,   0,   0,   0,
   -10,   0,   0,   0,   0,   0,   0, -10,
   -10,   0,   7,  11,  11,   7,   0, -10,
   -10,   0,  10,  21,  21,  10,   0, -10,  /* [mg][white][64] */
   -10,   0,   6,  10,  10,   6,   0, -10,
   -10,   0,   0,   0,   0,   0,   0, -10,
   -10,   0,   0,   0,   0,   0,   0, -10,
     0,   0,   0,   0,   0,   0,   0,   0 }},

  {{ 0,   0,   0,   0,   0,   0,   0,   0,
    -4,   1,   1,   1,   1,   1,   1,  -4,
    -4,   1,   1,   1,   1,   1,   1,  -4,
    -4,   1,   4,   6,   6,   4,   1,  -4,  /* [eg][black][64] */
    -4,   1,   6,  12,  12,   6,   1,  -4,
    -4,   1,   5,   7,   7,   5,   1,  -4,
    -4,   1,   1,   1,   1,   1,   1,  -4,
     0,   0,   0,   0,   0,   0,   0,   0 },

   { 0,   0,   0,   0,   0,   0,   0,   0,
    -4,   1,   1,   1,   1,   1,   1,  -4,
    -4,   1,   5,   7,   7,   5,   1,  -4,
    -4,   1,   6,  12,  12,   6,   1,  -4,  /* [eg][white][64] */
    -4,   1,   4,   6,   6,   4,   1,  -4,
    -4,   1,   1,   1,   1,   1,   1,  -4,
    -4,   1,   1,   1,   1,   1,   1,  -4,
     0,   0,   0,   0,   0,   0,   0,   0 }}
};
/*
 ************************************************************
 *                                                          *
 *  Knight scoring terms.                                   *
 *                                                          *
 ************************************************************
 */
const int king_tropism_n[8] = { 3, 3, 3, 2, 1, 0, 0, 0 };
const int knight_outpost[2][64] = {
  { 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 4, 4, 4, 4, 1, 0,
    0, 2, 6, 8, 8, 6, 2, 0,
    0, 1, 4, 4, 4, 4, 1, 0,   /* [black][64] */
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0 },

  { 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 4, 4, 4, 4, 1, 0,
    0, 2, 6, 8, 8, 6, 2, 0,   /* [white][64] */
    0, 1, 4, 4, 4, 4, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0 }
};
const int nval[2][2][64] = {
  {{ -41, -29, -27, -15, -15, -27, -29, -41,
      -9,   4,  14,  20,  20,  14,   4,  -9,
      -7,  10,  23,  29,  29,  23,  10,  -7,
      -5,  12,  25,  32,  32,  25,  12,  -5,  /* [mg][black][64] */
      -5,  10,  23,  28,  28,  23,  10,  -5,
      -7,  -2,  19,  19,  19,  19,  -2,  -7,
      -9,  -6,  -2,   0,   0,  -2,  -6,  -9,
     -31, -29, -27, -25, -25, -27, -29, -31 },

   { -31, -29, -27, -25, -25, -27, -29, -31,
      -9,  -6,  -2,   0,   0,  -2,  -6,  -9,
      -7,  -2,  19,  19,  19,  19,  -2,  -7,
      -5,  10,  23,  28,  28,  23,  10,  -5,  /* [mg][white][64] */
      -5,  12,  25,  32,  32,  25,  12,  -5,
      -7,  10,  23,  29,  29,  23,  10,  -7,
      -9,   4,  14,  20,  20,  14,   4,  -9,
     -41, -29, -27, -15, -15, -27, -29, -41 }},

  {{ -41, -29, -27, -15, -15, -27, -29, -41,
      -9,   4,  14,  20,  20,  14,   4,  -9,
      -7,  10,  23,  29,  29,  23,  10,  -7,
      -5,  12,  25,  32,  32,  25,  12,  -5,  /* [eg][black][64] */
      -5,  10,  23,  28,  28,  23,  10,  -5,
      -7,  -2,  19,  19,  19,  19,  -2,  -7,
      -9,  -6,  -2,   0,   0,  -2,  -6,  -9,
     -31, -29, -27, -25, -25, -27, -29, -31 },

   { -31, -29, -27, -25, -25, -27, -29, -31,
      -9,  -6,  -2,   0,   0,  -2,  -6,  -9,
      -7,  -2,  19,  19,  19,  19,  -2,  -7,
      -5,  10,  23,  28,  28,  23,  10,  -5,  /* [eg][white][64] */
      -5,  12,  25,  32,  32,  25,  12,  -5,
      -7,  10,  23,  29,  29,  23,  10,  -7,
      -9,   4,  14,  20,  20,  14,   4,  -9,
     -41, -29, -27, -15, -15, -27, -29, -41 }}
};
/*
 ************************************************************
 *                                                          *
 *  Bishop scoring terms.                                   *
 *                                                          *
 ************************************************************
 */
const int bishop_trapped            = 174;
const int bishop_pawns_on_color[2]  = { 4, 6 };
const int bishop_wing_pawns[2]      = { 18, 36 };
const int bishop_pair[2]            = { 38, 56 };
const int king_tropism_b[8] = { 2, 2, 2, 1, 0, 0, 0, 0 };
const int bishop_outpost[2][64] = {
  { 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 3, 3, 3, 3, 1, 0,
    0, 3, 5, 5, 5, 5, 3, 0,
    0, 1, 2, 2, 2, 2, 1, 0,   /* [black][64] */
    0, 0, 1, 1, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0 },

  { 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 1, 1, 1, 0, 0,
    0, 1, 2, 2, 2, 2, 1, 0,
    0, 3, 5, 5, 5, 5, 3, 0,   /* [white][64] */
    0, 1, 3, 3, 3, 3, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0 }
};
const int bval[2][2][64] = {
  {{  0,   0,   0,   0,   0,   0,   0,   0,
      0,   4,   4,   4,   4,   4,   4,   0,
      0,   4,   8,   8,   8,   8,   4,   0,
      0,   4,   8,  12,  12,   8,   4,   0,
      0,   4,   8,  12,  12,   8,   4,   0,  /* [mg][black][64] */
      0,   4,   8,   8,   8,   8,   4,   0,
      0,   4,   4,   4,   4,   4,   4,   0,
    -15, -15, -15, -15, -15, -15, -15, -15},

   {-15, -15, -15, -15, -15, -15, -15, -15,
      0,   4,   4,   4,   4,   4,   4,   0,
      0,   4,   8,   8,   8,   8,   4,   0,
      0,   4,   8,  12,  12,   8,   4,   0,
      0,   4,   8,  12,  12,   8,   4,   0,  /* [mg][white][64] */
      0,   4,   8,   8,   8,   8,   4,   0,
      0,   4,   4,   4,   4,   4,   4,   0,
      0,   0,   0,   0,   0,   0,   0,   0}},

  {{  0,   0,   0,   0,   0,   0,   0,   0,
      0,   4,   4,   4,   4,   4,   4,   0,
      0,   4,   8,   8,   8,   8,   4,   0,
      0,   4,   8,  12,  12,   8,   4,   0,
      0,   4,   8,  12,  12,   8,   4,   0,  /* [eg][black][64] */
      0,   4,   8,   8,   8,   8,   4,   0,
      0,   4,   4,   4,   4,   4,   4,   0,
    -15, -15, -15, -15, -15, -15, -15, -15},

   {-15, -15, -15, -15, -15, -15, -15, -15,
      0,   4,   4,   4,   4,   4,   4,   0,
      0,   4,   8,   8,   8,   8,   4,   0,
      0,   4,   8,  12,  12,   8,   4,   0,
      0,   4,   8,  12,  12,   8,   4,   0,  /* [eg][white][64] */
      0,   4,   8,   8,   8,   8,   4,   0,
      0,   4,   4,   4,   4,   4,   4,   0,
      0,   0,   0,   0,   0,   0,   0,   0}}
};
/*
 ************************************************************
 *                                                          *
 *  Rook scoring terms.                                     *
 *                                                          *
 ************************************************************
 */
const int rook_on_7th[2]          = { 25, 35 };
const int rook_connected_7th[2]   = {  6, 10 };
const int rook_open_file[2]       = { 35, 20 };
const int rook_half_open_file[2]  = { 10, 10 };
const int king_tropism_r[8] = { 4, 4, 3, 2, 1, 1, 1, 1 };
/*
 ************************************************************
 *                                                          *
 *  Queen scoring terms.                                    *
 *                                                          *
 ************************************************************
 */
const int king_tropism_q[8] = { 6, 6, 5, 4, 3, 2, 2, 2 };
const int qval[2][2][64] = {
   {{ 0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   4,   4,   4,   4,   0,   0,
      0,   4,   4,   6,   6,   4,   4,   0,
      0,   4,   6,   8,   8,   6,   4,   0,
      0,   4,   6,   8,   8,   6,   4,   0,   /* [mg][black][64] */
      0,   4,   4,   6,   6,   4,   4,   0,
      0,   0,   4,   4,   4,   4,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0 },

    { 0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   4,   4,   4,   4,   0,   0,
      0,   4,   4,   6,   6,   4,   4,   0,
      0,   4,   6,   8,   8,   6,   4,   0,
      0,   4,   6,   8,   8,   6,   4,   0,   /* [mg][white][64] */
      0,   4,   4,   6,   6,   4,   4,   0,
      0,   0,   4,   4,   4,   4,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0 }},

   {{ 0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   4,   4,   4,   4,   0,   0,
      0,   4,   4,   6,   6,   4,   4,   0,
      0,   4,   6,   8,   8,   6,   4,   0,
      0,   4,   6,   8,   8,   6,   4,   0,   /* [eg][black][64] */
      0,   4,   4,   6,   6,   4,   4,   0,
      0,   0,   4,   4,   4,   4,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0 },

    { 0,   0,   0,   0,   0,   0,   0,   0,
      0,   0,   4,   4,   4,   4,   0,   0,
      0,   4,   4,   6,   6,   4,   4,   0,
      0,   4,   6,   8,   8,   6,   4,   0,
      0,   4,   6,   8,   8,   6,   4,   0,   /* [eg][white][64] */
      0,   4,   4,   6,   6,   4,   4,   0,
      0,   0,   4,   4,   4,   4,   0,   0,
      0,   0,   0,   0,   0,   0,   0,   0 }}
};
/*
 ************************************************************
 *                                                          *
 *  King scoring terms.                                     *
 *                                                          *
 ************************************************************
 */
int king_safety[16][16];
const int king_safety_mate_threat = 600;
const int king_king_tropism       =  10;
const int open_file[8]            = { 6, 5, 4, 4, 4, 4, 5, 6 };
const int half_open_file[8] = { 4, 4, 3, 3, 3, 3, 4, 4 };
const int safety_vector[16] = {
   0,  7, 14, 21, 28, 35, 42,  49,
  56, 63, 70, 77, 84, 91, 98, 105
};
const int tropism_vector[16] = {
   0,  1,  2,  3,   4,   5,  11,  20,
  32, 47, 65, 86, 110, 137, 167, 200
};
const int kval[2][64] = {
   {-40, -40, -40, -40, -40, -40, -40, -40,
    -40, -10, -10, -10, -10, -10, -10, -40,
    -40, -10,  60,  60,  60,  60, -10, -40,
    -40, -10,  60,  60,  60,  60, -10, -40,
    -40, -10,  40,  40,  40,  40, -10, -40,   /* [black][64] */
    -40, -10,  20,  20,  20,  20, -10, -40,
    -40, -10, -10, -10, -10, -10, -10, -40,
    -40, -40, -40, -40, -40, -40, -40, -40 },

   {-40, -40, -40, -40, -40, -40, -40, -40,
    -40, -10, -10, -10, -10, -10, -10, -40,
    -40, -10,  20,  20,  20,  20, -10, -40,
    -40, -10,  40,  40,  40,  40, -10, -40,
    -40, -10,  60,  60,  60,  60, -10, -40,   /* [white][64] */
    -40, -10,  60,  60,  60,  60, -10, -40,
    -40, -10, -10, -10, -10, -10, -10, -40,
    -40, -40, -40, -40, -40, -40, -40, -40 }
};
/*
 ************************************************************
 *                                                          *
 *  Miscellaneous evaluation constants.                     *
 *                                                          *
 ************************************************************
 */
const int bad_trade = 90;
const int dark_corner[2] =  { FILEA, FILEH };
const int light_corner[2] = { FILEH, FILEA };
const int direction[2] =    { -8, 8 };
const char square_color[64] = {
  1, 0, 1, 0, 1, 0, 1, 0,
  0, 1, 0, 1, 0, 1, 0, 1,
  1, 0, 1, 0, 1, 0, 1, 0,
  0, 1, 0, 1, 0, 1, 0, 1,
  1, 0, 1, 0, 1, 0, 1, 0,
  0, 1, 0, 1, 0, 1, 0, 1,
  1, 0, 1, 0, 1, 0, 1, 0,
  0, 1, 0, 1, 0, 1, 0, 1
};
/*
 ************************************************************
 *                                                          *
 *  Opening phase development terms.                        *
 *                                                          *
 ************************************************************
 */
const int development_thematic      =     12;
const int development_losing_castle =     20;
const int development_not_castled   =     20;
const int wtm_bonus[2]              = { 5, 8 };
/*
 ************************************************************
 *                                                          *
 *  Skill command constants (should not be changed)         *
 *                                                          *
 ************************************************************
 */
uint64_t burner[10] = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 };
const int burnc[10] = {128000, 64000, 32400, 15200, 7600,
                         3800,  1960,  1040,   480,  140};
/*
 ************************************************************
 *                                                          *
 *  Mop-up scoring terms.  These are used in pawnless end-  *
 *  games to mate the weaker side.  There is a special PST  *
 *  B+N vs lone king to make it easier to win with very     *
 *  shallow search depths.                                  *
 *                                                          *
 ************************************************************
 */
const char b_n_mate_dark_squares[64] = {
  99, 90, 80, 70, 60, 50, 40, 30,
  90, 80, 70, 60, 50, 40, 30, 40,
  80, 70, 60, 50, 40, 30, 40, 50,
  70, 60, 50, 40, 30, 40, 50, 60,
  60, 50, 40, 30, 40, 50, 60, 70,
  50, 40, 30, 40, 50, 60, 70, 80,
  40, 30, 40, 50, 60, 70, 80, 90,
  30, 40, 50, 60, 70, 80, 90, 99
};
const char b_n_mate_light_squares[64] = {
  30, 40, 50, 60, 70, 80, 90, 99,
  40, 30, 40, 50, 60, 70, 80, 90,
  50, 40, 30, 40, 50, 60, 70, 80,
  60, 50, 40, 30, 40, 50, 60, 70,
  70, 60, 50, 40, 30, 40, 50, 60,
  80, 70, 60, 50, 40, 30, 40, 50,
  90, 80, 70, 60, 50, 40, 30, 40,
  99, 90, 80, 70, 60, 50, 40, 30
};
const int mate[64] = {
  200, 180, 160, 140, 140, 160, 180, 200,
  180, 160, 140, 120, 120, 140, 160, 180,
  160, 140, 120, 100, 100, 120, 140, 160,
  140, 120, 100, 100, 100, 100, 120, 140,
  140, 120, 100, 100, 100, 100, 120, 140,
  160, 140, 120, 100, 100, 120, 140, 160,
  180, 160, 140, 120, 120, 140, 160, 180,
  200, 180, 160, 140, 140, 160, 180, 200
};
/* *INDENT-ON* */
