/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.BasicVerifier;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceMethodVisitor;
import p.rn.util.FileWalker;

@BaseCmd.Syntax(cmd="d2j-asm-verify", syntax="[options] <jar0> [jar1 ... jarN]", desc="Verify .class in jar")
public class AsmVerify
extends BaseCmd {
    @BaseCmd.Opt(opt="d", longOpt="detail", hasArg=false, description="Print detail error message")
    boolean detail = false;

    private static String getShortName(String name) {
        int n = name.lastIndexOf(47);
        return n == -1 ? name : "o";
    }

    public static void main(String[] args) {
        new AsmVerify().doMain(args);
    }

    static void printAnalyzerResult(MethodNode method, Analyzer a, PrintWriter pw) throws IllegalArgumentException {
        Frame[] frames = a.getFrames();
        XTraceMethodVisitor mv = new XTraceMethodVisitor();
        String format = "%05d %-" + (method.maxStack + method.maxLocals + 6) + "s|%s";
        int j = 0;
        while (j < method.instructions.size()) {
            method.instructions.get(j).accept((MethodVisitor)mv);
            StringBuffer s = new StringBuffer();
            Frame f = frames[j];
            if (f == null) {
                s.append('?');
            } else {
                int k = 0;
                while (k < f.getLocals()) {
                    s.append(AsmVerify.getShortName(f.getLocal(k).toString()));
                    ++k;
                }
                s.append(" : ");
                k = 0;
                while (k < f.getStackSize()) {
                    s.append(AsmVerify.getShortName(f.getStack(k).toString()));
                    ++k;
                }
            }
            pw.printf(format, j, s, mv.getBuf());
            ++j;
        }
        j = 0;
        while (j < method.tryCatchBlocks.size()) {
            ((TryCatchBlockNode)method.tryCatchBlocks.get(j)).accept((MethodVisitor)mv);
            pw.print(" " + mv.getBuf());
            ++j;
        }
        pw.println();
        pw.flush();
    }

    @Override
    protected void doCommandLine() throws Exception {
        if (this.remainingArgs.length < 1) {
            this.usage();
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        String[] stringArray = this.remainingArgs;
        int n = this.remainingArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String fn = stringArray[n2];
            File file = new File(fn);
            if (!file.exists()) {
                System.err.println(String.valueOf(fn) + " is not exists");
                this.usage();
                return;
            }
            files.add(file);
            ++n2;
        }
        for (File file : files) {
            System.out.println("verify " + file);
            new FileWalker().withStreamHandler(new FileWalker.StreamHandler(){

                public void handle(boolean isDir, String name, FileWalker.StreamOpener current, Object nameObject) throws IOException {
                    if (isDir || !name.endsWith(".class")) {
                        return;
                    }
                    InputStream is = current.get();
                    ClassReader cr = new ClassReader(is);
                    ClassNode cn = new ClassNode();
                    cr.accept((ClassVisitor)new CheckClassAdapter((ClassVisitor)cn, false), 10);
                    List methods = cn.methods;
                    int i = 0;
                    while (i < methods.size()) {
                        block4: {
                            MethodNode method = (MethodNode)methods.get(i);
                            BasicVerifier verifier = new BasicVerifier();
                            Analyzer a = new Analyzer((Interpreter)verifier);
                            try {
                                a.analyze(cn.name, method);
                            }
                            catch (Exception ex) {
                                System.err.println("Error verify method " + cr.getClassName() + "." + method.name + " " + method.desc);
                                if (!AsmVerify.this.detail) break block4;
                                ex.printStackTrace(System.err);
                                AsmVerify.printAnalyzerResult(method, a, new PrintWriter(System.err));
                            }
                        }
                        ++i;
                    }
                }
            }).walk(file);
        }
    }

    static class XTraceMethodVisitor
    extends TraceMethodVisitor {
        XTraceMethodVisitor() {
        }

        public StringBuffer getBuf() {
            return this.buf;
        }
    }
}

